/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.type.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.ModelReferenceException;
import org.camunda.bpm.model.xml.UnsupportedModelOperationException;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.camunda.bpm.model.xml.impl.type.reference.ReferenceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.type.child.ChildElementCollection;
import org.camunda.bpm.model.xml.type.reference.ElementReferenceCollection;

public class ElementReferenceCollectionImpl<Target extends ModelElementInstance, Source extends ModelElementInstance>
extends ReferenceImpl<Target>
implements ElementReferenceCollection<Target, Source> {
    private final ChildElementCollection<Source> referenceSourceCollection;
    private ModelElementTypeImpl referenceSourceType;

    public ElementReferenceCollectionImpl(ChildElementCollection<Source> referenceSourceCollection) {
        this.referenceSourceCollection = referenceSourceCollection;
    }

    @Override
    public ChildElementCollection<Source> getReferenceSourceCollection() {
        return this.referenceSourceCollection;
    }

    @Override
    protected void setReferenceIdentifier(ModelElementInstance referenceSourceElement, String referenceIdentifier) {
        referenceSourceElement.setTextContent(referenceIdentifier);
    }

    private void performAddOperation(ModelElementInstanceImpl referenceSourceParentElement, Target referenceTargetElement) {
        String referenceTargetIdentifier;
        ModelInstanceImpl modelInstance = referenceSourceParentElement.getModelInstance();
        ModelElementInstance existingElement = modelInstance.getModelElementById(referenceTargetIdentifier = (String)this.referenceTargetAttribute.getValue((ModelElementInstance)referenceTargetElement));
        if (existingElement == null || !existingElement.equals(referenceTargetElement)) {
            throw new ModelReferenceException("Cannot create reference to model element " + referenceTargetElement + ": element is not part of model. Please connect element to the model first.");
        }
        Collection<Source> referenceSourceElements = this.referenceSourceCollection.get(referenceSourceParentElement);
        Object referenceSourceElement = modelInstance.newInstance(this.referenceSourceType);
        referenceSourceElements.add(referenceSourceElement);
        this.setReferenceIdentifier((ModelElementInstance)referenceSourceElement, referenceTargetIdentifier);
    }

    private void performRemoveOperation(ModelElementInstanceImpl referenceSourceParentElement, Object o) {
        referenceSourceParentElement.removeChildElement((ModelElementInstanceImpl)o);
    }

    private void performClearOperation(ModelElementInstanceImpl referenceSourceParentElement, Collection<DomElement> elementsToRemove) {
        for (DomElement element : elementsToRemove) {
            referenceSourceParentElement.getDomElement().removeChild(element);
        }
    }

    @Override
    public String getReferenceIdentifier(ModelElementInstance referenceSourceElement) {
        return referenceSourceElement.getTextContent();
    }

    @Override
    protected void updateReference(ModelElementInstance referenceSourceElement, String oldIdentifier, String newIdentifier) {
        String referencingTextContent = this.getReferenceIdentifier(referenceSourceElement);
        if (oldIdentifier != null && oldIdentifier.equals(referencingTextContent)) {
            this.setReferenceIdentifier(referenceSourceElement, newIdentifier);
        }
    }

    @Override
    protected void removeReference(ModelElementInstance referenceSourceElement) {
        ModelElementInstance parentElement = referenceSourceElement.getParentElement();
        Collection<Source> childElementCollection = this.referenceSourceCollection.get(parentElement);
        childElementCollection.remove(referenceSourceElement);
    }

    public void setReferenceSourceElementType(ModelElementTypeImpl referenceSourceType) {
        this.referenceSourceType = referenceSourceType;
    }

    @Override
    protected ModelElementType getReferenceSourceElementType() {
        return this.referenceSourceType;
    }

    private Collection<DomElement> getView(ModelElementInstanceImpl referenceSourceParentElement) {
        DomDocument document = referenceSourceParentElement.getModelInstance().getDocument();
        Collection<Source> referenceSourceElements = this.referenceSourceCollection.get(referenceSourceParentElement);
        ArrayList<DomElement> referenceTargetElements = new ArrayList<DomElement>();
        for (ModelElementInstance referenceSourceElement : referenceSourceElements) {
            String identifier = this.getReferenceIdentifier(referenceSourceElement);
            DomElement referenceTargetElement = document.getElementById(identifier);
            if (referenceTargetElement != null) {
                referenceTargetElements.add(referenceTargetElement);
                continue;
            }
            throw new ModelException("Unable to find a model element instance for id " + identifier);
        }
        return referenceTargetElements;
    }

    @Override
    public Collection<Target> getReferenceTargetElements(final ModelElementInstanceImpl referenceSourceParentElement) {
        return new Collection<Target>(){

            @Override
            public int size() {
                return ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement).size();
            }

            @Override
            public boolean isEmpty() {
                return ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement).isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof ModelElementInstanceImpl)) {
                    return false;
                }
                return ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement).contains(((ModelElementInstanceImpl)o).getDomElement());
            }

            @Override
            public Iterator<Target> iterator() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement), referenceSourceParentElement.getModelInstance());
                return modelElementCollection.iterator();
            }

            @Override
            public Object[] toArray() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement), referenceSourceParentElement.getModelInstance());
                return modelElementCollection.toArray();
            }

            @Override
            public <T1> T1[] toArray(T1[] a) {
                Collection<T1> modelElementCollection = ModelUtil.getModelElementCollection(ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement), referenceSourceParentElement.getModelInstance());
                return modelElementCollection.toArray(a);
            }

            @Override
            public boolean add(Target t) {
                if (ElementReferenceCollectionImpl.this.referenceSourceCollection.isImmutable()) {
                    throw new UnsupportedModelOperationException("add()", "collection is immutable");
                }
                if (!this.contains(t)) {
                    ElementReferenceCollectionImpl.this.performAddOperation(referenceSourceParentElement, t);
                }
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (ElementReferenceCollectionImpl.this.referenceSourceCollection.isImmutable()) {
                    throw new UnsupportedModelOperationException("remove()", "collection is immutable");
                }
                ModelUtil.ensureInstanceOf(o, ModelElementInstanceImpl.class);
                ElementReferenceCollectionImpl.this.performRemoveOperation(referenceSourceParentElement, o);
                return true;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(ElementReferenceCollectionImpl.this.getView(referenceSourceParentElement), referenceSourceParentElement.getModelInstance());
                return modelElementCollection.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Target> c) {
                if (ElementReferenceCollectionImpl.this.referenceSourceCollection.isImmutable()) {
                    throw new UnsupportedModelOperationException("addAll()", "collection is immutable");
                }
                boolean result = false;
                for (ModelElementInstance o : c) {
                    result |= this.add((Target)o);
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                if (ElementReferenceCollectionImpl.this.referenceSourceCollection.isImmutable()) {
                    throw new UnsupportedModelOperationException("removeAll()", "collection is immutable");
                }
                boolean result = false;
                for (Object o : c) {
                    result |= this.remove(o);
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedModelOperationException("retainAll()", "not implemented");
            }

            @Override
            public void clear() {
                if (ElementReferenceCollectionImpl.this.referenceSourceCollection.isImmutable()) {
                    throw new UnsupportedModelOperationException("clear()", "collection is immutable");
                }
                ArrayList<DomElement> view = new ArrayList<DomElement>();
                for (ModelElementInstance referenceSourceElement : ElementReferenceCollectionImpl.this.referenceSourceCollection.get(referenceSourceParentElement)) {
                    view.add(referenceSourceElement.getDomElement());
                }
                ElementReferenceCollectionImpl.this.performClearOperation(referenceSourceParentElement, view);
            }
        };
    }
}

