/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.instance;

import java.util.List;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.DomDocumentImpl;
import org.camunda.bpm.model.xml.impl.util.DomUtil;
import org.camunda.bpm.model.xml.impl.util.XmlQName;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomElementImpl
implements DomElement {
    private static final String MODEL_ELEMENT_KEY = "camunda.modelElementRef";
    private final Element element;
    private final Document document;

    public DomElementImpl(Element element) {
        this.element = element;
        this.document = element.getOwnerDocument();
    }

    protected Element getElement() {
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceURI() {
        Document document = this.document;
        synchronized (document) {
            return this.element.getNamespaceURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocalName() {
        Document document = this.document;
        synchronized (document) {
            return this.element.getLocalName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefix() {
        Document document = this.document;
        synchronized (document) {
            return this.element.getPrefix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomDocument getDocument() {
        Document document = this.document;
        synchronized (document) {
            Document ownerDocument = this.element.getOwnerDocument();
            if (ownerDocument != null) {
                return new DomDocumentImpl(ownerDocument);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomElement getRootElement() {
        Document document = this.document;
        synchronized (document) {
            DomDocument document2 = this.getDocument();
            if (document2 != null) {
                return document2.getRootElement();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomElement getParentElement() {
        Document document = this.document;
        synchronized (document) {
            Node parentNode = this.element.getParentNode();
            if (parentNode != null && parentNode instanceof Element) {
                return new DomElementImpl((Element)parentNode);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomElement> getChildElements() {
        Document document = this.document;
        synchronized (document) {
            NodeList childNodes = this.element.getChildNodes();
            return DomUtil.filterNodeListForElements(childNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomElement> getChildElementsByNameNs(String namespaceUri, String elementName) {
        Document document = this.document;
        synchronized (document) {
            NodeList childNodes = this.element.getChildNodes();
            return DomUtil.filterNodeListByName(childNodes, namespaceUri, elementName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomElement> getChildElementsByType(ModelInstanceImpl modelInstance, Class<? extends ModelElementInstance> elementType) {
        Document document = this.document;
        synchronized (document) {
            NodeList childNodes = this.element.getChildNodes();
            return DomUtil.filterNodeListByType(childNodes, modelInstance, elementType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceChild(DomElement newChildDomElement, DomElement existingChildDomElement) {
        Document document = this.document;
        synchronized (document) {
            Element newElement = ((DomElementImpl)newChildDomElement).getElement();
            Element existingElement = ((DomElementImpl)existingChildDomElement).getElement();
            try {
                this.element.replaceChild(newElement, existingElement);
            }
            catch (DOMException e) {
                throw new ModelException("Unable to replace child <" + existingElement + "> of element <" + this.element + "> with element <" + newElement + ">", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(DomElement childDomElement) {
        Document document = this.document;
        synchronized (document) {
            Element childElement = ((DomElementImpl)childDomElement).getElement();
            try {
                this.element.removeChild(childElement);
                return true;
            }
            catch (DOMException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendChild(DomElement childDomElement) {
        Document document = this.document;
        synchronized (document) {
            Element childElement = ((DomElementImpl)childDomElement).getElement();
            this.element.appendChild(childElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertChildElementAfter(DomElement elementToInsert, DomElement insertAfter) {
        Document document = this.document;
        synchronized (document) {
            Element newElement = ((DomElementImpl)elementToInsert).getElement();
            Node insertBeforeNode = insertAfter == null ? this.element.getFirstChild() : ((DomElementImpl)insertAfter).getElement().getNextSibling();
            if (insertBeforeNode != null) {
                this.element.insertBefore(newElement, insertBeforeNode);
            } else {
                this.element.appendChild(newElement);
            }
        }
    }

    @Override
    public boolean hasAttribute(String localName) {
        return this.hasAttribute(null, localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute(String namespaceUri, String localName) {
        Document document = this.document;
        synchronized (document) {
            return this.element.hasAttributeNS(namespaceUri, localName);
        }
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.getAttribute(null, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(String namespaceUri, String localName) {
        Document document = this.document;
        synchronized (document) {
            XmlQName xmlQName = new XmlQName(this, namespaceUri, localName);
            String value = xmlQName.hasLocalNamespace() ? this.element.getAttributeNS(null, xmlQName.getLocalName()) : this.element.getAttributeNS(xmlQName.getNamespaceUri(), xmlQName.getLocalName());
            if (value.isEmpty()) {
                return null;
            }
            return value;
        }
    }

    @Override
    public void setAttribute(String localName, String value) {
        this.setAttribute(null, localName, value);
    }

    @Override
    public void setAttribute(String namespaceUri, String localName, String value) {
        this.setAttribute(namespaceUri, localName, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(String namespaceUri, String localName, String value, boolean isIdAttribute) {
        Document document = this.document;
        synchronized (document) {
            XmlQName xmlQName = new XmlQName(this, namespaceUri, localName);
            if (xmlQName.hasLocalNamespace()) {
                this.element.setAttributeNS(null, xmlQName.getLocalName(), value);
                if (isIdAttribute) {
                    this.element.setIdAttributeNS(null, xmlQName.getLocalName(), true);
                }
            } else {
                this.element.setAttributeNS(xmlQName.getNamespaceUri(), xmlQName.getPrefixedName(), value);
                if (isIdAttribute) {
                    this.element.setIdAttributeNS(xmlQName.getNamespaceUri(), xmlQName.getLocalName(), true);
                }
            }
        }
    }

    @Override
    public void setIdAttribute(String localName, String value) {
        this.setIdAttribute(this.getNamespaceURI(), localName, value);
    }

    @Override
    public void setIdAttribute(String namespaceUri, String localName, String value) {
        this.setAttribute(namespaceUri, localName, value, true);
    }

    @Override
    public void removeAttribute(String localName) {
        this.removeAttribute(this.getNamespaceURI(), localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String namespaceUri, String localName) {
        Document document = this.document;
        synchronized (document) {
            XmlQName xmlQName = new XmlQName(this, namespaceUri, localName);
            if (xmlQName.hasLocalNamespace()) {
                this.element.removeAttributeNS(null, xmlQName.getLocalName());
            } else {
                this.element.removeAttributeNS(xmlQName.getNamespaceUri(), xmlQName.getLocalName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTextContent() {
        Document document = this.document;
        synchronized (document) {
            return this.element.getTextContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextContent(String textContent) {
        Document document = this.document;
        synchronized (document) {
            this.element.setTextContent(textContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementInstance getModelElementInstance() {
        Document document = this.document;
        synchronized (document) {
            return (ModelElementInstance)this.element.getUserData(MODEL_ELEMENT_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModelElementInstance(ModelElementInstance modelElementInstance) {
        Document document = this.document;
        synchronized (document) {
            this.element.setUserData(MODEL_ELEMENT_KEY, modelElementInstance, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerNamespace(String namespaceUri) {
        Document document = this.document;
        synchronized (document) {
            String lookupPrefix = this.lookupPrefix(namespaceUri);
            if (lookupPrefix == null) {
                String prefix = XmlQName.KNOWN_PREFIXES.get(namespaceUri);
                if (prefix != null && this.getRootElement() != null && this.getRootElement().hasAttribute("http://www.w3.org/2000/xmlns/", prefix)) {
                    prefix = null;
                }
                if (prefix == null) {
                    prefix = ((DomDocumentImpl)this.getDocument()).getUnusedGenericNsPrefix();
                }
                this.registerNamespace(prefix, namespaceUri);
                return prefix;
            }
            return lookupPrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNamespace(String prefix, String namespaceUri) {
        Document document = this.document;
        synchronized (document) {
            this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupPrefix(String namespaceUri) {
        Document document = this.document;
        synchronized (document) {
            return this.element.lookupPrefix(namespaceUri);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomElementImpl that = (DomElementImpl)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

