/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.impl.util.QName;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ModelImpl
implements Model {
    private final Map<QName, ModelElementType> typesByName = new HashMap<QName, ModelElementType>();
    private final Map<Class<? extends ModelElementInstance>, ModelElementType> typesByClass = new HashMap<Class<? extends ModelElementInstance>, ModelElementType>();
    private final String modelName;

    public ModelImpl(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public Collection<ModelElementType> getTypes() {
        return new ArrayList<ModelElementType>(this.typesByName.values());
    }

    @Override
    public ModelElementType getType(Class<? extends ModelElementInstance> instanceClass) {
        return this.typesByClass.get(instanceClass);
    }

    @Override
    public ModelElementType getTypeForName(String typeName) {
        return this.getTypeForName(null, typeName);
    }

    @Override
    public ModelElementType getTypeForName(String namespaceUri, String typeName) {
        return this.typesByName.get(ModelUtil.getQName(namespaceUri, typeName));
    }

    public void registerType(ModelElementType modelElementType, Class<? extends ModelElementInstance> instanceType) {
        QName qName = ModelUtil.getQName(modelElementType.getTypeNamespace(), modelElementType.getTypeName());
        this.typesByName.put(qName, modelElementType);
        this.typesByClass.put(instanceType, modelElementType);
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.modelName == null ? 0 : this.modelName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelImpl other = (ModelImpl)obj;
        return !(this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName));
    }
}

