/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.test;

import java.util.Collection;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.camunda.bpm.model.xml.impl.util.ModelTypeException;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.test.GetModelElementTypeRule;
import org.camunda.bpm.model.xml.test.assertions.AttributeAssert;
import org.camunda.bpm.model.xml.test.assertions.ChildElementAssert;
import org.camunda.bpm.model.xml.test.assertions.ModelAssertions;
import org.camunda.bpm.model.xml.test.assertions.ModelElementTypeAssert;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.DOMException;

public abstract class AbstractModelElementInstanceTest {
    public static ModelInstance modelInstance;
    public static Model model;
    public static ModelElementType modelElementType;

    public static void initModelElementType(GetModelElementTypeRule modelElementTypeRule) {
        modelInstance = modelElementTypeRule.getModelInstance();
        model = modelElementTypeRule.getModel();
        modelElementType = modelElementTypeRule.getModelElementType();
    }

    public abstract String getDefaultNamespace();

    public abstract TypeAssumption getTypeAssumption();

    public abstract Collection<ChildElementAssumption> getChildElementAssumptions();

    public abstract Collection<AttributeAssumption> getAttributesAssumptions();

    public ModelElementTypeAssert assertThatType() {
        return ModelAssertions.assertThat(modelElementType);
    }

    public AttributeAssert assertThatAttribute(String attributeName) {
        return ModelAssertions.assertThat(modelElementType.getAttribute(attributeName));
    }

    public ChildElementAssert assertThatChildElement(ModelElementType childElementType) {
        ModelElementTypeImpl modelElementTypeImpl = (ModelElementTypeImpl)modelElementType;
        return ModelAssertions.assertThat(modelElementTypeImpl.getChildElementCollection(childElementType));
    }

    public ModelElementType getType(Class<? extends ModelElementInstance> instanceClass) {
        return model.getType(instanceClass);
    }

    @Test
    public void testType() {
        this.assertThatType().isPartOfModel(model);
        TypeAssumption assumption = this.getTypeAssumption();
        this.assertThatType().hasTypeNamespace(assumption.namespaceUri);
        if (assumption.isAbstract) {
            this.assertThatType().isAbstract();
        } else {
            this.assertThatType().isNotAbstract();
        }
        if (assumption.extendsType == null) {
            this.assertThatType().extendsNoType();
        } else {
            this.assertThatType().extendsType(assumption.extendsType);
        }
        if (assumption.isAbstract) {
            try {
                modelInstance.newInstance(modelElementType);
                Assert.fail((String)("Element type " + modelElementType.getTypeName() + " is abstract."));
            }
            catch (DOMException e) {
            }
            catch (ModelTypeException e) {
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception " + e.getMessage()));
            }
        } else {
            Object modelElementInstance = modelInstance.newInstance(modelElementType);
            ModelAssertions.assertThat(modelElementInstance).isNotNull();
        }
    }

    @Test
    public void testChildElements() {
        Collection<ChildElementAssumption> childElementAssumptions = this.getChildElementAssumptions();
        if (childElementAssumptions == null) {
            this.assertThatType().hasNoChildElements();
        } else {
            ModelAssertions.assertThat((int)modelElementType.getChildElementTypes().size()).isEqualTo(childElementAssumptions.size());
            for (ChildElementAssumption assumption : childElementAssumptions) {
                this.assertThatType().hasChildElements(assumption.childElementType);
                if (assumption.namespaceUri != null) {
                    ModelAssertions.assertThat(assumption.childElementType).hasTypeNamespace(assumption.namespaceUri);
                }
                this.assertThatChildElement(assumption.childElementType).occursMinimal(assumption.minOccurs).occursMaximal(assumption.maxOccurs);
            }
        }
    }

    @Test
    public void testAttributes() {
        Collection<AttributeAssumption> attributesAssumptions = this.getAttributesAssumptions();
        if (attributesAssumptions == null) {
            this.assertThatType().hasNoAttributes();
        } else {
            ModelAssertions.assertThat(attributesAssumptions).hasSameSizeAs(modelElementType.getAttributes());
            for (AttributeAssumption assumption : attributesAssumptions) {
                this.assertThatType().hasAttributes(assumption.attributeName);
                AttributeAssert attributeAssert = this.assertThatAttribute(assumption.attributeName);
                attributeAssert.hasOwningElementType(modelElementType);
                if (assumption.namespace != null) {
                    attributeAssert.hasNamespaceUri(assumption.namespace);
                } else {
                    attributeAssert.hasNoNamespaceUri();
                }
                if (assumption.isIdAttribute) {
                    attributeAssert.isIdAttribute();
                } else {
                    attributeAssert.isNotIdAttribute();
                }
                if (assumption.isRequired) {
                    attributeAssert.isRequired();
                } else {
                    attributeAssert.isOptional();
                }
                if (assumption.defaultValue == null) {
                    attributeAssert.hasNoDefaultValue();
                    continue;
                }
                attributeAssert.hasDefaultValue(assumption.defaultValue);
            }
        }
    }

    protected class AttributeAssumption {
        public final String attributeName;
        public final String namespace;
        public final boolean isIdAttribute;
        public final boolean isRequired;
        public final Object defaultValue;

        public AttributeAssumption(String attributeName) {
            this(attributeName, false, false);
        }

        public AttributeAssumption(String namespace, String attributeName) {
            this(namespace, attributeName, false, false);
        }

        public AttributeAssumption(String attributeName, boolean isIdAttribute) {
            this(attributeName, isIdAttribute, false);
        }

        public AttributeAssumption(String namespace, String attributeName, boolean isIdAttribute) {
            this(namespace, attributeName, isIdAttribute, false);
        }

        public AttributeAssumption(String attributeName, boolean isIdAttribute, boolean isRequired) {
            this(attributeName, isIdAttribute, isRequired, null);
        }

        public AttributeAssumption(String namespace, String attributeName, boolean isIdAttribute, boolean isRequired) {
            this(namespace, attributeName, isIdAttribute, isRequired, null);
        }

        public AttributeAssumption(String attributeName, boolean isIdAttribute, boolean isRequired, Object defaultValue) {
            this(null, attributeName, isIdAttribute, isRequired, defaultValue);
        }

        public AttributeAssumption(String namespace, String attributeName, boolean isIdAttribute, boolean isRequired, Object defaultValue) {
            this.attributeName = attributeName;
            this.namespace = namespace;
            this.isIdAttribute = isIdAttribute;
            this.isRequired = isRequired;
            this.defaultValue = defaultValue;
        }
    }

    protected class ChildElementAssumption {
        public final String namespaceUri;
        public final ModelElementType childElementType;
        public final int minOccurs;
        public final int maxOccurs;

        public ChildElementAssumption(Class<? extends ModelElementInstance> childElementType) {
            this(childElementType, 0, -1);
        }

        public ChildElementAssumption(String namespaceUri, Class<? extends ModelElementInstance> childElementType) {
            this(namespaceUri, childElementType, 0, -1);
        }

        public ChildElementAssumption(Class<? extends ModelElementInstance> childElementType, int minOccurs) {
            this(childElementType, minOccurs, -1);
        }

        public ChildElementAssumption(String namespaceUri, Class<? extends ModelElementInstance> childElementType, int minOccurs) {
            this(namespaceUri, childElementType, minOccurs, -1);
        }

        public ChildElementAssumption(Class<? extends ModelElementInstance> childElementType, int minOccurs, int maxOccurs) {
            this(abstractModelElementInstanceTest.getDefaultNamespace(), childElementType, minOccurs, maxOccurs);
        }

        public ChildElementAssumption(String namespaceUri, Class<? extends ModelElementInstance> childElementType, int minOccurs, int maxOccurs) {
            this.namespaceUri = namespaceUri;
            this.childElementType = model.getType(childElementType);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }
    }

    protected class TypeAssumption {
        public final String namespaceUri;
        public final ModelElementType extendsType;
        public final boolean isAbstract;

        public TypeAssumption(boolean isAbstract) {
            this(abstractModelElementInstanceTest.getDefaultNamespace(), isAbstract);
        }

        public TypeAssumption(String namespaceUri, boolean isAbstract) {
            this(namespaceUri, null, isAbstract);
        }

        public TypeAssumption(Class<? extends ModelElementInstance> extendsType, boolean isAbstract) {
            this(abstractModelElementInstanceTest.getDefaultNamespace(), extendsType, isAbstract);
        }

        public TypeAssumption(String namespaceUri, Class<? extends ModelElementInstance> extendsType, boolean isAbstract) {
            this.namespaceUri = namespaceUri;
            this.extendsType = model.getType(extendsType);
            this.isAbstract = isAbstract;
        }
    }
}

