/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.quarkus.engine.extension.impl;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cdi.impl.event.CdiEventSupportBpmnParseListener;
import org.camunda.bpm.engine.cdi.impl.util.BeanManagerLookup;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.quarkus.engine.extension.impl.CamundaEngineConfig;
import org.camunda.bpm.quarkus.engine.extension.impl.ManagedJobExecutor;
import org.camunda.bpm.quarkus.engine.extension.impl.QuarkusProcessEngineConfiguration;
import org.eclipse.microprofile.context.ManagedExecutor;

@Recorder
public class CamundaEngineRecorder {
    protected static final String DEFAULT_JDBC_URL = "jdbc:h2:mem:camunda;MVCC=TRUE;TRACE_LEVEL_FILE=0;DB_CLOSE_ON_EXIT=FALSE";

    public void configureProcessEngineCdiBeans(BeanContainer beanContainer) {
        if (BeanManagerLookup.localInstance == null) {
            BeanManagerLookup.localInstance = (BeanManager)beanContainer.instance(BeanManager.class, new Annotation[0]);
        }
    }

    public RuntimeValue<ProcessEngineConfigurationImpl> createProcessEngineConfiguration(BeanContainer beanContainer, CamundaEngineConfig camundaEngineConfig) {
        List postBPMNParseListeners;
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)beanContainer.instance(QuarkusProcessEngineConfiguration.class, new Annotation[0]);
        configuration.setJdbcUrl(DEFAULT_JDBC_URL);
        configuration.setDatabaseSchemaUpdate("true");
        if (configuration.getJobExecutor() == null) {
            int maxPoolSize = camundaEngineConfig.jobExecutor.threadPool.maxPoolSize;
            int queueSize = camundaEngineConfig.jobExecutor.threadPool.queueSize;
            ManagedExecutor managedExecutor = ManagedExecutor.builder().maxQueued(queueSize).maxAsync(maxPoolSize).build();
            ManagedJobExecutor quarkusJobExecutor = new ManagedJobExecutor(managedExecutor, camundaEngineConfig);
            configuration.setJobExecutor((JobExecutor)quarkusJobExecutor);
        }
        if ((postBPMNParseListeners = configuration.getCustomPostBPMNParseListeners()) == null) {
            ArrayList<CdiEventSupportBpmnParseListener> parseListeners = new ArrayList<CdiEventSupportBpmnParseListener>();
            parseListeners.add(new CdiEventSupportBpmnParseListener());
            configuration.setCustomPostBPMNParseListeners(parseListeners);
        } else {
            postBPMNParseListeners.add(new CdiEventSupportBpmnParseListener());
        }
        return new RuntimeValue((Object)configuration);
    }

    public RuntimeValue<ProcessEngine> createProcessEngine(RuntimeValue<ProcessEngineConfigurationImpl> configurationRuntimeValue) {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)configurationRuntimeValue.getValue();
        ProcessEngine processEngine = configuration.buildProcessEngine();
        RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
        runtimeContainerDelegate.registerProcessEngine(processEngine);
        return new RuntimeValue((Object)processEngine);
    }

    public void registerShutdownTask(ShutdownContext shutdownContext, RuntimeValue<ProcessEngine> processEngine) {
        shutdownContext.addShutdownTask(() -> {
            ProcessEngine engine = (ProcessEngine)processEngine.getValue();
            ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
            JobExecutor executor = configuration.getJobExecutor();
            executor.shutdown();
            RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
            runtimeContainerDelegate.unregisterProcessEngine(engine);
        });
    }
}

