/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.quarkus.engine.extension.impl;

import com.arjuna.ats.jta.TransactionManager;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.context.SmallRyeManagedExecutor;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cdi.impl.event.CdiEventSupportBpmnParseListener;
import org.camunda.bpm.engine.cdi.impl.util.BeanManagerLookup;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.quarkus.engine.extension.CamundaEngineConfig;
import org.camunda.bpm.quarkus.engine.extension.QuarkusProcessEngineConfiguration;
import org.camunda.bpm.quarkus.engine.extension.event.CamundaEngineStartupEvent;
import org.camunda.bpm.quarkus.engine.extension.impl.ManagedJobExecutor;
import org.eclipse.microprofile.context.ManagedExecutor;

@Recorder
public class CamundaEngineRecorder {
    public void configureProcessEngineCdiBeans(BeanContainer beanContainer) {
        if (BeanManagerLookup.localInstance == null) {
            BeanManagerLookup.localInstance = this.getBeanFromContainer(BeanManager.class, beanContainer);
        }
    }

    public RuntimeValue<ProcessEngineConfigurationImpl> createProcessEngineConfiguration(BeanContainer beanContainer, CamundaEngineConfig config) {
        QuarkusProcessEngineConfiguration configuration = this.getBeanFromContainer(QuarkusProcessEngineConfiguration.class, beanContainer);
        PropertyHelper.applyProperties((Object)((Object)configuration), config.genericConfig(), (String)"-");
        if (configuration.getDataSource() == null) {
            String datasource = config.datasource().orElse("<default>");
            configuration.setDataSource((DataSource)DataSources.fromName((String)datasource));
        }
        if (configuration.getTransactionManager() == null) {
            configuration.setTransactionManager(TransactionManager.transactionManager());
        }
        if (configuration.getJobExecutor() == null) {
            this.configureJobExecutor((ProcessEngineConfigurationImpl)configuration, config);
        }
        this.configureCdiEventBridge(configuration);
        return new RuntimeValue((Object)configuration);
    }

    protected void configureCdiEventBridge(QuarkusProcessEngineConfiguration configuration) {
        List postBPMNParseListeners = configuration.getCustomPostBPMNParseListeners();
        if (postBPMNParseListeners == null) {
            ArrayList<CdiEventSupportBpmnParseListener> parseListeners = new ArrayList<CdiEventSupportBpmnParseListener>();
            parseListeners.add(new CdiEventSupportBpmnParseListener());
            configuration.setCustomPostBPMNParseListeners(parseListeners);
        } else {
            postBPMNParseListeners.add(new CdiEventSupportBpmnParseListener());
        }
    }

    public RuntimeValue<ProcessEngine> createProcessEngine(RuntimeValue<ProcessEngineConfigurationImpl> configurationRuntimeValue) {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)configurationRuntimeValue.getValue();
        ProcessEngine processEngine = configuration.buildProcessEngine();
        RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
        runtimeContainerDelegate.registerProcessEngine(processEngine);
        return new RuntimeValue((Object)processEngine);
    }

    public void fireCamundaEngineStartEvent() {
        Arc.container().beanManager().getEvent().select(CamundaEngineStartupEvent.class, new Annotation[0]).fire((Object)new CamundaEngineStartupEvent());
    }

    public void registerShutdownTask(ShutdownContext shutdownContext, RuntimeValue<ProcessEngine> processEngine) {
        shutdownContext.addShutdownTask(() -> {
            ProcessEngine engine = (ProcessEngine)processEngine.getValue();
            ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
            JobExecutor executor = configuration.getJobExecutor();
            executor.shutdown();
            RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
            runtimeContainerDelegate.unregisterProcessEngine(engine);
        });
    }

    protected void configureJobExecutor(ProcessEngineConfigurationImpl configuration, CamundaEngineConfig config) {
        int maxPoolSize = config.jobExecutor().threadPool().maxPoolSize();
        int queueSize = config.jobExecutor().threadPool().queueSize();
        SmallRyeManagedExecutor managedExecutor = SmallRyeManagedExecutor.builder().maxQueued(queueSize).maxAsync(maxPoolSize).withNewExecutorService().build();
        ManagedJobExecutor quarkusJobExecutor = new ManagedJobExecutor((ManagedExecutor)managedExecutor);
        PropertyHelper.applyProperties((Object)((Object)quarkusJobExecutor), config.jobExecutor().genericConfig(), (String)"-");
        configuration.setJobExecutor((JobExecutor)quarkusJobExecutor);
    }

    protected <T> T getBeanFromContainer(Class<T> beanClass, BeanContainer beanContainer) {
        try (BeanContainer.Instance beanManager = beanContainer.beanInstanceFactory(beanClass, new Annotation[0]).create();){
            Object object = beanManager.get();
            return (T)object;
        }
    }
}

