/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContext;
import org.camunda.bpm.application.PostDeploy;
import org.camunda.bpm.application.PreUndeploy;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.spring.application.SpringProcessApplication;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.camunda.bpm.spring.boot.starter.event.PostDeployEvent;
import org.camunda.bpm.spring.boot.starter.event.PreUndeployEvent;
import org.camunda.bpm.spring.boot.starter.util.GetProcessApplicationNameFromAnnotation;
import org.camunda.bpm.spring.boot.starter.util.SpringBootProcessEngineLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class SpringBootProcessApplication
extends SpringProcessApplication {
    @Value(value="${spring.application.name:null}")
    protected Optional<String> springApplicationName;
    protected String contextPath = "/";
    @Autowired
    protected ProcessEngine processEngine;
    @Autowired
    protected ApplicationEventPublisher eventPublisher;

    @Bean
    public static CamundaDeploymentConfiguration deploymentConfiguration() {
        return new CamundaDeploymentConfiguration(){

            @Override
            public Set<Resource> getDeploymentResources() {
                return Collections.emptySet();
            }

            @Override
            public void preInit(ProcessEngineConfigurationImpl configuration) {
                SpringBootProcessEngineLogger.LOG.skipAutoDeployment();
            }

            public String toString() {
                return "disableDeploymentResourcePattern";
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        GetProcessApplicationNameFromAnnotation.processApplicationNameFromAnnotation(this.applicationContext).apply(this.springApplicationName).ifPresent(arg_0 -> ((SpringBootProcessApplication)this).setBeanName(arg_0));
        RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.processEngine);
        this.properties.put("servletContextPath", this.contextPath);
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        super.destroy();
        RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.processEngine);
    }

    @PostDeploy
    public void onPostDeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PostDeployEvent(processEngine));
    }

    @PreUndeploy
    public void onPreUndeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PreUndeployEvent(processEngine));
    }

    @ConditionalOnWebApplication
    @Configuration
    class WebApplicationConfiguration
    implements ServletContextAware {
        WebApplicationConfiguration() {
        }

        public void setServletContext(ServletContext servletContext) {
            if (!StringUtils.isEmpty((Object)servletContext.getContextPath())) {
                SpringBootProcessApplication.this.contextPath = servletContext.getContextPath();
            }
        }
    }
}

