/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.condition;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class NeedsHistoryAutoConfigurationCondition
extends SpringBootCondition {
    protected static final String HISTORY_AUTO = "auto";
    protected String historyAutoFieldName = "HISTORY_AUTO";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.needsAdditionalConfiguration(context) ? ConditionOutcome.match((String)"camunda version needs additional configuration for history level auto") : ConditionOutcome.noMatch((String)"camunda version supports history level auto");
    }

    protected boolean needsAdditionalConfiguration(ConditionContext context) {
        String historyLevel = context.getEnvironment().getProperty("camunda.bpm.history-level");
        if (HISTORY_AUTO.equals(historyLevel)) {
            return !this.isHistoryAutoSupported();
        }
        return false;
    }

    protected boolean isHistoryAutoSupported() {
        return false;
    }
}

