/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.net.URL;
import java.util.Set;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.spring.boot.starter.util.SpringBootStarterException;
import org.camunda.commons.logging.BaseLogger;
import org.springframework.core.io.Resource;

public class SpringBootProcessEngineLogger
extends BaseLogger {
    static final String PROJECT_CODE = "STARTER";
    static final String PROJECT_ID = "SB";
    static final String PACKAGE = "org.camunda.bpm.spring.boot";
    public static final SpringBootProcessEngineLogger LOG = (SpringBootProcessEngineLogger)SpringBootProcessEngineLogger.createLogger(SpringBootProcessEngineLogger.class, (String)"STARTER", (String)"org.camunda.bpm.spring.boot", (String)"SB");

    public void creatingInitialAdminUser(User adminUser) {
        this.logInfo("010", "creating initital Admin User: {}", new Object[]{adminUser});
    }

    public void skipAdminUserCreation(User existingUser) {
        this.logInfo("011", "skip creating initital Admin User, user does exist: {}", new Object[]{existingUser});
    }

    public void createInitialFilter(Filter filter) {
        this.logInfo("015", "create initial filter: id={} name={}", new Object[]{filter.getId(), filter.getName()});
    }

    public void skipAutoDeployment() {
        this.logInfo("020", "ProcessApplication enabled: autoDeployment via springConfiguration#deploymentResourcePattern is disabled", new Object[0]);
    }

    public void autoDeployResources(Set<Resource> resources) {
        this.logInfo("021", "Auto-Deploying resources: {}", new Object[]{resources});
    }

    public void enterLicenseKey(URL licenseKeyFile) {
        this.logInfo("030", "Setting up license key: {}", new Object[]{licenseKeyFile});
    }

    public void configureJobExecutorPool(Integer corePoolSize, Integer maxPoolSize) {
        this.logInfo("040", "Setting up jobExecutor with corePoolSize={}, maxPoolSize:{}", new Object[]{corePoolSize, maxPoolSize});
    }

    public SpringBootStarterException exceptionDuringBinding(String message) {
        return new SpringBootStarterException(this.exceptionMessage("050", message, new Object[0]));
    }
}

