/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.admin.impl.web;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.rest.dto.identity.UserDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.UserRestServiceImpl;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;
import org.camunda.bpm.webapp.impl.security.SecurityActions;

@Path(value="/setup/{engine}")
public class SetupResource {
    @Path(value="/user/create")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void createInitialUser(@PathParam(value="engine") String processEngineName, UserDto user) {
        ProcessEngine processEngine = this.lookupProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Process Engine '" + processEngineName + "' does not exist.");
        }
        SecurityActions.runWithoutAuthentication((SecurityActions.SecurityAction)new /* Unavailable Anonymous Inner Class!! */, (ProcessEngine)processEngine);
    }

    protected void createInitialUserInternal(String processEngineName, UserDto user, ProcessEngine processEngine) {
        this.ensureSetupAvailable(processEngine);
        UserRestServiceImpl userRestServiceImpl = new UserRestServiceImpl(processEngineName);
        userRestServiceImpl.createUser(user);
        this.ensureCamundaAdminGroupExists(processEngine);
        processEngine.getIdentityService().createMembership(user.getProfile().getId(), "camunda-admin");
    }

    protected void ensureCamundaAdminGroupExists(ProcessEngine processEngine) {
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (identityService.createGroupQuery().groupId("camunda-admin").count() == 0L) {
            Group camundaAdminGroup = identityService.newGroup("camunda-admin");
            camundaAdminGroup.setName("camunda BPM Administrators");
            camundaAdminGroup.setType("SYSTEM");
            identityService.saveGroup(camundaAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"camunda-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("camunda-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
    }

    protected void ensureSetupAvailable(ProcessEngine processEngine) {
        if (processEngine.getIdentityService().isReadOnly() || processEngine.getIdentityService().createUserQuery().memberOfGroup("camunda-admin").count() > 0L) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Setup action not available");
        }
    }

    protected ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.BAD_REQUEST, "Could not find an implementation of the " + ProcessEngineProvider.class + "- SPI");
    }
}

