/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessInstanceDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.ProcessInstanceQueryDto;
import org.camunda.bpm.cockpit.impl.plugin.base.sub.resources.ProcessInstanceResource;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.rest.dto.CountResultDto;

public class ProcessInstanceRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-instance";

    public ProcessInstanceRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessInstanceResource getProcessInstance(@PathParam(value="id") String id) {
        return new ProcessInstanceResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> getProcessInstances(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        this.injectEngineConfig(queryParameter);
        this.paginate(queryParameter, firstResult, maxResults);
        return this.getQueryService().executeQuery("selectRunningProcessInstancesIncludingIncidents", (QueryParameters)queryParameter);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/count")
    public CountResultDto getProcessInstancesCount(@Context UriInfo uriInfo) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryParameter);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/count")
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryParameter) {
        this.injectEngineConfig(queryParameter);
        long result = this.getQueryService().executeQueryRowCount("selectRunningProcessInstancesCount", (ListQueryParameterObject)queryParameter);
        return new CountResultDto(result);
    }

    private void paginate(ProcessInstanceQueryDto queryParameter, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        queryParameter.setFirstResult(firstResult.intValue());
        queryParameter.setMaxResults(maxResults.intValue());
    }

    private void injectEngineConfig(ProcessInstanceQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel() == 0) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableTypes());
    }
}

