/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.sub.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionQueryDto;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class ProcessDefinitionResource
extends AbstractPluginResource {
    protected String id;

    public ProcessDefinitionResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getCalledProcessDefinitions(@Context UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryParameter = new ProcessDefinitionQueryDto(uriInfo.getQueryParameters());
        return this.queryCalledProcessDefinitions(queryParameter);
    }

    @POST
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionDto> queryCalledProcessDefinitions(ProcessDefinitionQueryDto queryParameter) {
        queryParameter.setParentProcessDefinitionId(this.id);
        this.injectEngineConfig(queryParameter);
        List result = this.getQueryService().executeQuery("selectCalledProcessDefinitions", (QueryParameters)queryParameter);
        return result;
    }

    private void injectEngineConfig(ProcessDefinitionQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel() == 0) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableTypes());
    }
}

