/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.engine;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.cockpit.Cockpit;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.webapp.impl.filter.AbstractTemplateFilter;
import org.camunda.bpm.webapp.impl.security.SecurityActions;

public class ProcessEnginesFilter
extends AbstractTemplateFilter {
    protected static final String DEFAULT_APP = "cockpit";
    protected static final String INDEX_PAGE = "index.html";
    protected static final String SETUP_PAGE = "setup/";
    public static final String APP_ROOT_PLACEHOLDER = "$APP_ROOT";
    public static final String BASE_PLACEHOLDER = "$BASE";
    public static Pattern APP_PREFIX_PATTERN = Pattern.compile("/app/(?:(\\w+?)/(?:(index\\.html|\\w+)?/?([^\\?]*)?)?)?");

    protected void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI().substring(contextPath.length());
        Matcher uriMatcher = APP_PREFIX_PATTERN.matcher(requestUri);
        if (uriMatcher.matches()) {
            String appName = uriMatcher.group(1);
            String engineName = uriMatcher.group(2);
            String pageUri = uriMatcher.group(3);
            if (INDEX_PAGE.equals(engineName)) {
                engineName = null;
            }
            if (pageUri == null || pageUri.isEmpty() || SETUP_PAGE.equals(pageUri)) {
                this.serveIndexPage(appName, engineName, pageUri, contextPath, request, response, chain);
                return;
            }
            if (INDEX_PAGE.equals(pageUri)) {
                response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, engineName));
                return;
            }
            if (pageUri.endsWith(".html")) {
                this.serveTemplate(requestUri, appName, pageUri, request, response, chain);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void serveIndexPage(String appName, String engineName, String pageUri, String contextPath, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
        if (appName == null) {
            response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, DEFAULT_APP, this.getDefaultEngineName()));
        } else if (engineName == null) {
            response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, this.getDefaultEngineName()));
        } else {
            boolean setupPage = SETUP_PAGE.equals(pageUri);
            if (this.needsInitialUser(engineName)) {
                if (!setupPage) {
                    response.sendRedirect(String.format("%s/app/admin/%s/setup/#/setup", contextPath, engineName));
                } else {
                    this.serveIndexPage(appName, engineName, contextPath, request, response);
                }
            } else if (!setupPage) {
                this.serveIndexPage(appName, engineName, contextPath, request, response);
            } else {
                response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, engineName));
            }
        }
    }

    private void serveTemplate(String requestUri, String appName, String pageUri, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasWebResource(requestUri)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            String cleanAppUri = String.format("/app/%s/%s", appName, pageUri);
            if (this.hasWebResource(cleanAppUri)) {
                request.getRequestDispatcher(cleanAppUri).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected boolean needsInitialUser(String engineName) {
        ProcessEngine processEngine = Cockpit.getProcessEngine((String)engineName);
        if (processEngine == null) {
            return false;
        }
        if (processEngine.getIdentityService().isReadOnly()) {
            return false;
        }
        return (Boolean)SecurityActions.runWithoutAuthentication((SecurityActions.SecurityAction)new /* Unavailable Anonymous Inner Class!! */, (ProcessEngine)processEngine);
    }

    protected void serveIndexPage(String appName, String engineName, String contextPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String data = this.getWebResourceContents("/app/" + appName + "/index.html");
        data = data.replace(APP_ROOT_PLACEHOLDER, contextPath).replace(BASE_PLACEHOLDER, String.format("%s/app/%s/%s/", contextPath, appName, engineName));
        response.setContentLength(data.getBytes("UTF-8").length);
        response.setContentType("text/html");
        response.getWriter().append(data);
    }

    protected String getDefaultEngineName() {
        return Cockpit.getRuntimeDelegate().getDefaultProcessEngine().getName();
    }
}

