/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.webapp.AppRuntimeDelegate;
import org.camunda.bpm.webapp.impl.filter.AbstractTemplateFilter;
import org.camunda.bpm.webapp.plugin.spi.AppPlugin;

public abstract class AbstractClientPluginsFilter<T extends AppPlugin>
extends AbstractTemplateFilter {
    private final String PLUGIN_DEPENDENCIES = "window.PLUGIN_DEPENDENCIES";
    private final String PLUGIN_PACKAGES = "window.PLUGIN_PACKAGES";
    protected final String pluginPackageFormat;
    protected final String pluginDependencyFormat;
    protected final AppRuntimeDelegate<T> runtimeDelegate;
    protected final String appName;

    public AbstractClientPluginsFilter(String appName, AppRuntimeDelegate<T> runtimeDelegate) {
        this.runtimeDelegate = runtimeDelegate;
        this.appName = appName;
        this.pluginPackageFormat = "{ name: '" + appName + "-plugin-%s', location: 'api/" + appName + "/plugin/%s/static/app', main: 'plugin.js' }";
        this.pluginDependencyFormat = "'module:" + appName + ".plugin.%s:" + appName + "-plugin-%s'";
    }

    protected void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String data = this.getWebResourceContents(request.getRequestURI().replaceFirst(request.getContextPath(), ""));
        data = data.replace("window.PLUGIN_PACKAGES", this.createPluginPackagesStr());
        data = data.replace("window.PLUGIN_DEPENDENCIES", this.createPluginDependenciesStr());
        response.setContentLength(data.getBytes("UTF-8").length);
        response.setContentType("text/javascript;charset=UTF-8");
        response.getWriter().append(data);
    }

    protected CharSequence createPluginPackagesStr() {
        List plugins = this.getPlugins();
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (builder.length() > 0) {
                builder.append(", ").append("\n");
            }
            String definition = String.format(this.pluginPackageFormat, plugin.getId(), plugin.getId());
            builder.append(definition);
        }
        return "[" + builder.toString() + "]";
    }

    protected List<T> getPlugins() {
        return this.runtimeDelegate.getAppPluginRegistry().getPlugins();
    }

    protected CharSequence createPluginDependenciesStr() {
        List plugins = this.getPlugins();
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (builder.length() > 0) {
                builder.append(", ").append("\n");
            }
            String definition = String.format(this.pluginDependencyFormat, plugin.getId(), plugin.getId());
            builder.append(definition);
        }
        return "[" + builder.toString() + "]";
    }
}

