/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

"use strict";

describe('Transformer DI', function() {
 

  it('should transform a singleDiagram', function() {



 // dump(formatter.formatJson(JSON.stringify(processDefinition)));


 var xml =  '<?xml version="1.0" encoding="UTF-8"?>'
+'<definitions xmlns="http://www.omg.org/spec/BPMN/20100524/MODEL" xmlns:bpmndi="http://www.omg.org/spec/BPMN/20100524/DI"   xmlns:omgdc="http://www.omg.org/spec/DD/20100524/DC"  xmlns:omgdi="http://www.omg.org/spec/DD/20100524/DI" xmlns:signavio="http://www.signavio.com" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exporter="Signavio Process Editor, http://www.signavio.com" exporterVersion="6.5.0" expressionLanguage="http://www.w3.org/1999/XPath" id="sid-c921f33b-76e6-41cc-a3b9-a995d90bc725" name="saassd" targetNamespace="http://www.signavio.com/bpmn20" typeLanguage="http://www.w3.org/2001/XMLSchema" xsi:schemaLocation="http://www.omg.org/spec/BPMN/20100524/MODEL http://www.omg.org/spec/BPMN/2.0/20100501/BPMN20.xsd">'
   +'<dataStore capacity="0" id="sid-ea675d45-c5e7-488d-8c8a-352c20ba75cd" isUnlimited="false" name="Data Storage"/>'
   +'<error id="sid-82b9c759-f2fa-42c2-bc02-8c6eb7eda194"/>'
   +'<escalation id="sid-5bfcf9e9-bed8-4a89-97b7-8ef600d34cc8"/>'
   +'<globalTask id="sid-bbe2b044-8324-4f5c-afaf-c3a937ba6a59" name="call activity (service task)"/>'
   +'<collaboration id="sid-65046c75-f5ed-4ade-ad79-d635104dc384">'
      +'<participant id="sid-E6E06D1C-C61C-45CD-B24E-0500BCF93069" name="Expanded Pool" processRef="sid-55D619CA-9902-462F-9362-5E47D9A42C00">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="rolle" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</participant>'
      +'<participant id="sid-DB436C31-C0EB-44C8-8F39-2307095D9418" name="Collapsed Pool">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</participant>'
      +'<messageFlow id="sid-8F2EA0CB-02FF-47FC-97F1-0781C736D3A1" sourceRef="sid-E6E06D1C-C61C-45CD-B24E-0500BCF93069" targetRef="sid-DB436C31-C0EB-44C8-8F39-2307095D9418">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</messageFlow>'
      +'<messageFlow id="sid-041BCC84-224D-49D0-9778-8FCA4FC5C830" sourceRef="sid-629D5855-F0CD-496A-911B-3EF37FC4E2E8" targetRef="sid-DB436C31-C0EB-44C8-8F39-2307095D9418">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</messageFlow>'
   +'</collaboration>'
   +'<process id="sid-55D619CA-9902-462F-9362-5E47D9A42C00" isClosed="false" isExecutable="false" name="Expanded Pool" processType="None">'
      +'<extensionElements/>'
      +'<laneSet id="sid-3cc4d05d-10a6-48ba-a1e9-667ae26d88dd">'
         +'<lane id="sid-7401121E-3D38-4F1A-879C-D282A9B4CC4C">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="bgcolor" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'</extensionElements>'
            +'<flowNodeRef>sid-629D5855-F0CD-496A-911B-3EF37FC4E2E8+</flowNodeRef>'
         +'</lane>'
      +'</laneSet>'
      +'<task completionQuantity="1" id="sid-629D5855-F0CD-496A-911B-3EF37FC4E2E8" isForCompensation="false" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
      +'</task>'
   +'</process>'
   +'<process id="sid-10c81b89-c29a-4717-9e37-6419dae7581e" isClosed="false" isExecutable="false" name="saassd" processType="None">'
      +'<startEvent id="sid-6D7C53C1-51E4-44F2-B976-B893A4FF48C7">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</startEvent>'
      +'<startEvent id="sid-DA098C34-2BD1-4BC1-86B7-9450A1D092DB" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<messageEventDefinition id="sid-d4595c0b-d93e-47b5-aea9-936ac54e73e4"/>'
      +'</startEvent>'
      +'<startEvent id="sid-4F7880A0-240C-4DB9-A270-4650A2262118" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<timerEventDefinition id="sid-dacabb1e-df67-4ec0-8bd4-5ab6b9326d79"/>'
      +'</startEvent>'
      +'<startEvent id="sid-FBD0C700-9FBB-4C43-9229-9F1A7EBA7AE2" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<errorEventDefinition errorRef="sid-82b9c759-f2fa-42c2-bc02-8c6eb7eda194" id="sid-44c8ba74-fbfc-4c12-b55b-5e5ff0f59184"/>'
      +'</startEvent>'
      +'<startEvent id="sid-353C47A0-1A0A-4BF5-A85B-7A99B15D3C0C" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<compensateEventDefinition id="sid-a732055a-43f3-4e9f-b908-ecf0499aaabd" waitForCompletion="true"/>'
      +'</startEvent>'
      +'<startEvent id="sid-6499B2CC-48A7-4081-8EF4-A5924A7A0EBA" isInterrupting="true" parallelMultiple="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-82da7545-931f-4f59-a8a1-862c967285ab"/>'
         +'<terminateEventDefinition id="sid-9322ac87-a2a2-4973-94e1-f6bf8ea07fbe"/>'
      +'</startEvent>'
      +'<startEvent id="sid-905814F7-2046-4E58-A3EC-DD22AB6F6C63" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<escalationEventDefinition escalationRef="sid-5bfcf9e9-bed8-4a89-97b7-8ef600d34cc8" id="sid-3d184870-998e-4200-8f87-a77eaea371e8"/>'
      +'</startEvent>'
      +'<startEvent id="sid-DCE0BCF3-CAD9-4913-8366-FFC54C7D2703" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<signalEventDefinition id="sid-6b9dbc44-ff03-4a6a-b49b-f1b673357a00"/>'
      +'</startEvent>'
      +'<startEvent id="sid-066F75F6-C397-41B6-9FB7-D2E0532A862A" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-3fc34ec2-d08e-446a-86ff-afeab8f20a0b"/>'
         +'<terminateEventDefinition id="sid-7302b286-de05-473e-932f-3a7e593fac77"/>'
      +'</startEvent>'
      +'<startEvent id="sid-BECDB481-9B65-4E5C-955B-94657A599D79" isInterrupting="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<conditionalEventDefinition id="sid-269abaee-1c82-4e68-9735-0528eec25813">'
            +'<condition id="sid-e459fe91-df52-4540-88be-9afef0900f59" xsi:type="tFormalExpression"/>'
         +'</conditionalEventDefinition>'
      +'</startEvent>'
      +'<intermediateCatchEvent id="sid-0D6455E1-C706-4F3C-99AA-B4993C8CE25D" parallelMultiple="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-c6a199e0-3913-4d55-b8d5-2d419edc7fce"/>'
         +'<terminateEventDefinition id="sid-a925c584-75a7-4eba-8a79-517c3fc33139"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-5C140FC1-BD9E-41BC-B3AD-ACEBFE8E827A">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<escalationEventDefinition escalationRef="sid-5bfcf9e9-bed8-4a89-97b7-8ef600d34cc8" id="sid-e707a236-a506-4303-a3cd-4e9829c4296f"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-A2825D81-BBF7-4761-AC2E-4F458A675263">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<messageEventDefinition id="sid-15621789-605b-4380-a990-6b4a62bdcce9"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-350C2C70-5426-47C9-A3BC-9112D477B630">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<timerEventDefinition id="sid-77b98706-edd2-4b38-974b-8d0d6d310aa4"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-5236A47E-AFF2-4AF9-A1D5-2F022EE9DED2">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<errorEventDefinition errorRef="sid-82b9c759-f2fa-42c2-bc02-8c6eb7eda194" id="sid-3da6de6a-323c-4a6c-af2e-1a5040926607"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-5E26B3A3-40CA-4E94-B12F-A5E7273D0AFE">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-b4312908-c9d9-4b38-9b36-79a741ebcbfd"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-FBE76517-456B-41E9-A576-82972AC67D9B">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<compensateEventDefinition id="sid-9824a279-5d1e-4a8e-afcf-3b0f471a4d9d" waitForCompletion="true"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-597F6C29-0ECC-4390-973E-5F8A4CF33946">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<conditionalEventDefinition id="sid-e65fb52c-fafc-4aaf-96e7-748ae01a0155">'
            +'<condition id="sid-5fa4f124-e53f-45a0-8a81-d8d81340bfda" xsi:type="tFormalExpression"/>'
         +'</conditionalEventDefinition>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-C41BB395-D801-4B39-A455-58ADF877957C">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<signalEventDefinition id="sid-e6acfc47-adbc-421e-9e59-7ce33ad05f28"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-A2F288D7-3A35-4DE0-B9F8-095637DFF598">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<linkEventDefinition id="sid-94c8c34b-c3f9-469c-bb26-34fdb41e2576"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateCatchEvent id="sid-44C1AF1B-5847-48DF-9E5B-FAEBF9D9D82C" parallelMultiple="false">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-29a69c5b-999f-4ea3-9281-71e4d15a8ace"/>'
         +'<terminateEventDefinition id="sid-ac3096e0-8918-4cc8-812f-69010b2a6b55"/>'
      +'</intermediateCatchEvent>'
      +'<intermediateThrowEvent id="sid-E1DF00F5-595D-4F19-A4FB-B7B56F7D749B">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<escalationEventDefinition escalationRef="sid-5bfcf9e9-bed8-4a89-97b7-8ef600d34cc8" id="sid-9e2b30a0-189d-435c-babc-fa14ff9dfe4a"/>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-36947C73-0A89-4A11-84C1-FC98F5937457">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="measuringpoint" metaValue=""/>'
         +'</extensionElements>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-18EC0129-B16E-49F7-832C-09C54B2CDE41">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<messageEventDefinition id="sid-8e44a929-e020-4e99-aeca-9f59d943f4ed"/>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-F19549E6-01D5-45B2-968A-F656FEAFB94D">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<compensateEventDefinition id="sid-5c9359fa-bf12-48ac-a806-8643f91e615d" waitForCompletion="true"/>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-70EC3DEF-7817-4F5F-8702-24C97842E310">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<signalEventDefinition id="sid-498de53e-a1f9-4aac-a5c6-eb0b89f35ed7"/>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-C4539FB6-6503-49D9-A826-92AD3EF66583">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-c5c93e16-1141-4779-b022-427b60406ad0"/>'
         +'<terminateEventDefinition id="sid-5ddd1bb5-b0ec-46f8-9bbd-ba3295a35828"/>'
      +'</intermediateThrowEvent>'
      +'<intermediateThrowEvent id="sid-5BB00DA9-1382-4FB2-BEB2-DD137579D091">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<linkEventDefinition id="sid-225a44af-896a-4ac5-944e-da2652d9a2a7"/>'
      +'</intermediateThrowEvent>'
      +'<endEvent id="sid-366430B6-03EF-4F69-8976-ACB8FFDB2A62">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</endEvent>'
      +'<endEvent id="sid-ED28192D-E799-4B23-9273-9E53DF6B0450">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<escalationEventDefinition escalationRef="sid-5bfcf9e9-bed8-4a89-97b7-8ef600d34cc8" id="sid-6e7fb4dc-9805-4586-ab1d-399d487c4c2a"/>'
      +'</endEvent>'
      +'<endEvent id="sid-026F5E54-03FF-4BF7-BAF4-D8D76A28A639">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<messageEventDefinition id="sid-b67b6ad0-b668-4ea1-968e-6f7145517ee8"/>'
      +'</endEvent>'
      +'<endEvent id="sid-AF6143F4-730A-4C7B-8ECE-567BF4E6AF26">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<errorEventDefinition errorRef="sid-82b9c759-f2fa-42c2-bc02-8c6eb7eda194" id="sid-6ef98cce-4a9a-4c6c-a736-e361971ce7c4"/>'
      +'</endEvent>'
      +'<endEvent id="sid-4EC3A93C-5140-4595-B147-D1D5876EAA3C">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-4d73bcd4-b12f-4cbb-bd37-fe1b91bb7e64"/>'
      +'</endEvent>'
      +'<endEvent id="sid-15ED99AE-3114-477D-9D6C-0513CF9D1CB8">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<compensateEventDefinition id="sid-c9d1dd01-a183-41b7-a171-9db4fd12d3b9" waitForCompletion="true"/>'
      +'</endEvent>'
      +'<endEvent id="sid-1EF6FAA4-BC27-4987-8484-0DE3DAFE00E4">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<signalEventDefinition id="sid-8d05825f-b367-46c6-a264-2189c473478f"/>'
      +'</endEvent>'
      +'<endEvent id="sid-1148ECE9-408E-48F8-88C3-170D1C023254">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<cancelEventDefinition id="sid-552bff30-d927-4ec8-a982-de1787db52be"/>'
         +'<terminateEventDefinition id="sid-65a73188-52fb-4867-b199-f3d58c4d491e"/>'
      +'</endEvent>'
      +'<endEvent id="sid-6B9F0284-6CF5-4D9D-B86B-1D297F371D07">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<terminateEventDefinition id="sid-5c46b76c-4f3a-4d75-aebf-5793e03f77f5"/>'
      +'</endEvent>'
      +'<exclusiveGateway gatewayDirection="Unspecified" id="sid-98324E38-ECC0-4EC9-B734-497A6FDBFB74">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
         +'</extensionElements>'
      +'</exclusiveGateway>'
      +'<parallelGateway gatewayDirection="Unspecified" id="sid-395B8CF3-7B5F-4352-8E55-26330D84C592">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</parallelGateway>'
      +'<eventBasedGateway eventGatewayType="Exclusive" gatewayDirection="Unspecified" id="sid-ADCB5B8E-1D71-4050-8931-5F0948FEAE65" instantiate="false">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</eventBasedGateway>'
      +'<inclusiveGateway gatewayDirection="Unspecified" id="sid-189D6F05-1963-4399-A234-E602B654CEDA">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</inclusiveGateway>'
      +'<complexGateway gatewayDirection="Unspecified" id="sid-34D60794-8DBE-40C8-AF6D-C873A2F150FE">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</complexGateway>'
      +'<callActivity completionQuantity="1" id="sid-172D7A6F-3A33-47A6-A565-368E2B546C3B" isForCompensation="true" name="collapsed compensation call activity MI" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioStencil id="CollapsedSubprocess"/>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<standardLoopCharacteristics id="sid-8320b03d-506f-4513-814f-8f071b0cb085" testBefore="false"/>'
      +'</callActivity>'
      +'<transaction completionQuantity="1" id="sid-6E85ED85-6442-4FB4-B5FE-20E0744838AA" isForCompensation="false" method="compensate" name="expanded transaction" startQuantity="1" triggeredByEvent="false">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</transaction>'
      +'<subProcess completionQuantity="1" id="sid-0E847243-9D7F-4DD9-AE35-03D3E7E30120" isForCompensation="false" name="collapsed event sub process" startQuantity="1" triggeredByEvent="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</subProcess>'
      +'<subProcess completionQuantity="1" id="sid-D046D4D5-E86C-4B02-8D53-BE5C1F1640C4" isForCompensation="false" name="expanded event sub process" startQuantity="1" triggeredByEvent="true">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
         +'<callActivity calledElement="sid-bbe2b044-8324-4f5c-afaf-c3a937ba6a59" completionQuantity="1" id="sid-115F482D-098D-4CA3-AEC9-D4939846490A" isForCompensation="false" name="call activity (service task)" startQuantity="1">'
            +'<extensionElements>'
               +'<signavio:signavioStencil id="Task"/>'
               +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
               +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="documentationlink" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
            +'</extensionElements>'
            +'<incoming>sid-A6228EF9-4DE8-404B-9841-3D2A25F6279B+</incoming>'
         +'</callActivity>'
         +'<startEvent id="sid-6457C619-DAE2-4363-91D3-D205CB4C4B64" isInterrupting="false" name="non-interrupting&#10;timer">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'</extensionElements>'
            +'<outgoing>sid-A6228EF9-4DE8-404B-9841-3D2A25F6279B+</outgoing>'
            +'<timerEventDefinition id="sid-cf09531b-9e4f-4d78-9cb2-894d347b321c"/>'
         +'</startEvent>'
         +'<sequenceFlow id="sid-A6228EF9-4DE8-404B-9841-3D2A25F6279B" sourceRef="sid-6457C619-DAE2-4363-91D3-D205CB4C4B64" targetRef="sid-115F482D-098D-4CA3-AEC9-D4939846490A">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
            +'</extensionElements>'
         +'</sequenceFlow>'
      +'</subProcess>'
      +'<sendTask completionQuantity="1" id="sid-753C593E-2D08-428C-83E7-A27AA3E2F625" implementation="webService" isForCompensation="false" name="send loop task" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
         +'<standardLoopCharacteristics id="sid-686c956f-f259-47a7-a0e4-fc0d393d03bf" testBefore="false"/>'
      +'</sendTask>'
      +'<receiveTask completionQuantity="1" id="sid-73FD09E7-C38D-4DDE-87C2-69A26B47BCAC" implementation="webService" instantiate="false" isForCompensation="false" name="receive MI task" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
         +'<multiInstanceLoopCharacteristics behavior="All" id="sid-7c00619e-0b86-493e-a2c6-2963a2aecf61" isSequential="false"/>'
      +'</receiveTask>'
      +'<userTask completionQuantity="1" id="sid-F495F943-869B-4EAC-842F-66DB9AD9167A" implementation="webService" isForCompensation="true" name="user MI sequential task for compensation" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
         +'<multiInstanceLoopCharacteristics behavior="All" id="sid-0298aad3-d52f-439a-97dd-be05f85b210e" isSequential="true"/>'
      +'</userTask>'
      +'<manualTask completionQuantity="1" id="sid-64294159-CD3A-4C9D-8DC4-00DED772EBDB" isForCompensation="false" name="manual task" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
      +'</manualTask>'
      +'<serviceTask completionQuantity="1" id="sid-611B1222-9342-4FFF-B102-798F1570B2F0" implementation="webService" isForCompensation="false" name="service task" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
      +'</serviceTask>'
      +'<businessRuleTask completionQuantity="1" id="sid-601C62B1-D56A-48FF-8F59-B8C35D950DB3" implementation="webService" isForCompensation="false" name="business rule task" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
      +'</businessRuleTask>'
      +'<scriptTask completionQuantity="1" id="sid-88550479-7C4E-4EDE-9E2E-718E09F40FCF" isForCompensation="false" name="script task" scriptFormat="" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
         +'<script/>'
      +'</scriptTask>'
      +'<task completionQuantity="1" id="sid-DE446FBA-E58E-4AC3-8155-E2D62F18A6D2" isForCompensation="false" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
         +'<dataInputAssociation id="sid-BB6E8CC5-EACB-4368-B420-639646CD381E">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
            +'</extensionElements>'
            +'<sourceRef>sid-50242295-D36F-436C-90A3-6C4F8B3AA7DC+</sourceRef>'
            +'<targetRef>sid-DE446FBA-E58E-4AC3-8155-E2D62F18A6D2+</targetRef>'
         +'</dataInputAssociation>'
      +'</task>'
      +'<boundaryEvent attachedToRef="sid-DE446FBA-E58E-4AC3-8155-E2D62F18A6D2" cancelActivity="true" id="sid-F11EBACD-3EB8-44AC-AA80-489385EE43EA" name="boundary" parallelMultiple="false">'
         +'<messageEventDefinition id="sid-e03d3e2b-1e96-428c-a26f-bdf4bf3fa6d5"/>'
      +'</boundaryEvent>'
      +'<task completionQuantity="1" id="sid-EBE5A6E7-CCAE-40FF-B601-5147F5B2D50E" isForCompensation="false" startQuantity="1">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
            +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="documentationlink" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
            +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
         +'</extensionElements>'
      +'</task>'
      +'<boundaryEvent attachedToRef="sid-EBE5A6E7-CCAE-40FF-B601-5147F5B2D50E" cancelActivity="false" id="sid-DFF37444-972A-4C18-8CB0-148A32B2B34A" name="boundary&#10;non-interrupt" parallelMultiple="false">'
         +'<messageEventDefinition id="sid-2b9c9ec4-6b23-4f38-a281-c73c911078d1"/>'
      +'</boundaryEvent>'
      +'<adHocSubProcess cancelRemainingInstances="true" completionQuantity="1" id="sid-3BF88717-F91B-4347-A177-55302F2F65A1" isForCompensation="false" name="expanded adhoc subprocess" ordering="Sequential" startQuantity="1" triggeredByEvent="false">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
         +'</extensionElements>'
         +'<task completionQuantity="1" id="sid-939CFD9F-2FD3-4A14-BBF9-910D9EE2A4AD" isForCompensation="false" startQuantity="1">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
               +'<signavio:signavioMetaData metaKey="adaptereventtype" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="documentationlink" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="test" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adaptertype" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adapterconfiguration" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="adapterclassname" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="servicereferenz" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="risiko" metaValue=""/>'
               +'<signavio:signavioMetaData metaKey="erteiltfreigabe" metaValue=""/>'
            +'</extensionElements>'
         +'</task>'
         +'<subProcess completionQuantity="1" id="sid-2889B588-EA51-4005-A742-157F25B97614" isForCompensation="false" name="just a subprocess" startQuantity="1" triggeredByEvent="false">'
            +'<extensionElements>'
               +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffcc"/>'
               +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
            +'</extensionElements>'
         +'</subProcess>'
      +'</adHocSubProcess>'
      +'<dataObject id="sid-50242295-D36F-436C-90A3-6C4F8B3AA7DC" isCollection="true" name="MI&#10;Data Object">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</dataObject>'
      +'<dataStoreReference dataStoreRef="sid-ea675d45-c5e7-488d-8c8a-352c20ba75cd" id="sid-5BD6906C-3E22-440D-BC77-17DE1950030E" name="Data Storage">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="bgcolor" metaValue="#ffffff"/>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</dataStoreReference>'
      +'<association associationDirection="None" id="sid-198358DC-8026-4E06-A91C-4A8823B4E2A0" sourceRef="sid-EBE5A6E7-CCAE-40FF-B601-5147F5B2D50E" targetRef="sid-496EA08C-05C2-483A-8DA0-13670B64DC12">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
         +'</extensionElements>'
      +'</association>'
      +'<textAnnotation id="sid-496EA08C-05C2-483A-8DA0-13670B64DC12" textFormat="text/plain">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue=""/>'
         +'</extensionElements>'
         +'<text>Association</text>'
      +'</textAnnotation>'
      +'<group id="sid-3F72D3E6-64B6-4971-B7AE-3DA71AB5F3C2">'
         +'<extensionElements>'
            +'<signavio:signavioMetaData metaKey="userstory" metaValue="[]"/>'
         +'</extensionElements>'
      +'</group>'
   +'</process>'
   +'<bpmndi:BPMNDiagram id="sid-bcc9a5d3-f737-43ee-84ae-e3177a3e5a6d">'
      +'<bpmndi:BPMNPlane bpmnElement="sid-65046c75-f5ed-4ade-ad79-d635104dc384" id="sid-7f7a6c88-8fd5-41dd-93d0-045a40e0b253">'
         +'<bpmndi:BPMNShape bpmnElement="sid-E6E06D1C-C61C-45CD-B24E-0500BCF93069" id="sid-E6E06D1C-C61C-45CD-B24E-0500BCF93069_gui" isHorizontal="true">'
            +'<omgdc:Bounds height="144.0" width="679.0" x="50.0" y="825.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-DB436C31-C0EB-44C8-8F39-2307095D9418" id="sid-DB436C31-C0EB-44C8-8F39-2307095D9418_gui" isHorizontal="true">'
            +'<omgdc:Bounds height="60.0" width="500.0" x="34.0" y="1035.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-7401121E-3D38-4F1A-879C-D282A9B4CC4C" id="sid-7401121E-3D38-4F1A-879C-D282A9B4CC4C_gui" isHorizontal="true">'
            +'<omgdc:Bounds height="144.0" width="649.0" x="80.0" y="825.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-629D5855-F0CD-496A-911B-3EF37FC4E2E8" id="sid-629D5855-F0CD-496A-911B-3EF37FC4E2E8_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="255.0" y="857.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-6D7C53C1-51E4-44F2-B976-B893A4FF48C7" id="sid-6D7C53C1-51E4-44F2-B976-B893A4FF48C7_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="75.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-DA098C34-2BD1-4BC1-86B7-9450A1D092DB" id="sid-DA098C34-2BD1-4BC1-86B7-9450A1D092DB_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="135.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-4F7880A0-240C-4DB9-A270-4650A2262118" id="sid-4F7880A0-240C-4DB9-A270-4650A2262118_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="195.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-FBD0C700-9FBB-4C43-9229-9F1A7EBA7AE2" id="sid-FBD0C700-9FBB-4C43-9229-9F1A7EBA7AE2_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="255.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-353C47A0-1A0A-4BF5-A85B-7A99B15D3C0C" id="sid-353C47A0-1A0A-4BF5-A85B-7A99B15D3C0C_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="315.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-6499B2CC-48A7-4081-8EF4-A5924A7A0EBA" id="sid-6499B2CC-48A7-4081-8EF4-A5924A7A0EBA_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="375.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-905814F7-2046-4E58-A3EC-DD22AB6F6C63" id="sid-905814F7-2046-4E58-A3EC-DD22AB6F6C63_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="435.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-DCE0BCF3-CAD9-4913-8366-FFC54C7D2703" id="sid-DCE0BCF3-CAD9-4913-8366-FFC54C7D2703_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="495.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-066F75F6-C397-41B6-9FB7-D2E0532A862A" id="sid-066F75F6-C397-41B6-9FB7-D2E0532A862A_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="555.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-BECDB481-9B65-4E5C-955B-94657A599D79" id="sid-BECDB481-9B65-4E5C-955B-94657A599D79_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="615.0" y="45.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-0D6455E1-C706-4F3C-99AA-B4993C8CE25D" id="sid-0D6455E1-C706-4F3C-99AA-B4993C8CE25D_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="75.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-5C140FC1-BD9E-41BC-B3AD-ACEBFE8E827A" id="sid-5C140FC1-BD9E-41BC-B3AD-ACEBFE8E827A_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="135.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-A2825D81-BBF7-4761-AC2E-4F458A675263" id="sid-A2825D81-BBF7-4761-AC2E-4F458A675263_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="195.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-350C2C70-5426-47C9-A3BC-9112D477B630" id="sid-350C2C70-5426-47C9-A3BC-9112D477B630_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="255.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-5236A47E-AFF2-4AF9-A1D5-2F022EE9DED2" id="sid-5236A47E-AFF2-4AF9-A1D5-2F022EE9DED2_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="315.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-5E26B3A3-40CA-4E94-B12F-A5E7273D0AFE" id="sid-5E26B3A3-40CA-4E94-B12F-A5E7273D0AFE_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="375.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-FBE76517-456B-41E9-A576-82972AC67D9B" id="sid-FBE76517-456B-41E9-A576-82972AC67D9B_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="435.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-597F6C29-0ECC-4390-973E-5F8A4CF33946" id="sid-597F6C29-0ECC-4390-973E-5F8A4CF33946_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="495.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-C41BB395-D801-4B39-A455-58ADF877957C" id="sid-C41BB395-D801-4B39-A455-58ADF877957C_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="555.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-A2F288D7-3A35-4DE0-B9F8-095637DFF598" id="sid-A2F288D7-3A35-4DE0-B9F8-095637DFF598_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="615.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-44C1AF1B-5847-48DF-9E5B-FAEBF9D9D82C" id="sid-44C1AF1B-5847-48DF-9E5B-FAEBF9D9D82C_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="675.0" y="105.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-E1DF00F5-595D-4F19-A4FB-B7B56F7D749B" id="sid-E1DF00F5-595D-4F19-A4FB-B7B56F7D749B_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="75.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-36947C73-0A89-4A11-84C1-FC98F5937457" id="sid-36947C73-0A89-4A11-84C1-FC98F5937457_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="135.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-18EC0129-B16E-49F7-832C-09C54B2CDE41" id="sid-18EC0129-B16E-49F7-832C-09C54B2CDE41_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="195.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-F19549E6-01D5-45B2-968A-F656FEAFB94D" id="sid-F19549E6-01D5-45B2-968A-F656FEAFB94D_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="255.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-70EC3DEF-7817-4F5F-8702-24C97842E310" id="sid-70EC3DEF-7817-4F5F-8702-24C97842E310_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="315.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-C4539FB6-6503-49D9-A826-92AD3EF66583" id="sid-C4539FB6-6503-49D9-A826-92AD3EF66583_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="375.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-5BB00DA9-1382-4FB2-BEB2-DD137579D091" id="sid-5BB00DA9-1382-4FB2-BEB2-DD137579D091_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="435.0" y="165.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-366430B6-03EF-4F69-8976-ACB8FFDB2A62" id="sid-366430B6-03EF-4F69-8976-ACB8FFDB2A62_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="76.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-ED28192D-E799-4B23-9273-9E53DF6B0450" id="sid-ED28192D-E799-4B23-9273-9E53DF6B0450_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="136.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-026F5E54-03FF-4BF7-BAF4-D8D76A28A639" id="sid-026F5E54-03FF-4BF7-BAF4-D8D76A28A639_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="196.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-AF6143F4-730A-4C7B-8ECE-567BF4E6AF26" id="sid-AF6143F4-730A-4C7B-8ECE-567BF4E6AF26_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="256.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-4EC3A93C-5140-4595-B147-D1D5876EAA3C" id="sid-4EC3A93C-5140-4595-B147-D1D5876EAA3C_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="316.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-15ED99AE-3114-477D-9D6C-0513CF9D1CB8" id="sid-15ED99AE-3114-477D-9D6C-0513CF9D1CB8_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="376.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-1EF6FAA4-BC27-4987-8484-0DE3DAFE00E4" id="sid-1EF6FAA4-BC27-4987-8484-0DE3DAFE00E4_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="436.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-1148ECE9-408E-48F8-88C3-170D1C023254" id="sid-1148ECE9-408E-48F8-88C3-170D1C023254_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="496.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-6B9F0284-6CF5-4D9D-B86B-1D297F371D07" id="sid-6B9F0284-6CF5-4D9D-B86B-1D297F371D07_gui">'
            +'<omgdc:Bounds height="28.0" width="28.0" x="556.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-98324E38-ECC0-4EC9-B734-497A6FDBFB74" id="sid-98324E38-ECC0-4EC9-B734-497A6FDBFB74_gui" isMarkerVisible="true">'
            +'<omgdc:Bounds height="40.0" width="40.0" x="90.0" y="420.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-395B8CF3-7B5F-4352-8E55-26330D84C592" id="sid-395B8CF3-7B5F-4352-8E55-26330D84C592_gui">'
            +'<omgdc:Bounds height="40.0" width="40.0" x="150.0" y="420.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-ADCB5B8E-1D71-4050-8931-5F0948FEAE65" id="sid-ADCB5B8E-1D71-4050-8931-5F0948FEAE65_gui">'
            +'<omgdc:Bounds height="40.0" width="40.0" x="210.0" y="420.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-189D6F05-1963-4399-A234-E602B654CEDA" id="sid-189D6F05-1963-4399-A234-E602B654CEDA_gui">'
            +'<omgdc:Bounds height="40.0" width="40.0" x="264.0" y="420.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-34D60794-8DBE-40C8-AF6D-C873A2F150FE" id="sid-34D60794-8DBE-40C8-AF6D-C873A2F150FE_gui">'
            +'<omgdc:Bounds height="40.0" width="40.0" x="330.0" y="420.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-172D7A6F-3A33-47A6-A565-368E2B546C3B" id="sid-172D7A6F-3A33-47A6-A565-368E2B546C3B_gui" isExpanded="false">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="60.0" y="510.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-6E85ED85-6442-4FB4-B5FE-20E0744838AA" id="sid-6E85ED85-6442-4FB4-B5FE-20E0744838AA_gui" isExpanded="true">'
            +'<omgdc:Bounds height="160.0" width="200.0" x="184.0" y="510.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-0E847243-9D7F-4DD9-AE35-03D3E7E30120" id="sid-0E847243-9D7F-4DD9-AE35-03D3E7E30120_gui" isExpanded="false">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="420.0" y="510.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-D046D4D5-E86C-4B02-8D53-BE5C1F1640C4" id="sid-D046D4D5-E86C-4B02-8D53-BE5C1F1640C4_gui" isExpanded="true">'
            +'<omgdc:Bounds height="160.0" width="280.0" x="525.0" y="480.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-115F482D-098D-4CA3-AEC9-D4939846490A" id="sid-115F482D-098D-4CA3-AEC9-D4939846490A_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="640.0" y="520.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-6457C619-DAE2-4363-91D3-D205CB4C4B64" id="sid-6457C619-DAE2-4363-91D3-D205CB4C4B64_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="565.0" y="545.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-753C593E-2D08-428C-83E7-A27AA3E2F625" id="sid-753C593E-2D08-428C-83E7-A27AA3E2F625_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="60.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-73FD09E7-C38D-4DDE-87C2-69A26B47BCAC" id="sid-73FD09E7-C38D-4DDE-87C2-69A26B47BCAC_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="195.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-F495F943-869B-4EAC-842F-66DB9AD9167A" id="sid-F495F943-869B-4EAC-842F-66DB9AD9167A_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="340.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-64294159-CD3A-4C9D-8DC4-00DED772EBDB" id="sid-64294159-CD3A-4C9D-8DC4-00DED772EBDB_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="480.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-611B1222-9342-4FFF-B102-798F1570B2F0" id="sid-611B1222-9342-4FFF-B102-798F1570B2F0_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="605.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-601C62B1-D56A-48FF-8F59-B8C35D950DB3" id="sid-601C62B1-D56A-48FF-8F59-B8C35D950DB3_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="735.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-88550479-7C4E-4EDE-9E2E-718E09F40FCF" id="sid-88550479-7C4E-4EDE-9E2E-718E09F40FCF_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="855.0" y="705.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-DE446FBA-E58E-4AC3-8155-E2D62F18A6D2" id="sid-DE446FBA-E58E-4AC3-8155-E2D62F18A6D2_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="480.0" y="305.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-F11EBACD-3EB8-44AC-AA80-489385EE43EA" id="sid-F11EBACD-3EB8-44AC-AA80-489385EE43EA_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="488.33333333334303" y="370.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-EBE5A6E7-CCAE-40FF-B601-5147F5B2D50E" id="sid-EBE5A6E7-CCAE-40FF-B601-5147F5B2D50E_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="615.0" y="305.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-DFF37444-972A-4C18-8CB0-148A32B2B34A" id="sid-DFF37444-972A-4C18-8CB0-148A32B2B34A_gui">'
            +'<omgdc:Bounds height="30.0" width="30.0" x="640.0" y="370.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-3BF88717-F91B-4347-A177-55302F2F65A1" id="sid-3BF88717-F91B-4347-A177-55302F2F65A1_gui" isExpanded="true">'
            +'<omgdc:Bounds height="160.0" width="327.0" x="825.0" y="480.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-939CFD9F-2FD3-4A14-BBF9-910D9EE2A4AD" id="sid-939CFD9F-2FD3-4A14-BBF9-910D9EE2A4AD_gui">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="1010.0" y="520.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-2889B588-EA51-4005-A742-157F25B97614" id="sid-2889B588-EA51-4005-A742-157F25B97614_gui" isExpanded="false">'
            +'<omgdc:Bounds height="80.0" width="100.0" x="875.0" y="520.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-50242295-D36F-436C-90A3-6C4F8B3AA7DC" id="sid-50242295-D36F-436C-90A3-6C4F8B3AA7DC_gui">'
            +'<omgdc:Bounds height="97.0" width="88.0" x="240.0" y="296.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-5BD6906C-3E22-440D-BC77-17DE1950030E" id="sid-5BD6906C-3E22-440D-BC77-17DE1950030E_gui">'
            +'<omgdc:Bounds height="60.173" width="62.000999999999976" x="375.0" y="315.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-496EA08C-05C2-483A-8DA0-13670B64DC12" id="sid-496EA08C-05C2-483A-8DA0-13670B64DC12_gui">'
            +'<omgdc:Bounds height="50.0" width="100.0" x="690.0" y="225.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNShape bpmnElement="sid-3F72D3E6-64B6-4971-B7AE-3DA71AB5F3C2" id="sid-3F72D3E6-64B6-4971-B7AE-3DA71AB5F3C2_gui">'
            +'<omgdc:Bounds height="90.0" width="120.0" x="90.0" y="300.0"/>'
         +'</bpmndi:BPMNShape>'
         +'<bpmndi:BPMNEdge bpmnElement="sid-BB6E8CC5-EACB-4368-B420-639646CD381E" id="sid-BB6E8CC5-EACB-4368-B420-639646CD381E_gui">'
            +'<omgdi:waypoint x="284.0" y="296.0"/>'
            +'<omgdi:waypoint x="284.0" y="273.0"/>'
            +'<omgdi:waypoint x="530.0" y="273.0"/>'
            +'<omgdi:waypoint x="530.0" y="305.0"/>'
         +'</bpmndi:BPMNEdge>'
         +'<bpmndi:BPMNEdge bpmnElement="sid-8F2EA0CB-02FF-47FC-97F1-0781C736D3A1" id="sid-8F2EA0CB-02FF-47FC-97F1-0781C736D3A1_gui">'
            +'<omgdi:waypoint x="124.0" y="969.0"/>'
            +'<omgdi:waypoint x="124.0" y="1035.0"/>'
         +'</bpmndi:BPMNEdge>'
         +'<bpmndi:BPMNEdge bpmnElement="sid-198358DC-8026-4E06-A91C-4A8823B4E2A0" id="sid-198358DC-8026-4E06-A91C-4A8823B4E2A0_gui">'
            +'<omgdi:waypoint x="675.0" y="305.0"/>'
            +'<omgdi:waypoint x="690.0" y="252.0"/>'
         +'</bpmndi:BPMNEdge>'
         +'<bpmndi:BPMNEdge bpmnElement="sid-041BCC84-224D-49D0-9778-8FCA4FC5C830" id="sid-041BCC84-224D-49D0-9778-8FCA4FC5C830_gui">'
            +'<omgdi:waypoint x="305.0" y="937.0"/>'
            +'<omgdi:waypoint x="305.0" y="1035.0"/>'
         +'</bpmndi:BPMNEdge>'
         +'<bpmndi:BPMNEdge bpmnElement="sid-A6228EF9-4DE8-404B-9841-3D2A25F6279B" id="sid-A6228EF9-4DE8-404B-9841-3D2A25F6279B_gui">'
            +'<omgdi:waypoint x="595.0" y="560.0"/>'
            +'<omgdi:waypoint x="640.0" y="560.0"/>'
         +'</bpmndi:BPMNEdge>'
      +'</bpmndi:BPMNPlane>'
   +'</bpmndi:BPMNDiagram>'
+'</definitions>';

  var processDefinition = CAM.transform(xml);

  //dump(formatter.formatJson(JSON.stringify(processDefinition)));

  });


  
});