/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.filter.Authorization;
import org.camunda.bpm.webapp.impl.security.filter.PathFilterRule;
import org.camunda.bpm.webapp.impl.security.filter.RequestAuthorizer;
import org.camunda.bpm.webapp.impl.security.filter.RequestFilter;
import org.camunda.bpm.webapp.impl.security.filter.RequestMatcher;
import org.camunda.bpm.webapp.impl.security.filter.SecurityFilterConfig;
import org.camunda.bpm.webapp.impl.security.filter.SecurityFilterRule;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilterRules {
    public static List<SecurityFilterRule> load(InputStream configFileResource) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SecurityFilterConfig config = (SecurityFilterConfig)objectMapper.readValue(configFileResource, SecurityFilterConfig.class);
        return FilterRules.createFilterRules((SecurityFilterConfig)config);
    }

    public static List<SecurityFilterRule> createFilterRules(SecurityFilterConfig config) {
        SecurityFilterConfig.PathFilterConfig pathFilter = config.getPathFilter();
        PathFilterRule rule = FilterRules.createPathFilterRule((SecurityFilterConfig.PathFilterConfig)pathFilter);
        return new ArrayList<PathFilterRule>(Arrays.asList(rule));
    }

    protected static PathFilterRule createPathFilterRule(SecurityFilterConfig.PathFilterConfig pathFilter) {
        PathFilterRule pathFilterRule = new PathFilterRule();
        for (SecurityFilterConfig.PathMatcherConfig pathMatcherConfig : pathFilter.getDeniedPaths()) {
            pathFilterRule.getDeniedPaths().add(FilterRules.transformPathMatcher((SecurityFilterConfig.PathMatcherConfig)pathMatcherConfig));
        }
        for (SecurityFilterConfig.PathMatcherConfig pathMatcherConfig : pathFilter.getAllowedPaths()) {
            pathFilterRule.getAllowedPaths().add(FilterRules.transformPathMatcher((SecurityFilterConfig.PathMatcherConfig)pathMatcherConfig));
        }
        return pathFilterRule;
    }

    protected static RequestMatcher transformPathMatcher(SecurityFilterConfig.PathMatcherConfig pathMatcherConfig) {
        RequestFilter requestMatcher = new RequestFilter(pathMatcherConfig.getPath(), pathMatcherConfig.getParsedMethods());
        RequestAuthorizer requestAuthorizer = RequestAuthorizer.AUTHORIZE_ANNONYMOUS;
        if (pathMatcherConfig.getAuthorizer() != null) {
            String authorizeCls = pathMatcherConfig.getAuthorizer();
            Object[] params = new Object[]{};
            requestAuthorizer = (RequestAuthorizer)ReflectUtil.instantiate((String)authorizeCls);
        }
        return new RequestMatcher(requestMatcher, requestAuthorizer);
    }

    public static Authorization authorize(String requestMethod, String requestUri, List<SecurityFilterRule> filterRules) {
        for (SecurityFilterRule filterRule : filterRules) {
            Authorization authorization = filterRule.authorize(requestMethod, requestUri);
            if (authorization == null) continue;
            return authorization;
        }
        return Authorization.granted((Authentication)Authentication.ANONYMOUS);
    }
}

