define("camunda-tasklist-ui/utils",["angular"],function(n){var e=n.module("cam.tasklist.utils",[]);e.factory("camUID",function(){var n=0;return function(){return n++,n}});var t=function(n){n=n||{},this.prefix=n.prefix||"",this.storage=localStorage};return t.prototype.set=function(n,e){return this.storage.setItem(this.prefix+n,JSON.stringify(e)),this},t.prototype.get=function(n){return JSON.parse(this.storage.getItem(this.prefix+n))},t.prototype.has=function(n){return!!this.storage[this.prefix+n]},t.prototype.remove=function(n){return this.storage.removeItem(this.prefix+n),this},e.factory("camStorage",function(){return new t}),e.factory("camSettings",function(){var n=window.tasklistConf||{};return function(e){return n[e.name?e.name:e]||{}}}),e}),define("camunda-tasklist-ui",["camunda-tasklist-ui/rjsconf","camunda-tasklist-ui/utils"],function(n){function e(n){for(var e,t=[],a=0;a<n.length;a++)e=(require(n[a])||{}).name,e&&t.push(e);return t}function t(){var n=require("angular"),t=n.element,i=e(s).concat(["ngRoute"]);a=n.module("cam.tasklist",i),a.config(["$routeProvider","$locationProvider",function(n){var e=require("text!camunda-tasklist-ui/index.html");n.when("/",{template:e,controller:"pilesCtrl"}).when("/processes",{template:e,controller:"processStartCtrl"}).when("/piles/new",{template:e,controller:"pileNewCtrl"}).when("/login",{template:e,controller:"userLoginCtrl"}).when("/logout",{template:e,controller:"userLogoutCtrl"}).otherwise({redirectTo:"/"})}]),t(document).ready(function(){n.bootstrap(document,["cam.tasklist"])})}n.shim["camunda-tasklist-ui"].push("camunda-tasklist-ui/mocks");var a,s=("undefined"!=typeof window?window.tasklistConf||{}:{},n.shim["camunda-tasklist-ui"]),i=["angular","text!camunda-tasklist-ui/index.html"].concat(s);return require.config(n),require(i,t),{deps:i,appModules:s,loaded:t,rj2ngNames:e,rjsConf:n}}),define("camunda-tasklist-ui/index",function(){}),define("camunda-tasklist-ui/user/data",["angular","jquery"],function(n,e){function t(n){if(n=n||{},!n.defer)throw new Error("defer must be passed in the configuration");this.defer=n.defer}var a=n.module("cam.tasklist.user.data",[]);return t.prototype.get=function(n,t){var a=this.defer();t=t||{};var s,i={};return n.id&&(s=n,n=s.id),e.ajax({url:"/tasklist/users/"+n,data:i}).done(function(n){a.resolve(n._embedded.users)}).fail(function(n,e){a.reject(e)}).always(function(){a.notify("request:complete")}),a.promise},t.prototype.query=function(n){var t=this.defer();n=n||{},t.notify("request:start");var a={};return n.user&&(a.user=n.user.id||n.user),e.ajax({url:"/tasklist/users",data:a}).done(function(n){t.resolve(n._embedded.users)}).fail(function(n,e){t.reject(e)}).always(function(){t.notify("request:complete")}),t.promise},a.factory("camUserData",["$q",function(n){return new t({$q:n})}]),a}),define("text",{load:function(n){throw new Error("Dynamic load not allowed: "+n)}}),define("text!camunda-tasklist-ui/user/login.html",[],function(){return'<form role="form"\n      name="userLogin"\n      ng-controller="userLoginModalFormCtrl"\n      ng-submit="submitForm(userLogin)">\n\n  <div class="modal-header">\n    <h3 class="modal-title">camunda Tasklist | Login</h3>\n  </div>\n\n  <div class="modal-body">\n    <div class="row">\n      <div class="col-md-6 col-sm-12">\n\n        <div class="form-group">\n          <!-- <label for="userLoginInputUsername">User name</label> -->\n          <input required\n                 ng-model="username"\n                 name="username"\n                 type="text"\n                 class="form-control"\n                 id="userLoginInputUsername"\n                 placeholder="User name">\n        </div>\n\n        <div class="form-group">\n          <!-- <label for="userLoginInputPassword">Password</label> -->\n          <input required\n                 ng-model="password"\n                 name="password"\n                 type="password"\n                 class="form-control"\n                 id="userLoginInputPassword"\n                 placeholder="Password">\n        </div>\n\n\n      </div>\n      <div class="col-md-6 col-sm-12">\n\n        <div class="panel panel-default splash-screen">\n          <div class="panel-heading">\n            <h3 class="panel-title">Upcoming camunda Tasklist</h3>\n          </div>\n          <div class="panel-body">\n            This is the <strong>draft</strong> of <a target="_blank" href="https://github.com/camunda/camunda-tasklist-ui">upcoming re-designed tasklist</a> for the <a target="_blank" href="https://github.com/camunda/camunda-bpm-platform">camunda BPM platform</a>.<hr/>\n            For now, you can start a process (by clicking on the <i class="glyphicon glyphicon-list-alt"></i> icon in the header).<br/>\n            If you are looking for a more stable version of the tasklist, please, use the one packaged with the 7.1 version of the camunda BPM platform.\n            <hr/>\n            You can give us some feedback in <a href="https://groups.google.com/forum/#!forum/camunda-bpm-users">the forum</a>.\n          </div>\n        </div>\n\n      </div>\n    </div>\n\n\n  </div>\n\n  <div class="modal-footer">\n<!--\n    <button class="btn btn-xs btn-link"\n            type="button"\n            ng-click="cancel()">Cancel</button>\n -->\n    <button class="btn btn-primary"\n            type="submit"\n            ng-disabled="userLogin.$invalid"\n            ng-click="ok()">Login</button>\n  </div>\n</form>\n'}),define("camunda-tasklist-ui/user/index",["require","angular","moment","jquery","camunda-tasklist-ui/user/data","text!camunda-tasklist-ui/user/login.html"],function(n,e){var t=e.module("cam.tasklist.user",["cam.tasklist.user.data","ui.bootstrap","cam.form"]);return t.controller("userLoginCtrl",["$location","$modal","$scope","$rootScope",function(e,t){t.open({windowClass:"user-login",template:n("text!camunda-tasklist-ui/user/login.html")})}]),t.controller("userLoginModalFormCtrl",["$scope","$rootScope","$location","camStorage","camLegacySessionData","camTasklistNotifier",function(n,e,t,a,s,i){e.$watch("user",function(){n.user=e.user}),n.submitForm=function(n){return n.$valid},n.ok=function(){s.create(n.username,n.password).then(function(n){e.user=n,e.user.id=e.user.id||n.userId,a.set("user",e.user)},function(){e.user={},a.remove("user"),i.add({type:"error",text:"Can not log in with these credentials."})})},n.cancel=function(){a.remove("user"),e.user={},n.$parent.$parent.$dismiss()}}]),t.controller("userLogoutCtrl",["$location","$rootScope","camStorage","camLegacySessionData",function(n,e,t,a){function s(){t.remove("user"),e.user={},n.path("/loggedout")}a.destroy().then(s,s)}]),t}),define("camunda-tasklist-ui/controls/index",["angular"],function(n){var e=n.module("cam.tasklist.controls",[]);return e.directive("camTasklistControls",["$modal","$rootScope",function(n,e){return{link:function(n){n.batchOpen=!1,n.filtersOpen=!1,e.batchActions=e.batchActions||{},e.batchActions.selected=e.batchActions.selected||[],e.$on("batchaction.selection.changed",function(){n.batchOpen=!!e.batchActions.selected.length})},templateUrl:"scripts/controls/controls.html"}}]),e}),define("text!camunda-tasklist-ui/form/inline-field.html",[],function(){return'<span class="view" ng-show="!editing" ng-transclude ng-click="toggleEditing()">\n  {{ value }}\n</span>\n\n<span class="edit" ng-show="editing">\n  <input type="{{ type }}" value="{{ value }}" placeholder="{{ placeholder }}">\n\n  <div class="btn-group">\n    <button type="button" class="btn btn-xs btn-default" ng-click="applyChange()">\n      <span class="glyphicon glyphicon-ok"></span>\n    </button>\n    <button type="button" class="btn btn-xs btn-default" ng-click="cancelChange()">\n      <span class="glyphicon glyphicon-remove"></span>\n    </button>\n  </div>\n</span>\n'}),define("text!camunda-tasklist-ui/form/form.html",[],function(){return'<form class="form-horizontal" role="form">\n\n  <div ng-repeat="(delta, field) in fields">\n    <div ng-switch on="field.type">\n\n      <div class="form-group" ng-switch-when="text">\n        <label for="field-{{ elUID }}-{{ delta }}"\n               class="col-sm-{{ labelsWidth }} control-label">{{ field.label }}</label>\n\n        <div class="col-sm-{{ fieldsWidth }}">\n          <input type="text"\n                 name="{{ field.name }}"\n                 class="form-control"\n                 id="field-{{ elUID }}-{{ delta }}"\n                 placeholder="{{ field.placeholder }}">\n        </div>\n      </div>\n\n      <div class="form-group" ng-switch-when="email">\n        <label for="field-{{ elUID }}-{{ delta }}"\n               class="col-sm-{{ labelsWidth }} control-label">{{ field.label }}</label>\n\n        <div class="col-sm-{{ fieldsWidth }}">\n          <input type="email"\n                 name="{{ field.name }}"\n                 class="form-control"\n                 id="field-{{ elUID }}-{{ delta }}"\n                 placeholder="{{ field.placeholder }}">\n        </div>\n      </div>\n\n      <div class="form-group" ng-switch-when="password">\n        <label for="field-{{ elUID }}-{{ delta }}"\n               class="col-sm-{{ labelsWidth }} control-label">{{ field.label }}</label>\n\n        <div class="col-sm-{{ fieldsWidth }}">\n          <input type="password"\n                 name="{{ field.name }}"\n                 class="form-control"\n                 id="field-{{ elUID }}-{{ delta }}"\n                 placeholder="{{ field.placeholder }}">\n          <input type="password"\n                 name="{{ field.name }}-verif"\n                 class="form-control"\n                 id="field-{{ elUID }}-{{ delta }}"\n                 placeholder="Please re-type to confirm">\n        </div>\n      </div>\n\n      <div class="form-group" ng-switch-when="checkboxes">\n        <label class="col-sm-{{ labelsWidth }} control-label">{{ field.label }}</label>\n        <div class="col-sm-{{ fieldsWidth }} choices">\n\n          <div class="checkbox"\n               ng-repeat="(zeta, choice) in field.choices">\n            <label>\n              <input type="checkbox"\n                     name="{{ field.name }}"\n                     value="{{ choice.value }}"\n                     id="field-{{ elUID }}-{{ delta }}-{{ zeta }}">\n               {{ choice.label }}\n            </label>\n          </div>\n        </div>\n      </div>\n\n      <div class="form-group" ng-switch-when="radios">\n        <label class="col-sm-{{ labelsWidth }} control-label">{{ field.label }}</label>\n        <div class="col-sm-{{ fieldsWidth }} choices">\n\n          <div class="radio"\n               ng-repeat="(zeta, choice) in field.choices">\n            <label>\n              <input type="radio"\n                     name="{{ field.name }}"\n                     value="{{ choice.value }}"\n                     id="field-{{ elUID }}-{{ delta }}-{{ zeta }}">\n               {{ choice.label }}\n            </label>\n          </div>\n        </div>\n      </div>\n<!--\n      <div class="form-group" ng-switch-default>\n        <div class="col-sm-12">\n          <div class="alert alert-danger">{{ field.type }} is not (yet) supported</div>\n        </div>\n      </div>\n -->\n    </div>\n  </div>\n\n  <div class="form-group form-actions">\n    <div class="col-sm-offset-{{ labelsWidth }} col-sm-{{ fieldsWidth }}">\n      <button type="cancel" class="btn btn-link btn-xs">Cancel</button>\n      <button type="submit" class="btn btn-success">Submit</button>\n    </div>\n  </div>\n</form>\n'}),define("camunda-tasklist-ui/form/index",["angular","angular-moment","text!camunda-tasklist-ui/form/inline-field.html","text!camunda-tasklist-ui/form/form.html"],function(n){var e=n.module("cam.form",["angularMoment"]),t=1e3;return e.directive("camFormInlineField",function(){return{scope:{value:"="},link:function(n){n.editing=!1,n.toggleEditing=function(){n.editing=!n.editing},n.applyChange=function(){n.editing=!1},n.cancelChange=function(){n.editing=!1}},transclude:!0,template:require("text!camunda-tasklist-ui/form/inline-field.html")}}),e.directive("camForm",function(){return{link:function(n){n.elUID=t,t++,n.labelsWidth=3,n.fieldsWidth=12-n.labelsWidth},template:require("text!camunda-tasklist-ui/form/form.html")}}),e}),define("camunda-tasklist-ui/pile/data",["angular","jquery"],function(n,e){function t(n){if(n=n||{},!n.defer)throw new Error("$q must be passed in the configuration");this.defer=n.defer}{var a=n.module("cam.tasklist.pile.data",[]),s=a.operators={date:{equal:"=",smaller:"<",smallerOrEqual:"<=",bigger:">",biggerOrEqual:">="}};a.keywords={now:new Date,day:86400,week:604800,month:18144e3},a.filters={due:{operators:s.date},followUp:{operators:s.date},userId:{},processId:{}}}return t.prototype.get=function(){},t.prototype.query=function(n){var t=this.defer();n=n||{},t.notify("request:start");var a={};return n.user&&(a.user=n.user.id||n.user),e.ajax({url:"/tasklist/piles",data:a}).done(function(n){t.resolve(n._embedded.piles)}).fail(function(n,e){t.reject(e)}).always(function(){t.notify("request:complete")}),t.promise},t.prototype.tasks=function(n){var t=this.defer();return n=n||{},t.notify("request:start"),e.ajax({url:"/tasklist/piles/"+n.id}).done(function(n){t.resolve(n)}).fail(function(n,e){t.reject(e)}).always(function(){t.notify("request:complete")}),t.promise},a.factory("camPileData",["$q",function(n){return new t({defer:n.defer})}]),a}),define("text!camunda-tasklist-ui/pile/form.html",[],function(){return'<form class="form-horizontal" role="form" name="newPile">\n  <div class="row">\n    <div class="col-xs-8">\n      <div class="form-group">\n        <label for="form-{{ elUID }}-name" class="col-sm-{{ labelsWidth }} control-label">Name</label>\n        <div class="col-sm-{{ fieldsWidth }}">\n          <input class="form-control"\n                 id="form-{{ elUID }}-name"\n                 type="text"\n                 required\n                 value="{{ pile.name }}"\n                 placeholder="Pile name" />\n        </div>\n      </div>\n    </div>\n    <div class="col-xs-4">\n      <div class="form-group">\n        <label for="form-{{ elUID }}-color" class="col-sm-{{ labelsWidth }} control-label">Color</label>\n        <div class="col-sm-{{ fieldsWidth }}">\n          <input class="form-control minicolors"\n                 id="form-{{ elUID }}-color"\n                 type="text"\n                 value="{{ pile.color }}"\n                 data-control="wheel" />\n        </div>\n      </div>\n    </div>\n  </div>\n\n\n  <div class="form-group">\n    <label for="form-{{ elUID }}-description" class="col-sm-2 control-label">Description</label>\n    <div class="col-sm-10">\n      <input class="form-control"\n             id="form-{{ elUID }}-description"\n             type="text"\n             value="{{ pile.description }}"\n             placeholder="Description" />\n    </div>\n  </div>\n\n\n\n  <div class="form-group filter-add">\n    <div class="col-sm-12 align-right">\n      <a ng-click="addFilter()" href="#">Add filter <span class="glyphicon glyphicon-plus-sign"></span></a>\n    </div>\n  </div>\n\n  <fieldset ng-repeat="(delta, filter) in pile.filters" class="pile-filter">\n    <div class="form-group">\n      <div class="col-xs-4">\n        <select class="form-control" id="form-{{ elUID }}-field-{{ delta }}-key">\n          <option value="keyName">Key name</option>\n        </select>\n      </div>\n\n      <div class="col-xs-4">\n        <select class="form-control" id="form-{{ elUID }}-field-{{ delta }}-operator">\n          <option value="keyName">Operator</option>\n        </select>\n      </div>\n\n      <div class="col-xs-4">\n        <input class="form-control" id="form-{{ elUID }}-field-{{ delta }}-val" value="{{ filter.value }}" type="text" />\n      </div>\n    </div>\n  </fieldset>\n\n  <div class="form-group form-actions">\n    <div class="col-sm-offset-{{ labelsWidth }} col-sm-{{ fieldsWidth }}">\n      <button ng-click="abort()" type="cancel" class="btn btn-link btn-xs">Abort</button>\n      <button ng-click="ok()" type="submit" class="btn btn-success">Save</button>\n    </div>\n  </div>\n</form>\n'}),define("text!camunda-tasklist-ui/pile/list.html",[],function(){return'<div ng-repeat="pile in piles" cam-tasklist-pile>\n\n</div>\n'}),define("text!camunda-tasklist-ui/pile/details.html",[],function(){return'<div class="task-pile">\n  <h4 class="name" ng-click="focus()">{{ pile.name }}</h4>\n\n  <div class="info">\n    <div ng-if="pile.description" class="description">\n      {{ pile.description }}\n    </div>\n\n    <ul class="filters list-unstyled">\n      <li ng-click="edit()" ng-repeat="filter in pile.filters">\n        <span class="key">{{ filter.key }}</span>:\n\n        <span class="operator" ng-if="filter.operator">{{ filter.operator }}</span>\n\n        <span class="value">{{ filter.value }}</span>\n      </li>\n    </ul>\n  </div>\n</div>\n'}),define("text!camunda-tasklist-ui/pile/tasks.html",[],function(){return'<!--\n<pagination total-items="tasks.length"\n            items-per-page="10"\n            max-size="5"\n            class="pagination-sm"\n            boundary-links="true"\n            next-text="&rsaquo;"\n            last-text="&raquo;"\n            previous-text="&lsaquo;"\n            first-text="&laquo;"></pagination>\n -->\n<form role="form">\n  <ol class="list-unstyled">\n    <li class="task" ng-repeat="(delta, task) in tasks">\n      <h4 ng-click="focus(delta)">{{ task.name }}</h4>\n      <ul class="list-inline">\n        <li>\n          <input type="checkbox" name="batch" ng-model="batch" ng-change="batchOperationSelect()" />\n        </li>\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Follow-up date"\n            class="followup-date"\n            ng-class="(task.followUp < now ? \'overdue\' : \'\')">\n          <span class="glyphicon glyphicon-bell"></span>\n          <span cam-form-inline-field value="task.followUp">\n            <span am-time-ago="task.followUp">{{ task.followUp }}</span>\n          </span>\n        </li>\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Due date"\n            class="due-date"\n            ng-class="(task.due < now ? \'overdue\' : \'\')">\n          <span class="glyphicon glyphicon-calendar"></span>\n          <span cam-form-inline-field value="task.due">\n            <span am-time-ago="task.due">{{ task.due }}</span>\n          </span>\n        </li>\n\n        <!--\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Assignee"\n            class="assignee">\n          <span class="glyphicon glyphicon-user"></span>\n          <span cam-form-inline-field value="task.assignee">\n            {{ task.assignee }}\n          </span>\n        </li>\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Owner"\n            class="owner">\n          <span class="glyphicon glyphicon-certificate"></span>\n          <span cam-form-inline-field value="task.owner">\n            {{ task.owner }}\n          </span>\n        </li>\n        -->\n\n      </ul>\n    </li>\n  </ol>\n</form>\n'}),define("camunda-tasklist-ui/pile/index",["require","angular","moment","camunda-tasklist-ui/pile/data","text!camunda-tasklist-ui/pile/form.html","text!camunda-tasklist-ui/pile/list.html","text!camunda-tasklist-ui/pile/details.html","text!camunda-tasklist-ui/pile/tasks.html"],function(n,e){var t=e.module("cam.tasklist.pile",["cam.tasklist.pile.data","ui.bootstrap","cam.form","angularMoment"]),a=0,s=e.element;return t.directive("camTasklistPile",["$modal","$rootScope",function(e,t){return{link:function(n,s){if(n.focus=function(){s.parent().find(".task-pile").removeClass("active"),s.addClass("active").find(".task-pile").addClass("active"),t.currentPile=n.pile,t.$emit("tasklist.pile.current")},n.edit=function(){a++;var n=this.$parent.pile,t=e.open({size:"lg",controller:["$scope",function(e){e.elUID="modal"+a,e.labelsWidth=3,e.fieldsWidth=9,e.pile=n,e.addFilter=function(){console.info("add filter"),e.pile.filters.push({key:"",operator:"",value:""})},e.ok=function(){t.close(e.pile)},e.abort=function(){t.dismiss("cancel")}}],templateUrl:"scripts/pile/form.html"});t.result.then(function(n){console.info("completed",n)},function(n){console.info("rejected",n)})},n.pile&&n.pile.color){var i={"background-color":n.pile.color};s.css(i).find(".task-pile").css(i).find(".info").css(i)}},template:n("text!camunda-tasklist-ui/pile/details.html")}}]),t.directive("camTasklistPiles",["$modal","$rootScope",function(){return{template:n("text!camunda-tasklist-ui/pile/list.html")}}]),t.directive("camTasklistPileTasks",["$modal","$rootScope","camPileData",function(e,t,a){return{link:function(n){n.now=new Date,n.tasks=n.tasks||[],n.pile=n.pile||t.currentPile,n.batchOperationSelect=function(){console.info("selected task",this)},t.$watch("currentPile",function(){t.currentPile&&a.tasks(t.currentPile).then(function(e){console.info("tasklist.pile.current tasks",e),t.currentPile.tasks=n.tasks=e},function(n){console.warn("tasklist.pile.current tasks",n)})}),n.focus=function(e){t.currentTask=n.tasks[e],t.$emit("tasklist.task.current")}},template:n("text!camunda-tasklist-ui/pile/tasks.html")}}]),t.controller("pilesCtrl",["$scope","$rootScope","$modal","camPileData",function(n,e,t,a){n.piles=[],a.query({user:n.user}).then(function(t){console.info("camPileData piles",t),n.piles=t,e.currentPile=n.piles[2],e.$emit("tasklist.pile.current")},function(n){console.info("camPileData query error",n.stack)})}]),t.controller("pileNewCtrl",["$modal","$scope","$rootScope",function(e,t,a){console.warn("Should open a modal window with new pile form."),a.currentPile={name:"",description:"",color:"",filters:[]},s(".task-board").addClass("pile-edit");e.open({scope:t,size:"lg",template:n("text!camunda-tasklist-ui/pile/form.html"),controller:["$modalInstance",function(n){console.info("Hello from the modal instance controller",n)}]}).result.then(function(n){console.info("modalInstance created",n)},function(n){console.info("modalInstance aborted",n)})}]),t}),define("camunda-tasklist-ui/task/data",["angular","jquery"],function(n,e){function t(n){if(n=n||{},!n.$q)throw new Error("$q must be passed in the configuration");this.$q=n.$q}var a=n.module("cam.tasklist.task.data",[]);return a.factory("camTaskHistoryData",function(){return function(){var n=[];return n}}),a.factory("camTaskFormData",function(){return function(){var n=[];return n}}),t.prototype.get=function(){},t.prototype.query=function(){var n=this.$q.defer();return n.notify("request:start"),e.ajax({url:"/tasklist/tasks"}).done(function(e){n.resolve(e)}).fail(function(e,t){n.reject(t)}).always(function(){n.notify("request:complete")}),n.promise},a.factory("camTaskData",["$q",function(n){return new t({$q:n})}]),a}),define("camunda-tasklist-ui/form/data",["angular"],function(n){var e=n.module("cam.tasklist.form.data",[]);return e}),define("text!camunda-tasklist-ui/task/task.html",[],function(){return'<section class="task-card">\n  <header class="row">\n    <div class="col-xs-12">\n      <div class="actions">\n        <!--\n        <div class="full-size">\n          <a href="#" ng-click="modalView()">\n            <span class="glyphicon glyphicon-resize-full"></span>\n          </a>\n        </div>\n        <div class="batch-selection">\n          <input type="checkbox" ng-model="selected" ng-click="batchSelect()" />\n        </div>\n        -->\n      </div>\n\n      <div class="names">\n        <h2>{{ task.name }}</h2>\n        <h4>{{ task.processDefinitionName }}</h4>\n      </div>\n\n      <ul class="meta list-inline">\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Follow-up date"\n            class="followup-date"\n            ng-class="(task.followUp < now ? \'overdue\' : \'\')">\n          <span class="glyphicon glyphicon-bell"></span>\n          <span cam-form-inline-field value="task.followUp">\n            <span am-time-ago="task.followUp">{{ task.followUp }}</span>\n          </span>\n        </li>\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Due date"\n            class="due-date"\n            ng-class="(task.due < now ? \'overdue\' : \'\')">\n          <span class="glyphicon glyphicon-calendar"></span>\n          <span cam-form-inline-field value="task.due">\n            <span am-time-ago="task.due">{{ task.due }}</span>\n          </span>\n        </li>\n\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Assignee"\n            class="assignee">\n          <span class="glyphicon glyphicon-user"></span>\n          <span cam-form-inline-field value="task.assignee">\n            {{ task.assignee }}\n          </span>\n        </li>\n        <li data-toggle="tooltip"\n            data-placement="top"\n            title="Owner"\n            class="owner">\n          <span class="glyphicon glyphicon-certificate"></span>\n          <span cam-form-inline-field value="task.owner">\n            {{ task.owner }}\n          </span>\n        </li>\n      </ul>\n    </div>\n  </header>\n\n  <div class="row tabbed-content">\n    <div class="col-xs-12">\n      <ul class="nav nav-tabs">\n        <li>\n          <a href="#tab-{{ elUID }}-form" data-toggle="tab">Form</a>\n        </li>\n\n        <li>\n          <a href="#tab-{{ elUID }}-description" data-toggle="tab">Description</a>\n        </li>\n\n        <li>\n          <a href="#tab-{{ elUID }}-history" data-toggle="tab">History</a>\n        </li>\n\n        <li>\n          <a href="#tab-{{ elUID }}-process" data-toggle="tab">Process</a>\n        </li>\n      </ul>\n\n      <div class="tab-content">\n        <div class="tab-pane"\n             id="tab-{{ elUID }}-form"\n             cam-tasklist-task-form\n             task="task"></div>\n\n        <div class="tab-pane"\n             id="tab-{{ elUID }}-description">\n          {{ task.description }}\n        </div>\n\n        <div class="tab-pane"\n             id="tab-{{ elUID }}-history"\n             cam-tasklist-task-history\n             history="history">\n        </div>\n\n        <div class="tab-pane"\n             id="tab-{{ elUID }}-process">\n          <img src="/images/user-task.png" />\n        </div>\n      </div>\n    </div>\n  </div>\n</section>\n'}),define("text!camunda-tasklist-ui/task/form.html",[],function(){return"<!-- /home/vale/repos/camunda-tasklist-ui/client/scripts/task/form.html -->\n"}),define("text!camunda-tasklist-ui/task/history.html",[],function(){return'<div class="day row" ng-repeat="day in days">\n  <div class="col-xs-2">\n    <div class="date-badge">\n      <span class="day">{{ day.date.day }}</span>\n      <span class="month">{{ day.date.month }}</span>\n      <span class="year">{{ day.date.year }}</span>\n    </div>\n  </div>\n\n  <div class="col-xs-10 instant">\n    <div class="instant row" ng-repeat="(time, events) in day.events">\n      <div class="col-xs-2 time-badge">\n        <a href="#"\n           data-toggle="tooltip"\n           data-placement="top"\n           title="User Name"\n           class="user-picture"></a>\n        {{ time }}\n      </div>\n\n      <div class="col-xs-10">\n        <div class="event" ng-repeat="(delta, event) in events">\n          <div ng-if="(event.orgValue || event.newValue) && event.operationType" class="row">\n            <div class="operation col-xs-12">\n              <span class="label">Operation:</span> {{ event.operationType }}\n            </div>\n\n            <div class="col-lg-6 original-value">\n              <div class="label">\n                Original value:\n              </div>\n              <div class="value">\n                {{ event.orgValue }}\n              </div>\n            </div>\n\n            <div class="col-lg-6 new-value">\n              <div class="label">\n                New value:\n              </div>\n              <div class="value">\n                {{ event.newValue }}\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n'}),define("camunda-tasklist-ui/task/index",["angular","moment","camunda-tasklist-ui/utils","camunda-tasklist-ui/task/data","camunda-tasklist-ui/form/data","angular-bootstrap","text!camunda-tasklist-ui/task/task.html","text!camunda-tasklist-ui/task/form.html","text!camunda-tasklist-ui/task/history.html"],function(n,e){var t=n.module("cam.tasklist.task",["cam.tasklist.utils","cam.tasklist.task.data","cam.tasklist.form.data","ui.bootstrap","cam.form","angularMoment"]);return t.directive("camTasklistTask",["$modal","$rootScope","camUID",function(n,e,t){return e.batchActions={},e.batchActions.selected=[],{link:function(n,a){n.task=n.task||e.currentTask,n.elUID=t(),a.find(".nav li").eq(0).addClass("active"),a.find(".tab-pane").eq(0).addClass("active"),e.$on("tasklist.task.current",function(){n.task=e.currentTask,a.find('[data-toggle="tooltip"]').tooltip()})},template:require("text!camunda-tasklist-ui/task/task.html")}}]),t.directive("camTasklistTaskForm",["camTaskFormData","$rootScope","camUID",function(n,e,t){return{link:function(a,s){a.elUID=t(),a.labelsWidth=3,a.fieldsWidth=12-a.labelsWidth,e.$on("tasklist.task.current",function(){a.fields=n(),s.find('[data-toggle="tooltip"]').tooltip()})},template:require("text!camunda-tasklist-ui/task/form.html")}}]),t.directive("camTasklistTaskHistory",["camTaskHistoryData","$rootScope",function(t,a){return{link:function(s,i){s.history=[],s.days=[],a.$on("tasklist.task.current",function(){s.history=t(null,null),s.now=new Date;var a={};n.forEach(s.history,function(n){var t=e(n.timestamp,"X"),s=t.format("DD-MMMM-YYYY"),i=t.format("HH:mm"),l=s.split("-");a[s]=a[s]||{date:{day:l[0],month:l[1],year:l[2]},events:{}},a[s].events[i]=a[s].events[i]||[],a[s].events[i].push(n)}),s.days=a,setTimeout(function(){i.find('[data-toggle="tooltip"]').tooltip()},10)})},template:require("text!camunda-tasklist-ui/task/history.html")}}]),t}),define("camunda-tasklist-ui/process/data",["angular","jquery"],function(n,e){function t(n,e){for(var t in e)n=n.replace(new RegExp("{{"+t+"}}","g"),e[t]);return n}function a(n){if(n=n||{},!n.defer)throw new Error("defer must be passed in the configuration");this.defer=n.defer,this.baseUrl=n.baseUrl||"/camunda/api/engine/engine/default"}function s(n){if(n=n||{},!n.defer)throw new Error("defer must be passed in the configuration");this.defer=n.defer}var i=n.module("cam.tasklist.process.data",[]);return a.prototype.query=function(n){n=n||{};var a=this.defer(),s={type:n.type||"GET",dataType:"json",contentType:"application/json;charset=UTF-8",url:this.baseUrl+t(n.path||"",n.instance||{})};return n.data&&(s.data="GET"!==s.type.toUpperCase()?JSON.stringify(n.data):n.data),a.notify("request:start"),e.ajax(s).done(function(n){a.resolve(n)}).fail(function(n,e){a.reject(e)}).always(function(){a.notify("request:complete")}),a.promise},a.prototype.list=function(n){return n=n||{},n.latest=n.latest||"true",this.query({data:n,path:"/process-definition"})},a.prototype.count=function(n){return n=n||{},n.latest=n.latest||"true",this.query({path:"/process-definition/count"})},a.prototype.byId=function(n){return this.query({path:"/process-definition/{{id}}",instance:{id:n}})},a.prototype.byKey=function(n){return this.query({path:"/process-definition/key/{{key}}",instance:{key:n}})},a.prototype.start=function(n,e){return e=e||{},e.data=e.data||{variables:{}},this.query({type:"POST",path:"/process-definition/key/{{key}}/start",instance:{key:n},data:e.data})},i.factory("camLegacyProcessData",["$q",function(n){return new a({defer:n.defer})}]),s.prototype.get=function(n,t){var a=this.defer();t=t||{};var s,i={};return n.id&&(s=n,n=s.id),e.ajax({url:"/tasklist/processes/"+n,data:i}).done(function(n){a.resolve(n._embedded.processes)}).fail(function(n,e){a.reject(e)}).always(function(){a.notify("request:complete")}),a.promise
},s.prototype.query=function(n){var t=this.defer();n=n||{},t.notify("request:start");var a={};return n.process&&(a.process=n.process.id||n.process),e.ajax({url:"/tasklist/processes",data:a}).done(function(n){t.resolve(n._embedded.processes)}).fail(function(n,e){t.reject(e)}).always(function(){t.notify("request:complete")}),t.promise},i.factory("camProcessData",["$q",function(n){return new s({defer:n.defer})}]),i}),define("text!camunda-tasklist-ui/process/start.html",[],function(){return'<form role="form"\n      name="processStart"\n      ng-class="{loading: loadingProcesses}"\n      ng-controller="processStartModalFormCtrl"\n      ng-submit="submitForm(processStart)">\n\n  <div class="modal-header">\n    <div class="row">\n      <div class="col-xs-6">\n        <h3 class="modal-title">Start a process</h3>\n      </div>\n\n      <div class="col-xs-6">\n        <div class="input-group has-feedback"\n             ng-if="!startingProcess">\n          <input type="text"\n                 ng-model="searchProcess"\n                 placeholder="Process name"\n                 tooltip="Search by process name, case sensitive."\n                 tooltip-placement="left"\n                 typeahead="process.name for process in lookupProcess($viewValue)"\n                 typeahead-loading="loadingProcesses"\n                 typeahead-wait-ms="100"\n                 typeahead-on-select="selected($item, $model, $label)"\n                 class="form-control">\n          <span class="input-group-addon">\n            <i ng-show="loadingProcesses"\n               class="glyphicon glyphicon-refresh"></i>\n\n            <i ng-show="!loadingProcesses"\n               class="glyphicon glyphicon-search"></i>\n          </span>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class="modal-body">\n    <div ng-if="!startingProcess"\n         class="available-processes">\n      <div class="text-help">\n        <i class="glyphicon glyphicon-info-sign"></i>\n        Click on the process to start.\n      </div>\n\n      <ul class="processes">\n        <li ng-repeat="process in processes">\n          <a ng-click="getStartForm(process)">\n            {{ process.name || process.key }}\n          </a>\n        </li>\n      </ul>\n    </div>\n\n    <div ng-if="startingProcess"\n         class="starting-process">\n      <h4>\n        {{ startingProcess.name || startingProcess.key }}\n      </h4>\n\n      <!-- <div></div> -->\n\n      <div class="process-form-fields">\n        <div ng-repeat="(delta, variable) in variables"\n             class="form-group row">\n          <div class="col-xs-2 text-right">\n            <a ng-click="removeVariable(delta)">\n              <i class="glyphicon glyphicon-minus-sign"></i>\n            </a>\n          </div>\n\n          <div class="col-xs-3">\n            <input required\n                   type="text"\n                   class="form-control"\n                   placeholder="Variable name"\n                   ng-model="variable.name" />\n          </div>\n\n          <div class="col-xs-3">\n            <select required\n                    class="form-control"\n                    placeholder="Variable name"\n                    ng-model="variable.type">\n\n              <option disabled value="">Type</options>\n\n              <option ng-repeat="(type, inputType) in variableTypes"\n                      value="{{ type }}">{{ type }}</option>\n            </select>\n          </div>\n\n          <div class="col-xs-4">\n            <div ng-switch="variable.type">\n              <div ng-switch-when="Boolean" class="checkbox">\n                <label>\n                  <input type="checkbox"\n                         ng-model="variable.value"\n                         ng-checked="variable.value" />\n                </label>\n              </div>\n\n              <!--\n              <input ng-switch-when="Date"\n                     required\n                     type="date"\n                     class="form-control"\n                     placeholder="2014-06-22"\n                     ng-model="variable.value" />\n              -->\n\n              <input ng-switch-default\n                     required\n                     type="{{ variableTypes[variable.type] }}"\n                     class="form-control"\n                     placeholder="Value"\n                     ng-model="variable.value" />\n            </div>\n          </div>\n        </div>\n\n        <div class="row">\n          <div class="col-xs-12 col-md-2 text-right">\n            <a ng-click="addVariable()">\n              Add a variable\n              <i class="glyphicon glyphicon-plus-sign"></i>\n            </a>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class="modal-footer">\n    <!--\n    <div ng-if="!startingProcess">\n      <pagination boundary-links="true"\n                  items-per-page="itemsPerPage"\n                  total-items="totalProcesses"\n                  ng-model="currentPage"\n                  ng-change="pageChanged()"\n                  class="pagination-sm"\n                  previous-text="&lsaquo;"\n                  next-text="&rsaquo;"\n                  first-text="&laquo;"\n                  last-text="&raquo;"></pagination>\n    </div>\n    -->\n\n    <div ng-if="startingProcess">\n      <button class="btn btn-xs btn-link"\n              type="button"\n              ng-click="showList()">back</button>\n\n      <button class="btn btn-primary"\n              type="submit"\n              ng-disabled="$invalid"\n              ng-click="startProcess()">Start</button>\n    </div>\n  </div>\n</form>\n'}),define("camunda-tasklist-ui/process/index",["angular","angular-bootstrap","camunda-tasklist-ui/process/data","text!camunda-tasklist-ui/process/start.html"],function(n){var e=n.module("cam.tasklist.process",["cam.tasklist.process.data","ui.bootstrap"]);return e.controller("processStartModalFormCtrl",["$scope","$q","camLegacyProcessData",function(e,t,a){function s(t){var a=e.$parent&&e.$parent.$parent&&n.isFunction(e.$parent.$parent.$close),s=a?e.$parent.$parent.$close:n.noop;s(t)}function i(){e.loadingProcesses=!1}var l={name:"",value:"",type:""},o={Boolean:"checkbox",Integer:"text",Double:"text",Long:"text",Short:"text",String:"text",Date:"datetime"};e.currentPage=1,e.itemsPerPage=25,e.totalProcesses=0,e.processes=[],e.variables=[],e.variableTypes=o,e.loadingProcesses=!1,e.selected=function(n){e.startingProcess=n},e.lookupProcess=function(n){if(n.length>2)return e.loadingProcesses=!0,a.list({nameLike:"%"+n+"%"}).then(function(){return e.loadingProcesses=!1,e.processes},i);var s=t.defer();return s.resolve(e.processes),s.promise},e.showList=function(){e.startingProcess=null},e.loadProcesses=function(){e.loadingProcesses=!0;var n={};a.count(n).then(function(t){e.totalProcesses=t.count,n.maxResults=n.maxResults||e.itemsPerPage,a.list(n).then(function(n){e.loadingProcesses=!1,e.processes=n,console.info("processes loaded",e)},i)},i)},e.loadProcesses(),e.getStartForm=function(n){e.startingProcess=n,e.variables=[],e.addVariable()},e.addVariable=function(){e.variables.push(n.copy(l))},e.addVariable(),e.removeVariable=function(t){var a=[];n.forEach(e.variables,function(n,e){e!=t&&a.push(n)}),e.variables=a},e.submitForm=function(){if(!e.startingProcess||!e.startingProcess.key)return!1;var t={};n.forEach(e.variables,function(n){"$"!==n.name[0]&&(t[n.name]={type:n.type,value:n.value})}),a.start(e.startingProcess.key,{data:{variables:t}}).then(function(n){s(n)},i)}}]),e.controller("processStartCtrl",["$modal","$scope","$location","$rootScope",function(n,e,t){function a(){t.path("/")}var s=n.open({size:"lg",template:require("text!camunda-tasklist-ui/process/start.html")});s.result.then(a,a)}]),e}),define("camunda-tasklist-ui/session/data",["angular","jquery"],function(n,e){function t(n,e){for(var t in e)n=n.replace(new RegExp("{{"+t+"}}","g"),e[t]);return n}function a(n){if(n=n||{},!n.defer)throw new Error("defer must be passed in the configuration");this.defer=n.defer,this.baseUrl=n.baseUrl||"/camunda/api/admin/auth/user/default"}var s=n.module("cam.tasklist.session.data",[]);return a.prototype.query=function(n){n=n||{};var a=this.defer(),s={type:n.type||"GET",dataType:"json",contentType:"application/x-www-form-urlencoded",url:this.baseUrl+t(n.path||"",n.instance||{})};return n.data&&(s.data=n.data),a.notify("request:start"),e.ajax(s).done(function(n){a.resolve(n)}).fail(function(n,e,t){a.reject(t instanceof Error?t:new Error(t))}).always(function(){a.notify("request:complete")}),a.promise},a.prototype.create=function(n,e){return this.query({type:"POST",path:"/login/tasklist",data:{username:n,password:e}})},a.prototype.retrieve=function(){return this.query()},a.prototype.destroy=function(){return this.query({type:"POST",path:"/logout"})},s.factory("camLegacySessionData",["$q",function(n){return new a({defer:n.defer})}]),s}),define("camunda-tasklist-ui/session/index",["angular","camunda-tasklist-ui/session/data"],function(n){var e=n.module("cam.tasklist.session",["cam.tasklist.session.data"]);return e}),+function(n){var e=function(t,a){this.$element=n(t),this.options=n.extend({},e.DEFAULTS,a),this.transitioning=null,this.options.parent&&(this.$parent=n(this.options.parent)),this.options.toggle&&this.toggle()};e.DEFAULTS={toggle:!0},e.prototype.dimension=function(){var n=this.$element.hasClass("width");return n?"width":"height"},e.prototype.show=function(){if(!this.transitioning&&!this.$element.hasClass("in")){var e=n.Event("show.bs.collapse");if(this.$element.trigger(e),!e.isDefaultPrevented()){var t=this.$parent&&this.$parent.find("> .panel > .in");if(t&&t.length){var a=t.data("bs.collapse");if(a&&a.transitioning)return;t.collapse("hide"),a||t.data("bs.collapse",null)}var s=this.dimension();this.$element.removeClass("collapse").addClass("collapsing")[s](0),this.transitioning=1;var i=function(){this.$element.removeClass("collapsing").addClass("collapse in")[s]("auto"),this.transitioning=0,this.$element.trigger("shown.bs.collapse")};if(!n.support.transition)return i.call(this);var l=n.camelCase(["scroll",s].join("-"));this.$element.one(n.support.transition.end,n.proxy(i,this)).emulateTransitionEnd(350)[s](this.$element[0][l])}}},e.prototype.hide=function(){if(!this.transitioning&&this.$element.hasClass("in")){var e=n.Event("hide.bs.collapse");if(this.$element.trigger(e),!e.isDefaultPrevented()){var t=this.dimension();this.$element[t](this.$element[t]())[0].offsetHeight,this.$element.addClass("collapsing").removeClass("collapse").removeClass("in"),this.transitioning=1;var a=function(){this.transitioning=0,this.$element.trigger("hidden.bs.collapse").removeClass("collapsing").addClass("collapse")};return n.support.transition?void this.$element[t](0).one(n.support.transition.end,n.proxy(a,this)).emulateTransitionEnd(350):a.call(this)}}},e.prototype.toggle=function(){this[this.$element.hasClass("in")?"hide":"show"]()};var t=n.fn.collapse;n.fn.collapse=function(t){return this.each(function(){var a=n(this),s=a.data("bs.collapse"),i=n.extend({},e.DEFAULTS,a.data(),"object"==typeof t&&t);!s&&i.toggle&&"show"==t&&(t=!t),s||a.data("bs.collapse",s=new e(this,i)),"string"==typeof t&&s[t]()})},n.fn.collapse.Constructor=e,n.fn.collapse.noConflict=function(){return n.fn.collapse=t,this},n(document).on("click.bs.collapse.data-api","[data-toggle=collapse]",function(e){var t,a=n(this),s=a.attr("data-target")||e.preventDefault()||(t=a.attr("href"))&&t.replace(/.*(?=#[^\s]+$)/,""),i=n(s),l=i.data("bs.collapse"),o=l?"toggle":a.data(),r=a.attr("data-parent"),c=r&&n(r);l&&l.transitioning||(c&&c.find('[data-toggle=collapse][data-parent="'+r+'"]').not(a).addClass("collapsed"),a[i.hasClass("in")?"addClass":"removeClass"]("collapsed")),i.collapse(o)})}(jQuery),define("bootstrap/collapse",function(){}),define("text!camunda-tasklist-ui/navigation/navigation.html",[],function(){return'\n      <div class="container-fluid">\n        <!-- Brand and toggle get grouped for better mobile display -->\n        <div class="navbar-header">\n          <button type="button"\n                  class="navbar-toggle"\n                  data-toggle="collapse"\n                  data-target="#cam-tasklist-navigation">\n            <span class="sr-only">Toggle navigation</span>\n            <span class="icon-bar"></span>\n            <span class="icon-bar"></span>\n            <span class="icon-bar"></span>\n          </button>\n          <a class="navbar-brand" href="#">camunda Tasklist</a>\n        </div>\n\n        <!-- Collect the nav links, forms, and other content for toggling -->\n        <div class="collapse navbar-collapse"\n             id="cam-tasklist-navigation">\n          <ul class="nav navbar-nav navbar-right"\n              ng-if="user.id">\n\n            <li>\n              <a tooltip-placement="bottom"\n                 tooltip="Manage your account"\n                 ng-href="/camunda/app/admin/default/#/users/{{ user.id }}?tab=profile">\n                {{ user.id }}\n              </a>\n            </li>\n\n            <li>\n              <a tooltip-placement="bottom"\n                 tooltip="Start a process"\n                 href="#/processes">\n                <i class="glyphicon glyphicon-list-alt"></i>\n              </a>\n            </li>\n            <li>\n              <a tooltip-placement="bottom"\n                 tooltip="Log out"\n                 href="#/logout">\n                <i class="glyphicon glyphicon-log-out"></i>\n              </a>\n            </li>\n\n\n            <li class="divider"></li>\n\n\n            <li ng-repeat="link in links"\n                class="dropdown"\n                ng-class="{dropdown: (link.links && link.links.length)}">\n              <a ng-if="!link.links || !link.links.length"\n                 href="{{ link.href }}">\n                {{ link.title }}\n                <i class="glyphicon glyphicon-{{ link.icon }}"></i>\n              </a>\n\n              <a ng-if="link.links && link.links.length"\n                 href\n                 class="dropdown-toggle"\n                 data-toggle="dropdown">\n                {{ link.title }}\n                <i ng-if="link.icon"\n                   class="glyphicon glyphicon-{{ link.icon }}"></i>\n                <b class="caret"></b>\n              </a>\n              <ul ng-if="link.links && link.links.length"\n                  class="dropdown-menu">\n                <li ng-repeat="link in link.links">\n                  <a href="{{ link.href }}">\n                    {{ link.title }}\n                    <i ng-if="link.icon"\n                       class="glyphicon glyphicon-{{ link.icon }}"></i>\n                  </a>\n                </li>\n              </ul>\n            </li>\n          </ul>\n\n          <ul class="nav navbar-nav navbar-right" ng-if="!user.id">\n            <li>\n              <a tooltip-placement="bottom"\n                 tooltip="Log in"\n                 href="#/login">\n                <i class="glyphicon glyphicon-log-in"></i>\n              </a>\n            </li>\n          </ul>\n        </div><!-- /.navbar-collapse -->\n      </div><!-- /.container-fluid -->\n'}),define("camunda-tasklist-ui/navigation/index",["angular","camunda-tasklist-ui/utils","text!camunda-tasklist-ui/navigation/navigation.html","camunda-tasklist-ui/session"],function(n){var e=n.module("cam.tasklist.navigation",[require("camunda-tasklist-ui/utils").name,"ui.bootstrap","cam.tasklist.user","cam.tasklist.session"]);return e.directive("camTasklistNavigation",function(){return{scope:{},controller:["$rootScope","$scope","$modal","camStorage","camSettings","camLegacySessionData","camTasklistNotifier",function(n,t,a,s,i,l,o){function r(e){l.retrieve().then(function(e){n.user=e,n.user.id=n.user.id||e.userId,s.set("user",n.user),c&&c.close()},function(t){console.info("nopeeee....",t,e),e||o.add({type:"error",text:"You can not log in with these credentials."}),s.remove("user"),n.user={},c=a.open({backdrop:!1,keyboard:!1,windowClass:"user-login",template:require("text!camunda-tasklist-ui/user/login.html")})})}var c,d,u=i(e);t.links=u.links||[],t.user=n.user,n.$watch("user",function(){""+n.user.id!=""+d&&(d=n.user.id,t.user=n.user,d?c&&(c.close(),c=null):c||r())}),t.user||(n.user=s.get("user")||{}),n.user.id||c||r(!0)}],template:require("text!camunda-tasklist-ui/navigation/navigation.html")}}),e}),define("text!camunda-tasklist-ui/notifier/notifier.html",[],function(){return'<div class="notifier"\n     ng-show="messages.length">\n  <div ng-repeat="message in messages"\n       class="notification notification-{{ message.type }}">\n    <div class="text">\n      {{ message.text }}\n    </div>\n\n    <a href\n       class="dismiss"\n       ng-click="remove(message.id)">\n      <span class="glyphicon glyphicon-remove"></span>\n    </a>\n  </div>\n</diV>\n'}),define("camunda-tasklist-ui/notifier/index",["angular","angular-animate","text!camunda-tasklist-ui/notifier/notifier.html"],function(n){function e(n){this.scope=n,this._messages=[]}var t=n.module("cam.tasklist.notifier",["ngAnimate"]),a=n.forEach,s=0;return e.prototype.scope=null,e.prototype._messages=[],e.prototype.get=function(n){if(!n)return this._messages;var e=[];return a(this._messages,function(n){"type"===n.type&&e.push(n)}),e},e.prototype.add=function(e){e=n.isArray(e)?e:[e];var t=this;return a(e,function(e){s++;var a="",i="info";n.isString(e)?a=e:e instanceof Error?(a=e.message,i="error"):e.text&&(i=e.type||i,a=e.text||a),t._messages.push({id:s,text:a,type:i})}),t.scope.$broadcast("notifier:message",t._messages),t},e.prototype.dismiss=function(n){var e=this;if(n){var t=[];a(e._messages,function(e){e.id!==n&&t.push(e)}),e._messages=t}else e._messages=[];return e.scope.$broadcast("notifier:message",e._messages),e},t.factory("camTasklistNotifier",["$rootScope",function(n){return new e(n)}]),t.directive("camTasklistNotifier",function(){return{scope:{},controller:["$rootScope","$scope","$timeout","camTasklistNotifier",function(n,e,t,s){e.remove=function(n){s.dismiss(n)},n.$on("notifier:message",function(n,s){a(s,function(n){n.duration!==!1&&t(function(){e.remove(n.id)},n.duration||4e3)}),e.messages=s}),e.messages=s.get()}],template:require("text!camunda-tasklist-ui/notifier/notifier.html")}}),t}),define("text!camunda-tasklist-ui/index.html",[],function(){return'\n\n\n\n    <!-- # page-navigation -->\n    <nav class="navbar navbar-default" role="navigation" cam-tasklist-navigation>\n    </nav>\n    <!-- / page-navigation -->\n\n\n    <div class="container-fluid">\n      <div class="row controls">\n        <div class="cols col-sm-2 task-piles">\n          <div class="inner">\n            <h5>\n              <a href="#/piles/new">New pile <span class="glyphicon glyphicon-plus-sign"></span></a>\n            </h5>\n          </div>\n        </div>\n\n        <div class="cols col-sm-4 current-pile">\n          <div class="inner">\n            <div class="row">\n              <div class="col-xs-12">\n              <!--\n              <div class="col-xs-6">\n                <h5>&nbsp;</h5>\n              </div>\n              <div class="col-xs-6 dropdown sorting">\n              -->\n                <a data-toggle="dropdown" href="#">Sort by <span class="sort-by">Due date</span></a>\n                <a href="#" class="sort-direction glyphicon glyphicon-chevron-up"></a>\n                <ul class="dropdown-menu dropdown-menu-right" role="menu">\n                  <li role="presentation">\n                    <a role="menuitem" tabindex="-1" href="#">Due date</a>\n                  </li>\n\n                  <li role="presentation">\n                    <a role="menuitem" tabindex="-1" href="#">Follow up date</a>\n                  </li>\n\n                  <li role="presentation">\n                    <a role="menuitem" tabindex="-1" href="#">Task name</a>\n                  </li>\n\n                  <li role="presentation">\n                    <a role="menuitem" tabindex="-1" href="#">Assignee</a>\n                  </li>\n                  <li role="presentation">\n                    <a role="menuitem" tabindex="-1" href="#">Owner</a>\n                  </li>\n\n                </ul>\n              </div>\n            </div>\n          </div>\n        </div>\n\n        <div class="cols col-sm-6 current-task">\n          <div class="inner">\n            <h5>&nbsp;</h5>\n          </div>\n        </div>\n      </div>\n\n      <div class="row task-board">\n        <div class="cols col-sm-2 task-piles">\n          <div class="inner">\n            <div cam-tasklist-piles></div>\n          </div>\n        </div>\n\n        <div class="cols col-sm-4 task-list">\n          <div cam-tasklist-pile-tasks></div>\n        </div>\n\n        <div class="cols col-sm-6 current-task">\n          <div cam-tasklist-task></div>\n        </div>\n      </div>\n    </div>\n'});
//# sourceMappingURL=camunda-tasklist-ui.js.map