/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.camunda.commons.utils.IoUtilLogger;
import org.camunda.commons.utils.UtilsLogger;

public final class IoUtil {
    private static final IoUtilLogger LOG = UtilsLogger.IO_UTIL_LOGGER;

    public static String inputStreamAsString(InputStream inputStream) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[16384];
            int read = 0;
            while ((read = inputStream.read(buffer)) > 0) {
                os.write(buffer, 0, read);
            }
            String string = os.toString("utf-8");
            return string;
        }
        catch (IOException e) {
            throw LOG.unableToReadInputStream(e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static InputStream stringAsInputStream(String string) {
        return new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
    }

    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

