/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.camunda.automator.AutomatorAPI;
import org.camunda.automator.AutomatorCLI;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@Component
public class AutomatorCLI
implements CommandLineRunner {
    public static boolean isRunningCLI = false;
    static Logger logger = LoggerFactory.getLogger(AutomatorCLI.class);
    @Autowired
    AutomatorAPI automatorAPI;
    @Autowired
    ConfigurationBpmEngine engineConfiguration;

    public static void main(String[] args) {
        isRunningCLI = true;
        SpringApplication app = new SpringApplication(new Class[]{AutomatorCLI.class});
        app.setBannerMode(Banner.Mode.OFF);
        System.exit(SpringApplication.exit((ApplicationContext)app.run(args), (ExitCodeGenerator[])new ExitCodeGenerator[0]));
    }

    private static void printUsage() {
        System.out.println("Usage: <option> <action> <parameter>");
        System.out.println("  -s, --server <serverName>");
        System.out.println("    Which server to use in the configuration");
        System.out.println("  -e, --engine ConnectionUrlString");
        System.out.println("    CAMUNDA7;<URL>");
        System.out.println("    CAMUNDA8;CLOUD;<region>;<clusterId>;<clientIs>;<clientSecret>");
        System.out.println("      CAMUNDA8;LOCAL;<gateway>;<plaintext>");
        System.out.println("  -l, --level <DEBUG|COMPLETE|MONITORING|MAIN|NOTHING>");
        System.out.println("       Define the level of log (MONITORING is the default)");
        System.out.println("  -n, --numberofexecution <number>");
        System.out.println("     override the number of execution for the scenario");
        System.out.println("  -d, --deploy <TRUE|FALSE>");
        System.out.println("     Allow deployment of process is defined in the scenario (default is TRUE)");
        System.out.println("  -x, --execute");
        System.out.println("     execute the scenario");
        System.out.println("  -v, --verification");
        System.out.println("     verify the scenario");
        System.out.println("  -f, --fullreport");
        System.out.println("     Full report");
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("   run <scenarioFile>");
        System.out.println("       execute one scenario");
        System.out.println("   recursive <folder>");
        System.out.println("      all *.json in the folder and sub-folder are monitored and executed");
    }

    private static ConfigurationBpmEngine decodeConfiguration(String propertiesFileName) throws Exception {
        throw new Exception("Not yet implemented");
    }

    private static List<File> detectRecursiveScenario(File folderRecursive) {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (File file : folderRecursive.listFiles()) {
            if (file.isDirectory()) {
                listFiles.addAll(AutomatorCLI.detectRecursiveScenario((File)file));
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            listFiles.add(file);
        }
        return listFiles;
    }

    public void run(String[] args) {
        if (!isRunningCLI) {
            return;
        }
        File scenarioFile = null;
        File folderRecursive = null;
        RunParameters runParameters = new RunParameters();
        Integer overrideNumberOfExecution = null;
        ACTION action = null;
        String serverName = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-h".equals(args[i]) || "--help".equals(args[i])) {
                    AutomatorCLI.printUsage();
                    return;
                }
                if ("-s".equals(args[i]) || "--server".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : -c <ServerName>");
                    }
                    serverName = args[i + 1];
                    ++i;
                    continue;
                }
                if ("-e".equals(args[i]) || "--engine".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : -e <ConnectionUrlString>");
                    }
                    this.engineConfiguration = AutomatorCLI.decodeConfiguration((String)args[i + 1]);
                    ++i;
                    continue;
                }
                if ("-l".equals(args[i]) || "--level".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : -l <DEBUG|MONITORING|MAIN|NOTHING>");
                    }
                    runParameters.setLogLevel(RunParameters.LOGLEVEL.valueOf((String)args[i + 1]));
                    ++i;
                    continue;
                }
                if ("-n".equals(args[i]) || "--numberofexecution".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : n <numberofexecution>");
                    }
                    overrideNumberOfExecution = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if ("-d".equals(args[i]) || "--deploy".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : -d TRUE|FALSE");
                    }
                    runParameters.setDeploymentProcess("TRUE".equalsIgnoreCase(args[i + 1]));
                    ++i;
                    continue;
                }
                if ("-x".equals(args[i]) || "--execute".equals(args[i])) {
                    runParameters.setExecution(true);
                    continue;
                }
                if ("-v".equals(args[i]) || "--verification".equals(args[i])) {
                    runParameters.setVerification(true);
                    continue;
                }
                if ("-f".equals(args[i]) || "--fullreport".equals(args[i])) {
                    runParameters.setFullDetailsSynthesis(true);
                    continue;
                }
                if ("run".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : run <scenarioFile>");
                    }
                    action = ACTION.RUN;
                    scenarioFile = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                if ("recursive".equals(args[i])) {
                    if (args.length < i + 1) {
                        throw new Exception("Bad usage : recursive <folder>");
                    }
                    action = ACTION.RECURSIVE;
                    folderRecursive = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                AutomatorCLI.printUsage();
                throw new Exception("Bad usage : unknown parameters [" + args[i] + "]");
            }
            if (action == null) {
                throw new Exception("Bad usage : missing action (" + ACTION.RUN + ")");
            }
            if (!runParameters.isExecution() && !runParameters.isVerification()) {
                runParameters.setExecution(true);
            }
            ConfigurationBpmEngine.BpmnServerDefinition serverDefinition = null;
            if (serverName != null) {
                serverDefinition = this.engineConfiguration.getByServerName(serverName);
                if (serverDefinition == null) {
                    throw new Exception("Check configuration: name[" + serverName + "] does not exist in the list of servers in application.yaml file");
                }
            } else {
                List listServers = this.engineConfiguration.getListServers();
                ConfigurationBpmEngine.BpmnServerDefinition bpmnServerDefinition = serverDefinition = listServers.isEmpty() ? null : (ConfigurationBpmEngine.BpmnServerDefinition)listServers.get(0);
            }
            if (serverDefinition == null) {
                throw new Exception("Check configuration: configuration to access a Camunda server is missing in application.yaml");
            }
            long beginTime = System.currentTimeMillis();
            BpmnEngine bpmnEngine = this.automatorAPI.getBpmnEngine(this.engineConfiguration, serverDefinition);
            switch (1.$SwitchMap$org$camunda$automator$AutomatorCLI$ACTION[action.ordinal()]) {
                case 1: {
                    Scenario scenario = this.automatorAPI.loadFromFile(scenarioFile);
                    BpmnEngine bpmnEngineScenario = this.automatorAPI.getBpmnEngineFromScenario(scenario, this.engineConfiguration);
                    RunResult scenarioExecutionResult = this.automatorAPI.executeScenario(bpmnEngineScenario == null ? bpmnEngine : bpmnEngineScenario, runParameters, scenario);
                    logger.info(scenarioExecutionResult.getSynthesis(runParameters.isFullDetailsSynthesis()));
                    break;
                }
                case 2: {
                    List listScenario = AutomatorCLI.detectRecursiveScenario(folderRecursive);
                    for (File scenarioFileIndex : listScenario) {
                        Scenario scenario = this.automatorAPI.loadFromFile(scenarioFileIndex);
                        BpmnEngine bpmnEngineScenario = this.automatorAPI.getBpmnEngineFromScenario(scenario, this.engineConfiguration);
                        RunResult scenarioExecutionResult = this.automatorAPI.executeScenario(bpmnEngineScenario == null ? bpmnEngine : bpmnEngineScenario, runParameters, scenario);
                        logger.info(scenarioExecutionResult.getSynthesis(false));
                    }
                    break;
                }
            }
            logger.info("That's all folks! " + (System.currentTimeMillis() - beginTime) + " ms.");
        }
        catch (Exception e) {
            logger.error("Error during execution " + e);
        }
    }
}

