/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine;

import java.util.EnumMap;
import java.util.Map;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.BpmnEngineFactory;
import org.camunda.automator.bpmnengine.camunda7.BpmnEngineCamunda7;
import org.camunda.automator.bpmnengine.camunda8.BpmnEngineCamunda8;
import org.camunda.automator.bpmnengine.dummy.BpmnEngineDummy;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.engine.AutomatorException;

public class BpmnEngineFactory {
    private static final BpmnEngineFactory bpmnEngineFactory = new BpmnEngineFactory();
    Map<ConfigurationBpmEngine.CamundaEngine, BpmnEngine> cacheEngine = new EnumMap(ConfigurationBpmEngine.CamundaEngine.class);

    public static BpmnEngineFactory getInstance() {
        return bpmnEngineFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpmnEngine getEngineFromConfiguration(ConfigurationBpmEngine engineConfiguration, ConfigurationBpmEngine.BpmnServerDefinition serverDefinition) throws AutomatorException {
        BpmnEngine engine = (BpmnEngine)this.cacheEngine.get(serverDefinition.serverType);
        if (engine != null) {
            return engine;
        }
        BpmnEngineFactory bpmnEngineFactory = this;
        synchronized (bpmnEngineFactory) {
            engine = (BpmnEngine)this.cacheEngine.get(serverDefinition.serverType);
            if (engine != null) {
                return engine;
            }
            engine = switch (1.$SwitchMap$org$camunda$automator$configuration$ConfigurationBpmEngine$CamundaEngine[serverDefinition.serverType.ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> new BpmnEngineCamunda7(engineConfiguration, serverDefinition);
                case 2 -> new BpmnEngineCamunda8(engineConfiguration, serverDefinition);
                case 3 -> new BpmnEngineCamunda8(engineConfiguration, serverDefinition);
                case 4 -> new BpmnEngineDummy(engineConfiguration);
            };
            engine.init();
            engine.connection();
            this.cacheEngine.put(serverDefinition.serverType, engine);
        }
        return engine;
    }
}

