/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine.camunda8.refactoring;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RefactoredCommandWrapper
extends CommandWrapper {
    private final FinalCommandStep<Void> command;
    private final long deadline;
    private final String entityLogInfo;
    private final DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final int maxRetries = 20;
    private long currentRetryDelay = 50L;
    private int invocationCounter = 0;

    public RefactoredCommandWrapper(FinalCommandStep<Void> command, long deadline, String entityLogInfo, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy) {
        super(command, null, (CommandExceptionHandlingStrategy)commandExceptionHandlingStrategy);
        this.command = command;
        this.deadline = deadline;
        this.entityLogInfo = entityLogInfo;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
    }

    public void executeAsync() {
        ++this.invocationCounter;
        ZeebeFuture zeebeFuture = this.command.send();
        if (this.commandExceptionHandlingStrategy != null) {
            zeebeFuture.exceptionally(t -> {
                this.commandExceptionHandlingStrategy.handleCommandError((CommandWrapper)this, t);
                return null;
            });
        }
    }

    public Object executeSync() {
        ++this.invocationCounter;
        ZeebeFuture zeebeFutur = this.command.send();
        if (this.commandExceptionHandlingStrategy != null) {
            zeebeFutur.exceptionally(t -> {
                this.commandExceptionHandlingStrategy.handleCommandError((CommandWrapper)this, t);
                return null;
            });
        }
        return zeebeFutur.join();
    }

    public void increaseBackoffUsing(BackoffSupplier backoffSupplier) {
        this.currentRetryDelay = backoffSupplier.supplyRetryDelay(this.currentRetryDelay);
    }

    public void scheduleExecutionUsing(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.schedule(() -> this.executeAsync(), this.currentRetryDelay, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "{command=" + this.command.getClass() + ", entity=" + this.entityLogInfo + ", currentRetryDelay=" + this.currentRetryDelay + "}";
    }

    public boolean hasMoreRetries() {
        if (this.jobDeadlineExceeded()) {
            return false;
        }
        Objects.requireNonNull(this);
        return this.invocationCounter < 20;
    }

    public boolean jobDeadlineExceeded() {
        return Instant.now().getEpochSecond() > this.deadline;
    }
}

