/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.definition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioFlowControl;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioWarmingUp;
import org.camunda.automator.engine.AutomatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Scenario {
    static Logger logger = LoggerFactory.getLogger(Scenario.class);
    private final List<ScenarioExecution> executions = new ArrayList();
    private final List<ScenarioDeployment> deployments = new ArrayList();
    private final List<ScenarioStep> flows = new ArrayList();
    private ScenarioWarmingUp warmingUp;
    private ScenarioFlowControl flowControl;
    private String name;
    private String version;
    private String processName;
    private String processId;
    private String serverName;
    private String serverType;
    private String scenarioFile = null;

    public static Scenario createFromJson(String jsonContent) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        Scenario scnHead = (Scenario)gson.fromJson(jsonContent, Scenario.class);
        if (scnHead == null) {
            logger.error("Scenario: Can't build scenario from content [{}]", (Object)jsonContent);
            return null;
        }
        scnHead.afterUnSerialize();
        return scnHead;
    }

    public static Scenario createFromFile(File scenarioFile) throws AutomatorException {
        try {
            Scenario scenario = Scenario.createFromInputStream((InputStream)new FileInputStream(scenarioFile), (String)scenarioFile.getAbsolutePath());
            scenario.scenarioFile = scenarioFile.getAbsolutePath();
            return scenario;
        }
        catch (FileNotFoundException e) {
            throw new AutomatorException("Can't access file [" + scenarioFile.getAbsolutePath() + "] " + e.getMessage());
        }
        catch (AutomatorException e) {
            throw e;
        }
    }

    public static Scenario createFromInputStream(InputStream scenarioInput, String origin) throws AutomatorException {
        Scenario scenario;
        logger.info("Load Scenario [{}] from InputStream", (Object)origin);
        BufferedReader br = new BufferedReader(new InputStreamReader(scenarioInput));
        try {
            String st;
            StringBuilder jsonContent = new StringBuilder();
            while ((st = br.readLine()) != null) {
                jsonContent.append(st);
            }
            Scenario scnHead = Scenario.createFromJson((String)jsonContent.toString());
            if (scnHead == null) {
                throw new AutomatorException("Scenario: can't load from JSON [" + jsonContent + "] ");
            }
            scenario = scnHead;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("CreateScenarioFromInputString: origin[{}] error {} : {} ", new Object[]{origin, e.getMessage(), e.toString()});
                throw new AutomatorException("Can't load content from [" + origin + "] " + e.getMessage());
            }
        }
        br.close();
        return scenario;
    }

    public Scenario addExecution(ScenarioExecution scnExecution) {
        this.executions.add(scnExecution);
        return this;
    }

    public List<ScenarioExecution> getExecutions() {
        return this.executions;
    }

    public List<ScenarioStep> getFlows() {
        return this.flows;
    }

    public ScenarioWarmingUp getWarmingUp() {
        return this.warmingUp;
    }

    public ScenarioFlowControl getFlowControl() {
        return this.flowControl;
    }

    public List<ScenarioDeployment> getDeployments() {
        return this.deployments;
    }

    public String getName() {
        return this.name;
    }

    public Scenario setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Scenario setProcessId(String processId) {
        this.processId = processId;
        return this;
    }

    public File getScenarioFile() {
        try {
            return new File(this.scenarioFile);
        }
        catch (Exception e) {
            logger.error("Can't access file [{}] ", (Object)this.scenarioFile);
            return null;
        }
    }

    public String getServerName() {
        if (this.serverName == null || this.serverName.isEmpty()) {
            return null;
        }
        return this.serverName;
    }

    public ConfigurationBpmEngine.CamundaEngine getServerType() {
        try {
            return ConfigurationBpmEngine.CamundaEngine.valueOf((String)this.serverType.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    private void afterUnSerialize() {
        for (ScenarioExecution scnExecution : this.getExecutions()) {
            scnExecution.afterUnSerialize(this);
        }
    }
}

