/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioVerification;

public class ScenarioExecution {
    private final List<ScenarioStep> steps = new ArrayList();
    private Scenario scnHead;
    private ScenarioVerification verifications;
    private String name;
    private Integer numberProcessInstances;
    private Integer numberOfThreads;
    private Policy policy;
    private Boolean execution;

    protected ScenarioExecution(Scenario scenario) {
        this.scnHead = scenario;
    }

    public static ScenarioExecution createExecution(Scenario scnHead) {
        return new ScenarioExecution(scnHead);
    }

    public void afterUnSerialize(Scenario scnHead) {
        this.scnHead = scnHead;
        for (ScenarioStep scnStep : this.steps) {
            scnStep.afterUnSerialize(this);
        }
    }

    public ScenarioExecution addStep(ScenarioStep step) {
        this.steps.add(step);
        return this;
    }

    public List<ScenarioStep> getSteps() {
        return this.steps == null ? Collections.emptyList() : this.steps;
    }

    public ScenarioVerification getVerifications() {
        return this.verifications;
    }

    public int getNumberProcessInstances() {
        return this.numberProcessInstances == null ? 1 : this.numberProcessInstances;
    }

    public ScenarioExecution setNumberProcessInstances(int numberProcessInstances) {
        this.numberProcessInstances = numberProcessInstances;
        return this;
    }

    public Scenario getScnHead() {
        return this.scnHead;
    }

    public String getName() {
        return this.name;
    }

    public ScenarioExecution setName(String name) {
        this.name = name;
        return this;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads == null ? 1 : (this.numberOfThreads <= 0 ? 1 : this.numberOfThreads);
    }

    public Policy getPolicy() {
        return this.policy == null ? Policy.STOPATFIRSTERROR : this.policy;
    }

    public boolean isExecution() {
        return this.execution == null || Boolean.TRUE.equals(this.execution);
    }
}

