/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.util.ArrayList;
import java.util.List;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioWarmingUp;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.RunScenarioFlowServiceTask;
import org.camunda.automator.engine.flow.RunScenarioFlowUserTask;
import org.camunda.automator.engine.flow.RunScenarioWarmingUp;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioWarmingUp {
    private final ServiceAccess serviceAccess;
    private final RunScenario runScenario;
    Logger logger = LoggerFactory.getLogger(RunScenarioWarmingUp.class);

    RunScenarioWarmingUp(ServiceAccess serviceAccess, RunScenario runScenario) {
        this.serviceAccess = serviceAccess;
        this.runScenario = runScenario;
    }

    public void warmingUp(RunResult runResult) {
        ScenarioWarmingUp warmingUp = this.runScenario.getScenario().getWarmingUp();
        if (warmingUp == null) {
            this.logger.info("WarmingUp not present in scenario");
            return;
        }
        if (!this.runScenario.getRunParameters().isWarmingUp()) {
            this.logger.info("WarmingUp present, but not allowed to start");
            return;
        }
        long beginTime = System.currentTimeMillis();
        long endWarmingUp = beginTime + (warmingUp.getDuration().toMillis() > 0L ? warmingUp.getDuration().toMillis() : 600000L);
        ArrayList<RunScenarioFlowServiceTask> listWarmingUpServiceTask = new ArrayList<RunScenarioFlowServiceTask>();
        ArrayList<RunScenarioFlowUserTask> listWarmingUpUserTask = new ArrayList<RunScenarioFlowUserTask>();
        ArrayList<StartEventWarmingUpRunnable> listWarmingUpStartEvent = new ArrayList<StartEventWarmingUpRunnable>();
        List listOperationWarmingUp = warmingUp.getOperations();
        if (warmingUp.useServiceTasks) {
            listOperationWarmingUp.addAll(this.runScenario.getScenario().getFlows().stream().filter(t -> t.getType().equals((Object)ScenarioStep.Step.SERVICETASK)).toList());
        }
        if (warmingUp.useUserTasks) {
            listOperationWarmingUp.addAll(this.runScenario.getScenario().getFlows().stream().filter(t -> t.getType().equals((Object)ScenarioStep.Step.USERTASK)).toList());
        }
        this.logger.info("WarmingUp: Start ---- {} operations (useServiceTask {} useUserTask {}", new Object[]{listOperationWarmingUp.size(), warmingUp.useServiceTasks, warmingUp.useUserTasks});
        block7: for (ScenarioStep scenarioStep : listOperationWarmingUp) {
            switch (1.$SwitchMap$org$camunda$automator$definition$ScenarioStep$Step[scenarioStep.getType().ordinal()]) {
                case 1: {
                    this.logger.info("WarmingUp: StartEvent Generate [{}] Frequency [{}] EndWarmingUp [{}]", new Object[]{scenarioStep.getNumberOfExecutions(), scenarioStep.getFrequency(), scenarioStep.getEndWarmingUp()});
                    StartEventWarmingUpRunnable startEventWarmingUpRunnable = new StartEventWarmingUpRunnable(this, this.serviceAccess.getTaskScheduler("warmingUp"), scenarioStep, this.runScenario, runResult);
                    listWarmingUpStartEvent.add(startEventWarmingUpRunnable);
                    startEventWarmingUpRunnable.run();
                    continue block7;
                }
                case 2: {
                    this.logger.info("WarmingUp: Start Service Task topic[{}]", (Object)scenarioStep.getTopic());
                    RunScenarioFlowServiceTask task = new RunScenarioFlowServiceTask(this.serviceAccess.getTaskScheduler("serviceTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
                    task.execute();
                    listWarmingUpServiceTask.add(task);
                    continue block7;
                }
                case 3: {
                    this.logger.info("WarmingUp: Start User Task taskId[{}]", (Object)scenarioStep.getTaskId());
                    RunScenarioFlowUserTask userTask = new RunScenarioFlowUserTask(this.serviceAccess.getTaskScheduler("userTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
                    userTask.execute();
                    listWarmingUpUserTask.add(userTask);
                    continue block7;
                }
            }
            this.logger.info("WarmingUp: Unknown [{}]", (Object)scenarioStep.getType());
        }
        boolean warmingUpIsFinish = false;
        while (!warmingUpIsFinish) {
            long currentTime = System.currentTimeMillis();
            String analysis = "Limit warmupDuration in " + (endWarmingUp - currentTime) / 1000L + " s, ";
            if (currentTime >= endWarmingUp) {
                analysis = analysis + "OVER_MAXIMUM";
                warmingUpIsFinish = true;
            }
            boolean allIsFinished = true;
            for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
                analysis = analysis + "/ warmingUp[" + startRunnable.scenarioStep.getTaskId() + "] instanceCreated[" + startRunnable.nbInstancesCreated + "]";
                if (startRunnable.warmingUpFinished) {
                    analysis = analysis + " FINISH " + startRunnable.warmingUpFinishedAnalysis;
                    continue;
                }
                analysis = analysis + " NOT_FINISH " + startRunnable.warmingUpNotFinishedAnalysis;
                allIsFinished = false;
            }
            if (allIsFinished) {
                warmingUpIsFinish = true;
            }
            this.logger.info("WarmingUpFinished? {} analysis:[{}]", (Object)warmingUpIsFinish, (Object)analysis);
            if (warmingUpIsFinish) continue;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
            startRunnable.pleaseStop(true);
        }
        for (RunScenarioFlowServiceTask task : listWarmingUpServiceTask) {
            task.pleaseStop();
        }
        for (RunScenarioFlowUserTask userTask : listWarmingUpUserTask) {
            userTask.pleaseStop();
        }
        this.logger.info("WarmingUp: Complete ----");
    }
}

