/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.unit;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.unit.RunScenarioUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioUnit {
    private final Logger logger = LoggerFactory.getLogger(RunScenarioUnit.class);
    private final RunScenario runScenario;
    private final ScenarioExecution scnExecution;
    private String agentName = "";

    public RunScenarioUnit(RunScenario runScenario, ScenarioExecution scnExecution) {
        this.runScenario = runScenario;
        this.scnExecution = scnExecution;
    }

    public void setAgentName(String name) {
        this.agentName = name;
    }

    public RunResult runExecution() {
        RunResult resultExecution = new RunResult(this.runScenario);
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": Start Execution [" + this.scnExecution.getName() + "] ");
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.scnExecution.getNumberOfThreads());
        ArrayList listFutures = new ArrayList();
        for (int i = 0; i < this.scnExecution.getNumberProcessInstances(); ++i) {
            ScnThreadExecutionCallable scnThreadExecutionCallable = new ScnThreadExecutionCallable(this, "AutomatorThread-" + i, this, this.runScenario.getRunParameters());
            listFutures.add(executor.submit(scnThreadExecutionCallable));
        }
        try {
            for (Future future : listFutures) {
                Object scnRunResult = future.get();
                resultExecution.add((RunResult)scnRunResult);
            }
        }
        catch (Exception e) {
            resultExecution.addError(null, "Error during executing in parallel " + e.getMessage());
        }
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": End Execution [" + this.scnExecution.getName() + "] success? " + resultExecution.isSuccess());
        }
        return resultExecution;
    }
}

