/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services;

import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.camunda.automator.AutomatorAPI;
import org.camunda.automator.AutomatorCLI;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.configuration.ConfigurationStartup;
import org.camunda.automator.services.AutomatorStartup;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AutomatorStartup {
    static Logger logger = LoggerFactory.getLogger(AutomatorStartup.class);
    @Autowired
    ConfigurationStartup configurationStartup;
    @Autowired
    AutomatorAPI automatorAPI;
    @Autowired
    AutomatorCLI automatorCLI;
    @Autowired
    ConfigurationBpmEngine engineConfiguration;
    @Autowired
    ServiceAccess serviceAccess;

    @PostConstruct
    public void init() {
        if (AutomatorCLI.isRunningCLI) {
            return;
        }
        AutomatorSetupRunnable automatorSetupRunnable = new AutomatorSetupRunnable(this, this.configurationStartup, this.automatorAPI, this.automatorCLI, this.engineConfiguration);
        this.serviceAccess.getTaskScheduler("AutomatorSetup").schedule((Runnable)automatorSetupRunnable, Instant.now());
    }

    private void runFixedWarmup() {
        if (this.configurationStartup.getWarmingUpServer().getSeconds() > 30L) {
            logger.info("WarmupFixedTime: wait.... {} s", (Object)this.configurationStartup.getWarmingUpServer().getSeconds());
            try {
                Thread.sleep(this.configurationStartup.getWarmingUpServer().toMillis());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("WarmupFixedTime: end");
        }
    }

    private List<Object> registerScenario() {
        ArrayList<Object> scenarioList = new ArrayList<Object>();
        if (this.configurationStartup.getScenarioFileAtStartup().isEmpty()) {
            logger.info("No scenario [File] from variable {} given", (Object)this.configurationStartup.getScenarioFileAtStartupName());
        } else {
            logger.info("Detect {} scenario [File] from variable {}", (Object)this.configurationStartup.getScenarioFileAtStartup().size(), (Object)this.configurationStartup.getScenarioFileAtStartupName());
            for (String scenarioFileName : this.configurationStartup.getScenarioFileAtStartup()) {
                logger.info("Register scenario [File] [{}]", (Object)scenarioFileName);
                File scenarioFile = new File(this.configurationStartup.scenarioPath + "/" + scenarioFileName);
                if (!scenarioFile.exists()) {
                    logger.error("ScenarioFile: Can't find [{}/{}]", (Object)this.configurationStartup.scenarioPath, (Object)scenarioFileName);
                    continue;
                }
                scenarioList.add(scenarioFile);
            }
        }
        if (this.configurationStartup.getScenarioResourceAtStartup().isEmpty()) {
            logger.info("No scenario [Resource] from variable {} given", (Object)this.configurationStartup.getScenarioResourceAtStartupName());
        } else {
            logger.info("Detect {} scenario [Resource] from variable {}", (Object)this.configurationStartup.getScenarioResourceAtStartup().size(), (Object)this.configurationStartup.getScenarioResourceAtStartupName());
            for (Resource resource : this.configurationStartup.getScenarioResourceAtStartup()) {
                logger.info("Load scenario [Resource] from [{}]", (Object)resource.getDescription());
                scenarioList.add(resource);
            }
        }
        return scenarioList;
    }
}

