/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services.dataoperation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunScenario;

public abstract class DataOperation {
    public abstract boolean match(String var1);

    public abstract Object execute(String var1, RunScenario var2) throws AutomatorException;

    protected boolean matchFunction(String value, String function) {
        return value.toUpperCase(Locale.ROOT).startsWith(function.toUpperCase(Locale.ROOT) + "(");
    }

    protected List<String> extractArgument(String value, boolean resolveValue) throws AutomatorException {
        List<String> listResult = new ArrayList<String>();
        int pos = (value = value.trim()).indexOf("(");
        if (pos == -1 || !value.endsWith(")")) {
            throw new AutomatorException("Format must be function(args), received [" + value + "]");
        }
        String args = value.substring(pos);
        args = args.substring(1, args.length() - 1);
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            listResult.add(st.nextToken());
        }
        if (resolveValue) {
            listResult = listResult.stream().map(t -> {
                if (t.startsWith("\"") || t.startsWith("'")) {
                    return t.substring(1, t.length() - 1);
                }
                return t;
            }).collect(Collectors.toList());
        }
        return listResult;
    }

    public abstract String getHelp();
}

