/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine;

import io.camunda.operate.search.DateFilter;
import io.camunda.zeebe.client.api.worker.JobWorker;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.flow.FixedBackoffSupplier;
import org.camunda.bpm.client.topic.TopicSubscription;

public interface BpmnEngine {
    public void init();

    public void connection() throws AutomatorException;

    public void disconnection() throws AutomatorException;

    public boolean isReady();

    public void turnHighFlowMode(boolean var1);

    public String createProcessInstance(String var1, String var2, Map<String, Object> var3) throws AutomatorException;

    public void endProcessInstance(String var1, boolean var2) throws AutomatorException;

    public List<String> searchUserTasksByProcessInstance(String var1, String var2, int var3) throws AutomatorException;

    public List<String> searchUserTasks(String var1, int var2) throws AutomatorException;

    public void executeUserTask(String var1, String var2, Map<String, Object> var3) throws AutomatorException;

    public RegisteredTask registerServiceTask(String var1, String var2, Duration var3, Object var4, FixedBackoffSupplier var5);

    public List<String> searchServiceTasks(String var1, String var2, String var3, int var4) throws AutomatorException;

    public void executeServiceTask(String var1, String var2, Map<String, Object> var3) throws AutomatorException;

    public List<TaskDescription> searchTasksByProcessInstanceId(String var1, String var2, int var3) throws AutomatorException;

    public List<ProcessDescription> searchProcessInstanceByVariable(String var1, Map<String, Object> var2, int var3) throws AutomatorException;

    public Map<String, Object> getVariables(String var1) throws AutomatorException;

    public long countNumberOfProcessInstancesCreated(String var1, DateFilter var2, DateFilter var3) throws AutomatorException;

    public long countNumberOfProcessInstancesEnded(String var1, DateFilter var2, DateFilter var3) throws AutomatorException;

    public long countNumberOfTasks(String var1, String var2) throws AutomatorException;

    public String deployBpmn(File var1, ScenarioDeployment.Policy var2) throws AutomatorException;

    public ConfigurationBpmEngine.CamundaEngine getTypeCamundaEngine();

    public String getSignature();

    public int getWorkerExecutionThreads();

    public static class ProcessDescription {
        public String processInstanceId;
    }

    public static class TaskDescription {
        public String processInstanceId;
        public String taskId;
        public ScenarioStep.Step type;
        public boolean isCompleted;
    }

    public static class RegisteredTask {
        public TopicSubscription topicSubscription;
        public JobWorker jobWorker;

        public boolean isNull() {
            return this.topicSubscription == null && this.jobWorker == null;
        }

        public boolean isClosed() {
            if (this.jobWorker != null) {
                return this.jobWorker.isClosed();
            }
            return this.topicSubscription == null;
        }

        public void close() {
            if (this.jobWorker != null) {
                this.jobWorker.close();
            }
            if (this.topicSubscription != null) {
                this.topicSubscription.close();
                this.topicSubscription = null;
            }
        }
    }
}

