/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine.camunda8;

import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.Executors;
import org.camunda.automator.bpmnengine.camunda8.StatisticsCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class BenchmarkCompleteJobExceptionHandlingStrategy
extends DefaultCommandExceptionHandlingStrategy {
    @Autowired
    private StatisticsCollector stats;

    public BenchmarkCompleteJobExceptionHandlingStrategy(@Autowired BackoffSupplier backoffSupplier) {
        super(backoffSupplier, Executors.newScheduledThreadPool(1));
    }

    public void handleCommandError(CommandWrapper command, Throwable throwable) {
        if (StatusRuntimeException.class.isAssignableFrom(throwable.getClass())) {
            StatusRuntimeException exception = (StatusRuntimeException)throwable;
            this.stats.incCompletedJobsException(exception.getStatus().getCode().name());
        } else {
            this.stats.incCompletedJobsException(throwable.getMessage());
        }
        super.handleCommandError(command, throwable);
    }
}

