/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.bpmnengine.camunda8;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.auth.SaasAuthentication;
import io.camunda.operate.dto.FlownodeInstanceState;
import io.camunda.operate.dto.ProcessInstance;
import io.camunda.operate.dto.ProcessInstanceState;
import io.camunda.operate.dto.SearchResult;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.search.DateFilter;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.FlownodeInstanceFilter;
import io.camunda.operate.search.ProcessInstanceFilter;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.search.Sort;
import io.camunda.operate.search.SortOrder;
import io.camunda.operate.search.VariableFilter;
import io.camunda.tasklist.CamundaTaskListClient;
import io.camunda.tasklist.auth.AuthInterface;
import io.camunda.tasklist.auth.SimpleAuthentication;
import io.camunda.tasklist.dto.Pagination;
import io.camunda.tasklist.dto.Task;
import io.camunda.tasklist.dto.TaskList;
import io.camunda.tasklist.dto.TaskSearch;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.dto.Variable;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.camunda8.BenchmarkStartPiExceptionHandlingStrategy;
import org.camunda.automator.bpmnengine.camunda8.refactoring.RefactoredCommandWrapper;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.definition.ScenarioDeployment;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.flow.FixedBackoffSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BpmnEngineCamunda8
implements BpmnEngine {
    public static final String THIS_IS_A_COMPLETE_IMPOSSIBLE_VARIABLE_NAME = "ThisIsACompleteImpossibleVariableName";
    public static final int SEARCH_MAX_SIZE = 100;
    private final Logger logger = LoggerFactory.getLogger(BpmnEngineCamunda8.class);
    private final ConfigurationBpmEngine.BpmnServerDefinition serverDefinition;
    boolean hightFlowMode = false;
    Map<String, Long> cacheProcessInstanceMarker = new HashMap<String, Long>();
    Random random = new Random(System.currentTimeMillis());
    private ZeebeClient zeebeClient;
    private CamundaOperateClient operateClient;
    private CamundaTaskListClient taskClient;
    @Autowired
    private BenchmarkStartPiExceptionHandlingStrategy exceptionHandlingStrategy;
    private ConfigurationBpmEngine.CamundaEngine typeCamundaEngine = ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8;

    public BpmnEngineCamunda8(ConfigurationBpmEngine engineConfiguration, ConfigurationBpmEngine.BpmnServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
    }

    public BpmnEngineCamunda8(String zeebeSelfGatewayAddress, String zeebeSelfSecurityPlainText, String zeebeSaasCloudRegister, String zeebeSaasCloudRegion, String zeebeSaasCloudClusterId, String zeebeSaasCloudClientId, String zeebeSaasClientSecret, String operateUrl, String operateUserName, String operateUserPassword, String tasklistUrl) {
        this.serverDefinition = new ConfigurationBpmEngine.BpmnServerDefinition();
        this.serverDefinition.zeebeGatewayAddress = zeebeSelfGatewayAddress;
        this.serverDefinition.zeebeSecurityPlainText = zeebeSelfSecurityPlainText;
        this.serverDefinition.zeebeCloudRegister = zeebeSaasCloudRegister;
        this.serverDefinition.zeebeCloudRegion = zeebeSaasCloudRegion;
        this.serverDefinition.zeebeCloudClusterId = zeebeSaasCloudClusterId;
        this.serverDefinition.zeebeCloudClientId = zeebeSaasCloudClientId;
        this.serverDefinition.clientSecret = zeebeSaasClientSecret;
        this.serverDefinition.operateUserName = operateUserName;
        this.serverDefinition.operateUserPassword = operateUserPassword;
        this.serverDefinition.operateUrl = operateUrl;
        this.serverDefinition.taskListUrl = tasklistUrl;
    }

    @Override
    public void init() {
    }

    @Override
    public void connection() throws AutomatorException {
        io.camunda.tasklist.auth.SaasAuthentication saTaskList;
        SaasAuthentication saOperate;
        ZeebeClientBuilder clientBuilder;
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        StringBuilder analysis = new StringBuilder();
        analysis.append("ZeebeConnection: ");
        this.typeCamundaEngine = ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8;
        if (this.serverDefinition.zeebeCloudRegister != null && !this.serverDefinition.zeebeCloudRegister.trim().isEmpty()) {
            this.typeCamundaEngine = ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8_SAAS;
        }
        if (this.serverDefinition.zeebeCloudRegister != null && !this.serverDefinition.zeebeCloudRegister.trim().isEmpty()) {
            analysis.append("Saas ClientId[");
            analysis.append(this.serverDefinition.zeebeCloudClientId);
            analysis.append("]");
            clientBuilder = ZeebeClient.newClientBuilder();
            saOperate = new SaasAuthentication(this.serverDefinition.zeebeCloudClientId, this.serverDefinition.clientSecret);
            saTaskList = new io.camunda.tasklist.auth.SaasAuthentication(this.serverDefinition.zeebeCloudClientId, this.serverDefinition.clientSecret);
            this.typeCamundaEngine = ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8_SAAS;
        } else if (this.serverDefinition.zeebeGatewayAddress != null && !this.serverDefinition.zeebeGatewayAddress.trim().isEmpty()) {
            analysis.append("GatewayAddress [");
            analysis.append(this.serverDefinition.zeebeGatewayAddress);
            analysis.append("]");
            clientBuilder = ZeebeClient.newClientBuilder().gatewayAddress(this.serverDefinition.zeebeGatewayAddress).usePlaintext();
            saOperate = new io.camunda.operate.auth.SimpleAuthentication(this.serverDefinition.operateUserName, this.serverDefinition.operateUserPassword, this.serverDefinition.operateUrl);
            saTaskList = new SimpleAuthentication(this.serverDefinition.operateUserName, this.serverDefinition.operateUserPassword);
            this.typeCamundaEngine = ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8;
        } else {
            throw new AutomatorException("Invalid configuration");
        }
        try {
            analysis.append("ExecutionThread[");
            analysis.append(this.serverDefinition.workerExecutionThreads);
            analysis.append("] MaxJobsActive[");
            analysis.append(this.serverDefinition.workerMaxJobsActive);
            analysis.append("] ");
            if (this.serverDefinition.workerMaxJobsActive == -1) {
                this.serverDefinition.workerMaxJobsActive = this.serverDefinition.workerExecutionThreads;
                analysis.append("No MaxJobsActive defined, align to the number of threads, ");
            }
            if (this.serverDefinition.workerExecutionThreads > this.serverDefinition.workerMaxJobsActive) {
                this.logger.error("Camunda8 [{}] Incorrect definition: the number of threads {} must be <= number Jobs Active {} , else ZeebeClient will not fetch enough jobs to feed threads", new Object[]{this.serverDefinition.name, this.serverDefinition.workerExecutionThreads, this.serverDefinition.workerMaxJobsActive});
            }
            clientBuilder.numJobWorkerExecutionThreads(this.serverDefinition.workerExecutionThreads.intValue());
            clientBuilder.defaultJobWorkerMaxJobsActive(this.serverDefinition.workerMaxJobsActive.intValue());
            this.zeebeClient = clientBuilder.build();
            analysis.append("Zeebe connection with success,");
            this.operateClient = new CamundaOperateClient.Builder().operateUrl(this.serverDefinition.operateUrl).authentication((io.camunda.operate.auth.AuthInterface)saOperate).build();
            analysis.append("OperateConnection with success,");
            if (this.serverDefinition.taskListUrl != null && !this.serverDefinition.taskListUrl.isEmpty()) {
                this.taskClient = new CamundaTaskListClient.Builder().taskListUrl(this.serverDefinition.taskListUrl).authentication((AuthInterface)saTaskList).build();
                analysis.append("TasklistConnection with success,");
            }
            this.logger.info(analysis.toString());
        }
        catch (Exception e) {
            this.zeebeClient = null;
            throw new AutomatorException("Can't connect to Zeebe/operate/tasklist " + e.getMessage() + " - Analysis:" + analysis);
        }
    }

    @Override
    public void disconnection() throws AutomatorException {
    }

    @Override
    public boolean isReady() {
        return this.zeebeClient != null;
    }

    @Override
    public void turnHighFlowMode(boolean hightFlowMode) {
        this.hightFlowMode = hightFlowMode;
    }

    @Override
    public String createProcessInstance(String processId, String starterEventId, Map<String, Object> variables) throws AutomatorException {
        try {
            String marker = null;
            if (!this.hightFlowMode) {
                marker = this.getUniqueMarker(processId, starterEventId);
                variables.put(THIS_IS_A_COMPLETE_IMPOSSIBLE_VARIABLE_NAME, marker);
            }
            CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createCommand = this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables);
            RefactoredCommandWrapper command = new RefactoredCommandWrapper((FinalCommandStep<Void>)createCommand, System.currentTimeMillis() + 300000L, "CreatePi" + processId, this.exceptionHandlingStrategy);
            ProcessInstanceEvent workflowInstanceEvent = (ProcessInstanceEvent)command.executeSync();
            Long processInstanceId = workflowInstanceEvent.getProcessInstanceKey();
            if (!this.hightFlowMode) {
                this.cacheProcessInstanceMarker.put(marker, processInstanceId);
            }
            return String.valueOf(processInstanceId);
        }
        catch (Exception e) {
            throw new AutomatorException("Can't create in process [" + processId + "] :" + e.getMessage());
        }
    }

    public String createProcessInstanceSimple(String processId, String starterEventId, Map<String, Object> variables) throws AutomatorException {
        try {
            String marker = null;
            if (!this.hightFlowMode) {
                marker = this.getUniqueMarker(processId, starterEventId);
                variables.put(THIS_IS_A_COMPLETE_IMPOSSIBLE_VARIABLE_NAME, marker);
            }
            ProcessInstanceEvent workflowInstanceEvent = (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).send().join();
            Long processInstanceId = workflowInstanceEvent.getProcessInstanceKey();
            if (!this.hightFlowMode) {
                this.cacheProcessInstanceMarker.put(marker, processInstanceId);
            }
            return String.valueOf(processInstanceId);
        }
        catch (Exception e) {
            throw new AutomatorException("Can't create in process [" + processId + "] :" + e.getMessage());
        }
    }

    @Override
    public void endProcessInstance(String processInstanceId, boolean cleanAll) throws AutomatorException {
        List<String> markers = this.cacheProcessInstanceMarker.entrySet().stream().filter(t -> ((Long)t.getValue()).equals(Long.valueOf(processInstanceId))).map(Map.Entry::getKey).toList();
        markers.forEach(t -> this.cacheProcessInstanceMarker.remove(t));
    }

    @Override
    public List<String> searchUserTasksByProcessInstance(String processInstanceId, String userTaskId, int maxResult) throws AutomatorException {
        try {
            Long processInstanceIdLong = Long.valueOf(processInstanceId);
            TaskSearch taskSearch = new TaskSearch();
            taskSearch.setState(TaskState.CREATED);
            taskSearch.setAssigned(Boolean.FALSE);
            taskSearch.setWithVariables(true);
            taskSearch.setPagination(new Pagination().setPageSize(Integer.valueOf(maxResult)));
            TaskList tasksList = this.taskClient.getTasks(taskSearch);
            ArrayList<String> listTasksResult = new ArrayList<String>();
            do {
                listTasksResult.addAll(tasksList.getItems().stream().filter(t -> {
                    List listVariables = t.getVariables();
                    Optional<Variable> markerTask = listVariables.stream().filter(v -> v.getName().equals(THIS_IS_A_COMPLETE_IMPOSSIBLE_VARIABLE_NAME)).findFirst();
                    if (markerTask.isEmpty()) {
                        return false;
                    }
                    Long processInstanceIdTask = this.cacheProcessInstanceMarker.get(markerTask.get().getValue());
                    return processInstanceIdLong.equals(processInstanceIdTask);
                }).map(Task::getId).toList());
                if (tasksList.size() <= 0) continue;
                tasksList = this.taskClient.after(tasksList);
            } while (tasksList.size() > 0);
            return listTasksResult;
        }
        catch (TaskListException e) {
            throw new AutomatorException("Can't search users task " + e.getMessage());
        }
    }

    @Override
    public List<String> searchUserTasks(String userTaskId, int maxResult) throws AutomatorException {
        try {
            TaskSearch taskSearch = new TaskSearch();
            taskSearch.setState(TaskState.CREATED);
            taskSearch.setAssigned(Boolean.FALSE);
            taskSearch.setWithVariables(true);
            taskSearch.setPagination(new Pagination().setPageSize(Integer.valueOf(maxResult)));
            TaskList tasksList = this.taskClient.getTasks(taskSearch);
            ArrayList<String> listTasksResult = new ArrayList<String>();
            do {
                listTasksResult.addAll(tasksList.getItems().stream().map(Task::getId).toList());
                if (tasksList.size() <= 0) continue;
                tasksList = this.taskClient.after(tasksList);
            } while (tasksList.size() > 0);
            return listTasksResult;
        }
        catch (TaskListException e) {
            throw new AutomatorException("Can't search users task " + e.getMessage());
        }
    }

    @Override
    public BpmnEngine.RegisteredTask registerServiceTask(String workerId, String topic, Duration lockTime, Object jobHandler, FixedBackoffSupplier backoffSupplier) {
        if (!(jobHandler instanceof JobHandler)) {
            this.logger.error("handler is not a JobHandler implementation, can't register the worker [{}], topic [{}]", (Object)workerId, (Object)topic);
            return null;
        }
        if (topic == null) {
            this.logger.error("topic must not be null, can't register the worker [{}]", (Object)workerId);
            return null;
        }
        BpmnEngine.RegisteredTask registeredTask = new BpmnEngine.RegisteredTask();
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 step3 = this.zeebeClient.newWorker().jobType(topic).handler((JobHandler)jobHandler).timeout(lockTime).name(workerId);
        if (backoffSupplier != null) {
            step3.backoffSupplier((BackoffSupplier)backoffSupplier);
        }
        registeredTask.jobWorker = step3.open();
        return registeredTask;
    }

    @Override
    public void executeUserTask(String userTaskId, String userId, Map<String, Object> variables) throws AutomatorException {
        try {
            this.taskClient.claim(userTaskId, this.serverDefinition.operateUserName);
            this.taskClient.completeTask(userTaskId, variables);
        }
        catch (TaskListException e) {
            throw new AutomatorException("Can't execute task [" + userTaskId + "]");
        }
    }

    @Override
    public List<String> searchServiceTasks(String processInstanceId, String serviceTaskId, String topic, int maxResult) throws AutomatorException {
        try {
            long processInstanceIdLong = Long.parseLong(processInstanceId);
            ActivateJobsResponse jobsResponse = (ActivateJobsResponse)this.zeebeClient.newActivateJobsCommand().jobType(topic).maxJobsToActivate(10000).workerName(Thread.currentThread().getName()).send().join();
            ArrayList<String> listJobsId = new ArrayList<String>();
            for (ActivatedJob job : jobsResponse.getJobs()) {
                if (job.getProcessInstanceKey() == processInstanceIdLong) {
                    listJobsId.add(String.valueOf(job.getKey()));
                    continue;
                }
                this.zeebeClient.newFailCommand(job.getKey()).retries(2).send().join();
            }
            return listJobsId;
        }
        catch (Exception e) {
            throw new AutomatorException("Can't search users task " + e.getMessage());
        }
    }

    @Override
    public void executeServiceTask(String serviceTaskId, String workerId, Map<String, Object> variables) throws AutomatorException {
        try {
            this.zeebeClient.newCompleteCommand(Long.valueOf(serviceTaskId).longValue()).send().join();
        }
        catch (Exception e) {
            throw new AutomatorException("Can't execute service task " + e.getMessage());
        }
    }

    @Override
    public List<BpmnEngine.TaskDescription> searchTasksByProcessInstanceId(String processInstanceId, String taskId, int maxResult) throws AutomatorException {
        try {
            FlownodeInstanceFilter flownodeFilter = new FlownodeInstanceFilter.Builder().processInstanceKey(Long.valueOf(processInstanceId)).build();
            SearchQuery flownodeQuery = new SearchQuery.Builder().filter((Filter)flownodeFilter).size(Integer.valueOf(maxResult)).build();
            List flownodes = this.operateClient.searchFlownodeInstances(flownodeQuery);
            return flownodes.stream().filter(t -> taskId.equals(t.getFlowNodeId())).map(t -> {
                BpmnEngine.TaskDescription taskDescription = new BpmnEngine.TaskDescription();
                taskDescription.taskId = t.getFlowNodeId();
                taskDescription.type = this.getTaskType(t.getType());
                taskDescription.isCompleted = FlownodeInstanceState.COMPLETED.equals((Object)t.getState());
                return taskDescription;
            }).toList();
        }
        catch (OperateException e) {
            throw new AutomatorException("Can't search users task " + e.getMessage());
        }
    }

    @Override
    public List<BpmnEngine.ProcessDescription> searchProcessInstanceByVariable(String processId, Map<String, Object> filterVariables, int maxResult) throws AutomatorException {
        try {
            ProcessInstanceFilter processInstanceFilter = new ProcessInstanceFilter.Builder().bpmnProcessId(processId).build();
            SearchQuery processInstanceQuery = new SearchQuery.Builder().filter((Filter)processInstanceFilter).size(Integer.valueOf(maxResult)).build();
            List listProcessInstances = this.operateClient.searchProcessInstances(processInstanceQuery);
            ArrayList<BpmnEngine.ProcessDescription> listProcessInstanceFind = new ArrayList<BpmnEngine.ProcessDescription>();
            for (ProcessInstance processInstance : listProcessInstances) {
                Map<String, Object> processVariables = this.getVariables(processInstance.getKey().toString());
                List<Map.Entry> entriesNotFiltered = filterVariables.entrySet().stream().filter(t -> processVariables.containsKey(t.getKey()) && processVariables.get(t.getKey()).equals(t.getValue())).toList();
                if (!entriesNotFiltered.isEmpty()) continue;
                BpmnEngine.ProcessDescription processDescription = new BpmnEngine.ProcessDescription();
                processDescription.processInstanceId = processInstance.getKey().toString();
                listProcessInstanceFind.add(processDescription);
            }
            return listProcessInstanceFind;
        }
        catch (OperateException e) {
            throw new AutomatorException("Can't search users task " + e.getMessage());
        }
    }

    private ScenarioStep.Step getTaskType(String taskTypeC8) {
        if (taskTypeC8.equals("SERVICE_TASK")) {
            return ScenarioStep.Step.SERVICETASK;
        }
        if (taskTypeC8.equals("USER_TASK")) {
            return ScenarioStep.Step.USERTASK;
        }
        if (taskTypeC8.equals("START_EVENT")) {
            return ScenarioStep.Step.STARTEVENT;
        }
        if (taskTypeC8.equals("END_EVENT")) {
            return ScenarioStep.Step.ENDEVENT;
        }
        if (taskTypeC8.equals("EXCLUSIVE_GATEWAY")) {
            return ScenarioStep.Step.EXCLUSIVEGATEWAY;
        }
        if (taskTypeC8.equals("PARALLEL_GATEWAY")) {
            return ScenarioStep.Step.PARALLELGATEWAY;
        }
        return null;
    }

    @Override
    public Map<String, Object> getVariables(String processInstanceId) throws AutomatorException {
        try {
            VariableFilter variableFilter = new VariableFilter.Builder().processInstanceKey(Long.valueOf(processInstanceId)).build();
            SearchQuery variableQuery = new SearchQuery.Builder().filter((Filter)variableFilter).build();
            List listVariables = this.operateClient.searchVariables(variableQuery);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            listVariables.forEach(t -> variables.put(t.getName(), t.getValue()));
            return variables;
        }
        catch (OperateException e) {
            throw new AutomatorException("Can't search variables task " + e.getMessage());
        }
    }

    @Override
    public long countNumberOfProcessInstancesCreated(String processId, DateFilter startDate, DateFilter endDate) throws AutomatorException {
        SearchQuery.Builder queryBuilder = new SearchQuery.Builder();
        try {
            int cumul = 0;
            SearchResult searchResult = null;
            queryBuilder = queryBuilder.filter((Filter)new ProcessInstanceFilter.Builder().bpmnProcessId(processId).build());
            queryBuilder.sort(new Sort("key", SortOrder.ASC));
            int maxLoop = 0;
            do {
                ++maxLoop;
                if (searchResult != null && !searchResult.getItems().isEmpty()) {
                    queryBuilder.searchAfter(searchResult.getSortValues());
                }
                SearchQuery searchQuery = queryBuilder.build();
                searchQuery.setSize(Integer.valueOf(100));
                searchResult = this.operateClient.searchProcessInstanceResults(searchQuery);
                cumul = (int)((long)cumul + searchResult.getItems().stream().filter(t -> t.getStartDate().after(startDate.getDate())).count());
            } while (searchResult.getItems().size() >= 100 && maxLoop < 1000);
            return cumul;
        }
        catch (Exception e) {
            throw new AutomatorException("Search countNumberProcessInstanceCreated " + e.getMessage());
        }
    }

    @Override
    public long countNumberOfProcessInstancesEnded(String processId, DateFilter startDate, DateFilter endDate) throws AutomatorException {
        SearchQuery.Builder queryBuilder = new SearchQuery.Builder();
        try {
            int cumul = 0;
            SearchResult searchResult = null;
            queryBuilder = queryBuilder.filter((Filter)new ProcessInstanceFilter.Builder().bpmnProcessId(processId).state(ProcessInstanceState.COMPLETED).build());
            queryBuilder.sort(new Sort("key", SortOrder.ASC));
            int maxLoop = 0;
            do {
                ++maxLoop;
                if (searchResult != null && !searchResult.getItems().isEmpty()) {
                    queryBuilder.searchAfter(searchResult.getSortValues());
                }
                SearchQuery searchQuery = queryBuilder.build();
                searchQuery.setSize(Integer.valueOf(100));
                searchResult = this.operateClient.searchProcessInstanceResults(searchQuery);
                cumul = (int)((long)cumul + searchResult.getItems().stream().filter(t -> t.getStartDate().after(startDate.getDate())).count());
            } while (searchResult.getItems().size() >= 100 && maxLoop < 1000);
            return cumul;
        }
        catch (Exception e) {
            throw new AutomatorException("Search countNumberProcessEnded " + e.getMessage());
        }
    }

    @Override
    public long countNumberOfTasks(String processId, String taskId) throws AutomatorException {
        try {
            int cumul = 0;
            SearchResult searchResult = null;
            int maxLoop = 0;
            do {
                ++maxLoop;
                SearchQuery.Builder queryBuilder = new SearchQuery.Builder();
                queryBuilder = queryBuilder.filter((Filter)new FlownodeInstanceFilter.Builder().flowNodeId(taskId).build());
                queryBuilder.sort(new Sort("key", SortOrder.ASC));
                if (searchResult != null && !searchResult.getItems().isEmpty()) {
                    queryBuilder.searchAfter(searchResult.getSortValues());
                }
                SearchQuery searchQuery = queryBuilder.build();
                searchQuery.setSize(Integer.valueOf(100));
                searchResult = this.operateClient.searchFlownodeInstanceResults(searchQuery);
                cumul = (int)((long)cumul + (long)searchResult.getItems().size());
            } while (searchResult.getItems().size() >= 100 && maxLoop < 1000);
            return cumul;
        }
        catch (Exception e) {
            throw new AutomatorException("Search countNumberProcessEnded " + e.getMessage());
        }
    }

    @Override
    public String deployBpmn(File processFile, ScenarioDeployment.Policy policy) throws AutomatorException {
        try {
            DeploymentEvent event = (DeploymentEvent)this.zeebeClient.newDeployResourceCommand().addResourceFile(processFile.getAbsolutePath()).send().join();
            return String.valueOf(event.getKey());
        }
        catch (Exception e) {
            throw new AutomatorException("Can't deploy " + e.getMessage());
        }
    }

    @Override
    public ConfigurationBpmEngine.CamundaEngine getTypeCamundaEngine() {
        return this.typeCamundaEngine;
    }

    @Override
    public String getSignature() {
        String signature = this.typeCamundaEngine.toString() + " ";
        signature = this.typeCamundaEngine.equals((Object)ConfigurationBpmEngine.CamundaEngine.CAMUNDA_8_SAAS) ? signature + "Cloud[" + this.serverDefinition.zeebeCloudRegister + "] ClientId[" + this.serverDefinition.zeebeCloudClientId + "] ClusterId[" + this.serverDefinition.zeebeCloudClusterId + "]" : signature + "Address[" + this.serverDefinition.zeebeGatewayAddress + "]";
        signature = signature + " numJobWorkerExecutionThreads[" + this.serverDefinition.workerExecutionThreads + "] workerMaxJobsActive[" + this.serverDefinition.workerMaxJobsActive + "]";
        return signature;
    }

    @Override
    public int getWorkerExecutionThreads() {
        return this.serverDefinition != null ? this.serverDefinition.workerExecutionThreads : 0;
    }

    private String getUniqueMarker(String processId, String starterEventId) {
        return processId + "-" + this.random.nextInt(1000000);
    }

    public ZeebeClient getZeebeClient() {
        return this.zeebeClient;
    }
}

