/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.util.Collections;
import java.util.List;

public class RunParameters {
    private LOGLEVEL logLevel = LOGLEVEL.MONITORING;
    private int numberOfThreadsPerScenario = 10;
    private boolean execution = false;
    private boolean creation = true;
    private boolean servicetask = true;
    private boolean usertask = true;
    private boolean verification = false;
    private boolean clearAllAfter = false;
    private boolean deploymentProcess = true;
    private boolean fullDetailsSynthesis = false;
    private List<String> filterServiceTask = Collections.emptyList();
    private boolean deepTracking = true;
    private String scenarioPath;
    private boolean warmingUp = true;

    public LOGLEVEL getLogLevel() {
        return this.logLevel;
    }

    public RunParameters setLogLevel(LOGLEVEL logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public boolean isExecution() {
        return this.execution;
    }

    public RunParameters setExecution(boolean execution) {
        this.execution = execution;
        return this;
    }

    public boolean isCreation() {
        return this.creation;
    }

    public RunParameters setCreation(boolean creation) {
        this.creation = creation;
        return this;
    }

    public boolean isServiceTask() {
        return this.servicetask;
    }

    public RunParameters setServiceTask(boolean servicetask) {
        this.servicetask = servicetask;
        return this;
    }

    public boolean isUserTask() {
        return this.usertask;
    }

    public RunParameters setUserTask(boolean usertask) {
        this.usertask = usertask;
        return this;
    }

    public boolean isVerification() {
        return this.verification;
    }

    public RunParameters setVerification(boolean verification) {
        this.verification = verification;
        return this;
    }

    public boolean isClearAllAfter() {
        return this.clearAllAfter;
    }

    public RunParameters setClearAllAfter(boolean clearAllAfter) {
        this.clearAllAfter = clearAllAfter;
        return this;
    }

    public boolean isDeploymentProcess() {
        return this.deploymentProcess;
    }

    public RunParameters setDeploymentProcess(boolean deploymentProcess) {
        this.deploymentProcess = deploymentProcess;
        return this;
    }

    public boolean isFullDetailsSynthesis() {
        return this.fullDetailsSynthesis;
    }

    public RunParameters setFullDetailsSynthesis(boolean fullDetailsSynthesis) {
        this.fullDetailsSynthesis = fullDetailsSynthesis;
        return this;
    }

    public List<String> getFilterServiceTask() {
        return this.filterServiceTask;
    }

    public RunParameters setFilterServiceTask(List<String> filterServiceTask) {
        this.filterServiceTask = filterServiceTask;
        return this;
    }

    public boolean isDeepTracking() {
        return this.deepTracking;
    }

    public RunParameters setDeepTracking(boolean deepTracking) {
        this.deepTracking = deepTracking;
        return this;
    }

    public String getScenarioPath() {
        return this.scenarioPath;
    }

    public RunParameters setScenarioPath(String scenarioPath) {
        this.scenarioPath = scenarioPath;
        return this;
    }

    public boolean isWarmingUp() {
        return this.warmingUp;
    }

    public RunParameters setWarmingUp(boolean warmingUp) {
        this.warmingUp = warmingUp;
        return this;
    }

    public int getNumberOfThreadsPerScenario() {
        return this.numberOfThreadsPerScenario <= 0 ? 1 : this.numberOfThreadsPerScenario;
    }

    public RunParameters setNumberOfThreadsPerScenario(int numberOfThreadsPerScenario) {
        this.numberOfThreadsPerScenario = numberOfThreadsPerScenario;
        return this;
    }

    public boolean isLevelDebug() {
        return this.getLogLevelAsNumber() >= 5;
    }

    public boolean isLevelInfo() {
        return this.getLogLevelAsNumber() >= 4;
    }

    public boolean isLevelMonitoring() {
        return this.getLogLevelAsNumber() >= 3;
    }

    public boolean isLevelDashboard() {
        return this.getLogLevelAsNumber() >= 2;
    }

    public void setFilterExecutionServiceTask(List<String> filterServiceTask) {
        this.filterServiceTask = filterServiceTask;
    }

    public boolean blockExecutionServiceTask(String topic) {
        if (this.filterServiceTask.isEmpty()) {
            return false;
        }
        return !this.filterServiceTask.contains(topic);
    }

    private int getLogLevelAsNumber() {
        return switch (this.logLevel) {
            case LOGLEVEL.NOTHING -> 0;
            case LOGLEVEL.MAIN -> 1;
            case LOGLEVEL.DASHBOARD -> 2;
            case LOGLEVEL.MONITORING -> 3;
            case LOGLEVEL.INFO -> 4;
            case LOGLEVEL.DEBUG -> 5;
            default -> 0;
        };
    }

    public static enum LOGLEVEL {
        DEBUG,
        INFO,
        MONITORING,
        DASHBOARD,
        MAIN,
        NOTHING;

    }
}

