/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioVerificationBasic;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunScenario;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunResult {
    private final RunScenario runScenario;
    private final List<ErrorDescription> listErrors = new ArrayList<ErrorDescription>();
    private final List<StepExecution> listDetailsSteps = new ArrayList<StepExecution>();
    private final List<VerificationStatus> listVerifications = new ArrayList<VerificationStatus>();
    private final List<String> listProcessInstancesId = new ArrayList<String>();
    private final List<String> listProcessIdDeployed = new ArrayList<String>();
    private final Map<String, RecordCreationPI> recordCreationPIMap = new HashMap<String, RecordCreationPI>();
    Logger logger = LoggerFactory.getLogger(RunResult.class);
    private int numberOfSteps = 0;
    private int numberOfErrorSteps = 0;
    private long timeExecution;
    private Date startDate;
    private Date endDate;

    public RunResult(RunScenario runScenario) {
        this.runScenario = runScenario;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public void addProcessInstanceId(String processId, String processInstanceId) {
        this.listProcessInstancesId.add(processInstanceId);
        RecordCreationPI create = this.recordCreationPIMap.getOrDefault(processId, new RecordCreationPI(processId));
        ++create.nbCreated;
        this.recordCreationPIMap.put(processId, create);
    }

    public void registerAddProcessInstance(String processId, boolean withSuccess) {
        RecordCreationPI create = this.recordCreationPIMap.getOrDefault(processId, new RecordCreationPI(processId));
        if (withSuccess) {
            ++create.nbCreated;
        } else {
            ++create.nbFailed;
        }
        this.recordCreationPIMap.put(processId, create);
    }

    public void addTimeExecution(long timeToAdd) {
        this.timeExecution += timeToAdd;
    }

    public void addStepExecution(ScenarioStep step, long timeExecution) {
        this.addTimeExecution(timeExecution);
        ++this.numberOfSteps;
        if (this.runScenario.getRunParameters().isLevelInfo()) {
            StepExecution scenarioExecution = new StepExecution(this);
            scenarioExecution.step = step;
            this.listDetailsSteps.add(scenarioExecution);
        }
    }

    public void registerAddStepExecution() {
        ++this.numberOfSteps;
    }

    public void registerAddErrorStepExecution() {
        ++this.numberOfErrorSteps;
    }

    public List<ErrorDescription> getListErrors() {
        return this.listErrors;
    }

    public void addError(ScenarioStep step, String explanation) {
        this.listErrors.add(new ErrorDescription(step, explanation));
        this.logger.error((step == null ? "" : step.getType().toString()) + " " + explanation);
    }

    public void addError(ScenarioStep step, AutomatorException e) {
        this.listErrors.add(new ErrorDescription(step, e.getMessage()));
    }

    public void addVerification(ScenarioVerificationBasic verification, boolean isSuccess, String message) {
        VerificationStatus verificationStatus = new VerificationStatus();
        verificationStatus.verification = verification;
        verificationStatus.isSuccess = isSuccess;
        verificationStatus.message = message;
        this.listVerifications.add(verificationStatus);
    }

    public List<VerificationStatus> getListVerifications() {
        return this.listVerifications;
    }

    public void add(RunResult result) {
        this.addTimeExecution(result.getTimeExecution());
        this.listErrors.addAll(result.listErrors);
        this.listVerifications.addAll(result.listVerifications);
        for (Map.Entry<String, RecordCreationPI> entry : result.recordCreationPIMap.entrySet()) {
            RecordCreationPI currentReference = this.recordCreationPIMap.getOrDefault(entry.getKey(), new RecordCreationPI(entry.getKey()));
            currentReference.nbFailed += entry.getValue().nbFailed;
            currentReference.nbCreated += entry.getValue().nbCreated;
            this.recordCreationPIMap.put(entry.getKey(), currentReference);
        }
        this.numberOfSteps += result.numberOfSteps;
        this.numberOfErrorSteps += result.numberOfErrorSteps;
        if (this.runScenario.getRunParameters() != null && this.runScenario.getRunParameters().isLevelInfo()) {
            this.listDetailsSteps.addAll(result.listDetailsSteps);
            this.listProcessInstancesId.addAll(result.listProcessInstancesId);
        }
    }

    public boolean isSuccess() {
        long nbVerificationErrors = this.listVerifications.stream().filter(t -> !t.isSuccess).count();
        return this.listErrors.isEmpty() && nbVerificationErrors == 0L;
    }

    public String getFirstProcessInstanceId() {
        return this.listProcessInstancesId.isEmpty() ? null : this.listProcessInstancesId.get(0);
    }

    public List<String> getProcessInstanceId() {
        return this.listProcessInstancesId;
    }

    public long getTimeExecution() {
        return this.timeExecution;
    }

    public void setTimeExecution(long timeExecution) {
        this.timeExecution = timeExecution;
    }

    public List<String> getProcessIdDeployed() {
        return this.listProcessIdDeployed;
    }

    public void addDeploymentProcessId(String processId) {
        this.listProcessIdDeployed.add(processId);
    }

    public Map<String, RecordCreationPI> getRecordCreationPI() {
        return this.recordCreationPIMap;
    }

    public long getRecordCreationPIAllProcesses() {
        long sum = 0L;
        for (RecordCreationPI value : this.recordCreationPIMap.values()) {
            sum += value.nbCreated;
        }
        return sum;
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public int getNumberOfErrorSteps() {
        return this.numberOfErrorSteps;
    }

    public String getSynthesis(boolean fullDetail) {
        StringBuilder synthesis = new StringBuilder();
        synthesis.append(this.isSuccess() ? "SUCCESS " : "FAIL    ");
        synthesis.append(this.runScenario.getScenario().getName());
        synthesis.append("(");
        synthesis.append(this.runScenario.getScenario().getProcessId());
        synthesis.append("): ");
        synthesis.append(this.timeExecution);
        synthesis.append(" timeExecution(ms), ");
        synthesis.append(this.recordCreationPIMap.get((Object)this.runScenario.getScenario().getProcessId()).nbCreated);
        synthesis.append(" PICreated, ");
        synthesis.append(this.recordCreationPIMap.get((Object)this.runScenario.getScenario().getProcessId()).nbFailed);
        synthesis.append(" PIFailed, ");
        synthesis.append(this.numberOfSteps);
        synthesis.append(" stepsExecuted, ");
        synthesis.append(this.numberOfErrorSteps);
        synthesis.append(" errorStepsExecuted, ");
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(this.listErrors.stream().map(t -> (t.step != null ? t.step.toString() : "") + t.explanation + "\n").collect(Collectors.joining(",")));
        if (fullDetail) {
            synthesis.append((CharSequence)errorMessage);
        }
        StringBuilder verificationMessage = new StringBuilder();
        verificationMessage.append(this.listVerifications.stream().map(t -> t.verification.getSynthesis() + "? " + (t.isSuccess ? "OK" : "FAIL") + " " + t.message + "\n").collect(Collectors.joining(",")));
        if (fullDetail) {
            synthesis.append((CharSequence)verificationMessage);
        }
        if (fullDetail) {
            synthesis.append(" ListOfPICreated: ");
            synthesis.append(this.listProcessInstancesId.stream().collect(Collectors.joining(",")));
        }
        return synthesis.toString();
    }

    public static class RecordCreationPI {
        public String processId;
        public long nbCreated = 0L;
        public long nbFailed = 0L;

        public RecordCreationPI(String processId) {
            this.processId = processId;
        }

        public void add(RecordCreationPI record) {
            if (record == null) {
                return;
            }
            this.nbCreated += record.nbCreated;
            this.nbFailed += record.nbFailed;
        }
    }

    public static class StepExecution {
        public final List<ErrorDescription> listErrors = new ArrayList<ErrorDescription>();
        private final RunResult scenarioExecutionResult;
        public ScenarioStep step;
        public long timeExecution;

        public StepExecution(RunResult scenarioExecutionResult) {
            this.scenarioExecutionResult = scenarioExecutionResult;
        }

        public void addError(ErrorDescription error) {
            this.listErrors.add(error);
        }
    }

    public static class ErrorDescription {
        public ScenarioStep step;
        public ScenarioVerificationBasic verificationBasic;
        public String explanation;

        public ErrorDescription(ScenarioStep step, String explanation) {
            this.step = step;
            this.explanation = explanation;
        }

        public ErrorDescription(ScenarioVerificationBasic verificationBasic, String explanation) {
            this.verificationBasic = verificationBasic;
            this.explanation = explanation;
        }
    }

    public class VerificationStatus {
        public ScenarioVerificationBasic verification;
        public boolean isSuccess;
        public String message;
    }
}

