/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.camunda8.BenchmarkCompleteJobExceptionHandlingStrategy;
import org.camunda.automator.bpmnengine.camunda8.refactoring.RefactoredCommandWrapper;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.FixedBackoffSupplier;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioFlowServiceTask
extends RunScenarioFlowBasic {
    private static final TrackActiveWorker trackActiveWorkers = new TrackActiveWorker();
    private static final TrackActiveWorker trackAsynchronousWorkers = new TrackActiveWorker();
    private final TaskScheduler scheduler;
    private final Semaphore semaphore;
    Logger logger = LoggerFactory.getLogger(RunScenarioFlowServiceTask.class);
    private BpmnEngine.RegisteredTask registeredTask;
    private boolean stopping;
    @Autowired
    private BenchmarkCompleteJobExceptionHandlingStrategy exceptionHandlingStrategy;

    public RunScenarioFlowServiceTask(TaskScheduler scheduler, ScenarioStep scenarioStep, int index, RunScenario runScenario, RunResult runResult) {
        super(scenarioStep, index, runScenario, runResult);
        this.scheduler = scheduler;
        this.semaphore = new Semaphore(runScenario.getBpmnEngine().getWorkerExecutionThreads());
    }

    @Override
    public void execute() {
        this.registerWorker();
    }

    @Override
    public void pleaseStop() {
        this.logger.info("Ask Stopping [" + this.getId() + "]");
        this.stopping = true;
        if (this.registeredTask == null || this.registeredTask.isNull()) {
            return;
        }
        if (this.registeredTask.isClosed()) {
            return;
        }
        this.registeredTask.close();
        Duration durationSleep = this.getScenarioStep().getWaitingTimeDuration(Duration.ZERO);
        long expectedEndTime = System.currentTimeMillis() + durationSleep.toMillis();
        while (!this.registeredTask.isClosed() && System.currentTimeMillis() < expectedEndTime) {
            this.registeredTask.close();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.logger.info("[" + this.getId() + "] " + (this.registeredTask.isClosed() ? "stopped" : "Fail to stop"));
        this.registeredTask = null;
    }

    @Override
    public RunScenarioFlowBasic.STATUS getStatus() {
        if (this.registeredTask == null) {
            return RunScenarioFlowBasic.STATUS.STOPPED;
        }
        if (this.stopping) {
            return RunScenarioFlowBasic.STATUS.STOPPING;
        }
        return RunScenarioFlowBasic.STATUS.RUNNING;
    }

    @Override
    public int getCurrentNumberOfThreads() {
        return trackActiveWorkers.getCounter() + trackAsynchronousWorkers.getCounter();
    }

    private void registerWorker() {
        BpmnEngine bpmnEngine = this.getRunScenario().getBpmnEngine();
        Duration durationSleep = this.getScenarioStep().getWaitingTimeDuration(Duration.ZERO);
        durationSleep = durationSleep.plusSeconds(10L);
        this.registeredTask = bpmnEngine.registerServiceTask(this.getId(), this.getScenarioStep().getTopic(), durationSleep, new SimpleDelayHandler(this), new FixedBackoffSupplier(this.getScenarioStep().getFixedBackOffDelay()));
    }

    private static class TrackActiveWorker {
        public int counter = 0;

        private TrackActiveWorker() {
        }

        public synchronized void movement(int movement) {
            this.counter += movement;
        }

        public int getCounter() {
            return this.counter;
        }
    }

    public class SimpleDelayHandler
    implements ExternalTaskHandler,
    JobHandler {
        private final RunScenarioFlowServiceTask flowServiceTask;
        private final Duration durationSleep;

        public SimpleDelayHandler(RunScenarioFlowServiceTask flowServiceTask) {
            this.flowServiceTask = flowServiceTask;
            this.durationSleep = flowServiceTask.getScenarioStep().getWaitingTimeDuration(Duration.ZERO);
        }

        public void execute(ExternalTask externalTask, ExternalTaskService externalTaskService) {
            switch (RunScenarioFlowServiceTask.this.getScenarioStep().getModeExecution()) {
                case CLASSICAL: 
                case WAIT: {
                    this.manageWaitExecution(externalTask, externalTaskService, null, null, this.durationSleep.toMillis());
                    break;
                }
                case THREAD: 
                case ASYNCHRONOUS: {
                    this.manageAsynchronousExecution(externalTask, externalTaskService, null, null);
                    break;
                }
                case THREADTOKEN: 
                case ASYNCHRONOUSLIMITED: {
                    this.manageAsynchronousLimitedExecution(externalTask, externalTaskService, null, null);
                }
            }
        }

        public void handle(JobClient jobClient, ActivatedJob activatedJob) throws Exception {
            switch (RunScenarioFlowServiceTask.this.getScenarioStep().getModeExecution()) {
                case CLASSICAL: 
                case WAIT: {
                    this.manageWaitExecution(null, null, jobClient, activatedJob, this.durationSleep.toMillis());
                    break;
                }
                case THREAD: 
                case ASYNCHRONOUS: {
                    this.manageAsynchronousExecution(null, null, jobClient, activatedJob);
                    break;
                }
                case THREADTOKEN: 
                case ASYNCHRONOUSLIMITED: {
                    this.manageAsynchronousLimitedExecution(null, null, jobClient, activatedJob);
                }
            }
        }

        private void manageWaitExecution(ExternalTask externalTask, ExternalTaskService externalTaskService, JobClient jobClient, ActivatedJob activatedJob, long waitTimeInMs) {
            long begin = System.currentTimeMillis();
            try {
                if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isDeepTracking()) {
                    trackActiveWorkers.movement(1);
                }
                if (waitTimeInMs > 0L) {
                    Thread.sleep(waitTimeInMs);
                }
                HashMap variables = new HashMap();
                if (externalTask != null) {
                    externalTaskService.complete(externalTask, variables);
                }
                if (jobClient != null) {
                    CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(activatedJob.getKey());
                    RefactoredCommandWrapper command = new RefactoredCommandWrapper((FinalCommandStep<Void>)completeCommand, activatedJob.getDeadline(), activatedJob.toString(), RunScenarioFlowServiceTask.this.exceptionHandlingStrategy);
                    command.executeAsync();
                }
                this.flowServiceTask.runResult.registerAddStepExecution();
            }
            catch (Exception e) {
                RunScenarioFlowServiceTask.this.logger.error("Error task[" + this.flowServiceTask.getId() + " " + externalTask.getBusinessKey() + " : " + e.getMessage());
                this.flowServiceTask.runResult.registerAddErrorStepExecution();
            }
            long end = System.currentTimeMillis();
            if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isDeepTracking()) {
                trackActiveWorkers.movement(-1);
            }
            if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isLevelMonitoring()) {
                RunScenarioFlowServiceTask.this.logger.info("Executed task[{}] in {} ms Sleep [{} s]", new Object[]{RunScenarioFlowServiceTask.this.getId(), end - begin, this.durationSleep.getSeconds()});
            }
        }

        private void manageAsynchronousExecution(final ExternalTask externalTask, final ExternalTaskService externalTaskService, final JobClient jobClient, final ActivatedJob activatedJob) {
            if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isDeepTracking()) {
                trackAsynchronousWorkers.movement(1);
            }
            this.flowServiceTask.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    SimpleDelayHandler.this.manageWaitExecution(externalTask, externalTaskService, jobClient, activatedJob, 0L);
                    if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isDeepTracking()) {
                        trackAsynchronousWorkers.movement(-1);
                    }
                }
            }, Instant.now().plusMillis(this.durationSleep.toMillis()));
        }

        private void manageAsynchronousLimitedExecution(final ExternalTask externalTask, final ExternalTaskService externalTaskService, final JobClient jobClient, final ActivatedJob activatedJob) {
            try {
                this.flowServiceTask.semaphore.acquire();
                if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isLevelMonitoring()) {
                    RunScenarioFlowServiceTask.this.logger.info("task[{}] Semaphore acquire", (Object)RunScenarioFlowServiceTask.this.getId());
                }
            }
            catch (Exception e) {
                return;
            }
            this.flowServiceTask.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    SimpleDelayHandler.this.manageWaitExecution(externalTask, externalTaskService, jobClient, activatedJob, 0L);
                    SimpleDelayHandler.this.flowServiceTask.semaphore.release();
                    if (RunScenarioFlowServiceTask.this.getRunScenario().getRunParameters().isLevelMonitoring()) {
                        RunScenarioFlowServiceTask.this.logger.info("task[{}] Semaphore release", (Object)RunScenarioFlowServiceTask.this.getId());
                    }
                }
            }, Instant.now().plusMillis(this.durationSleep.toMillis()));
        }
    }
}

