/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunZeebeOperation;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioFlowStartEvent
extends RunScenarioFlowBasic {
    private final TaskScheduler scheduler;
    Logger logger = LoggerFactory.getLogger(RunScenarioFlowStartEvent.class);
    private boolean stopping;
    private boolean isRunning;
    private int stepNumber = 0;

    public RunScenarioFlowStartEvent(TaskScheduler scheduler, ScenarioStep scenarioStep, int index, RunScenario runScenario, RunResult runResult) {
        super(scenarioStep, index, runScenario, runResult);
        this.scheduler = scheduler;
    }

    @Override
    public void execute() {
        this.stopping = false;
        this.isRunning = true;
        Duration duration = Duration.parse(this.getScenarioStep().getFrequency());
        StartEventRunnable startEventRunnable = new StartEventRunnable(this.scheduler, this.getScenarioStep(), this.runResult, this.getRunScenario(), this);
        this.scheduler.schedule((Runnable)startEventRunnable, Instant.now());
    }

    @Override
    public void pleaseStop() {
        this.stopping = true;
    }

    @Override
    public RunScenarioFlowBasic.STATUS getStatus() {
        if (!this.isRunning) {
            return RunScenarioFlowBasic.STATUS.STOPPED;
        }
        if (this.stopping) {
            return RunScenarioFlowBasic.STATUS.STOPPING;
        }
        return RunScenarioFlowBasic.STATUS.RUNNING;
    }

    @Override
    public int getCurrentNumberOfThreads() {
        return 0;
    }

    @Override
    public RunResult getRunResult() {
        return this.runResult;
    }

    class StartEventRunnable
    implements Runnable {
        private final TaskScheduler scheduler;
        private final ScenarioStep scenarioStep;
        private final RunResult runResult;
        private final RunScenario runScenario;
        private final RunScenarioFlowStartEvent flowStartEvent;
        private int nbOverloaded = 0;
        private int totalCreation = 0;
        private int totalCreationGoal = 0;
        private int totalFailed = 0;

        public StartEventRunnable(TaskScheduler scheduler, ScenarioStep scenarioStep, RunResult runResult, RunScenario runScenario, RunScenarioFlowStartEvent flowStartEvent) {
            this.scheduler = scheduler;
            this.scenarioStep = scenarioStep;
            this.runResult = runResult;
            this.runScenario = runScenario;
            this.flowStartEvent = flowStartEvent;
        }

        @Override
        public void run() {
            long end;
            ++RunScenarioFlowStartEvent.this.stepNumber;
            if (this.flowStartEvent.stopping) {
                if (this.runScenario.getRunParameters().isLevelMonitoring()) {
                    RunScenarioFlowStartEvent.this.logger.info("Stop now [" + RunScenarioFlowStartEvent.this.getId() + "]");
                    if (this.nbOverloaded > 0) {
                        this.runResult.addError(this.scenarioStep, "Overloaded " + this.nbOverloaded + " TotalCreation " + this.totalCreation + " Goal " + this.totalCreationGoal + " Process[" + this.scenarioStep.getProcessId() + "] Can't create PI at the required frequency");
                    }
                    if (this.totalFailed > 0) {
                        this.runResult.addError(this.scenarioStep, "Failed " + this.totalFailed + " Process[" + this.scenarioStep.getProcessId() + "] Can't create PI ");
                    }
                }
                this.flowStartEvent.isRunning = false;
                return;
            }
            long begin = System.currentTimeMillis();
            int nbCreation = 0;
            int nbFailed = 0;
            boolean isOverloadSection = false;
            Duration duration = Duration.parse(this.scenarioStep.getFrequency());
            ArrayList<String> listProcessInstances = new ArrayList<String>();
            this.totalCreationGoal += this.scenarioStep.getNumberOfExecutions();
            boolean alreadyLoggedError = false;
            for (int i = 0; i < this.scenarioStep.getNumberOfExecutions(); ++i) {
                try {
                    String processInstance = this.runScenario.getBpmnEngine().createProcessInstance(this.scenarioStep.getProcessId(), this.scenarioStep.getTaskId(), RunZeebeOperation.getVariablesStep(this.runScenario, this.scenarioStep));
                    if (listProcessInstances.size() < 21) {
                        listProcessInstances.add(processInstance);
                    }
                    ++nbCreation;
                    ++this.totalCreation;
                    this.runResult.registerAddProcessInstance(this.scenarioStep.getProcessId(), true);
                }
                catch (AutomatorException e) {
                    if (!alreadyLoggedError) {
                        this.runResult.addError(this.scenarioStep, "Step #" + RunScenarioFlowStartEvent.this.stepNumber + "-" + RunScenarioFlowStartEvent.this.getId() + " Error at creation: [" + e.getMessage() + "]");
                    }
                    alreadyLoggedError = true;
                    ++nbFailed;
                    ++this.totalFailed;
                    this.runResult.registerAddProcessInstance(this.scenarioStep.getProcessId(), false);
                }
                long currentTimeMillis = System.currentTimeMillis();
                Duration durationCurrent = duration.minusMillis(currentTimeMillis - begin);
                if (!durationCurrent.isNegative()) continue;
                RunScenarioFlowStartEvent.this.logger.info("Step #" + RunScenarioFlowStartEvent.this.stepNumber + "-" + RunScenarioFlowStartEvent.this.getId() + " Take too long to created ProcessInstances: created {} when expected {}", (Object)nbCreation, (Object)this.scenarioStep.getNumberOfExecutions());
                isOverloadSection = true;
                break;
            }
            if ((duration = duration.minusMillis((end = System.currentTimeMillis()) - begin)).isNegative()) {
                duration = Duration.ZERO;
                isOverloadSection = true;
                ++this.nbOverloaded;
            }
            if (this.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioFlowStartEvent.this.logger.info("Step #" + RunScenarioFlowStartEvent.this.stepNumber + "-" + RunScenarioFlowStartEvent.this.getId() + "] Create (real/scenario)[" + nbCreation + "/" + this.scenarioStep.getNumberOfExecutions() + "] Failed[" + nbFailed + "] in " + (end - begin) + " ms " + (isOverloadSection ? "OVERLOAD" : "") + " Sleep[" + duration.getSeconds() + " s] listPI(max20): " + listProcessInstances.stream().collect(Collectors.joining(",")));
            }
            this.scheduler.schedule((Runnable)this, Instant.now().plusMillis(duration.toMillis()));
        }
    }

    public static enum STATUS {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

