/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunZeebeOperation;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioFlowUserTask
extends RunScenarioFlowBasic {
    private final TaskScheduler scheduler;
    Logger logger = LoggerFactory.getLogger(RunScenarioFlowUserTask.class);
    private RunScenarioFlowBasic.STATUS status = RunScenarioFlowBasic.STATUS.RUNNING;

    public RunScenarioFlowUserTask(TaskScheduler scheduler, ScenarioStep scenarioStep, int index, RunScenario runScenario, RunResult runResult) {
        super(scenarioStep, index, runScenario, runResult);
        this.scheduler = scheduler;
    }

    @Override
    public void execute() {
        UserTaskRunnable startEventRunnable = new UserTaskRunnable(this.scheduler, this.getScenarioStep(), this.runResult, this.getRunScenario(), this);
        this.scheduler.schedule((Runnable)startEventRunnable, Instant.now());
    }

    @Override
    public RunScenarioFlowBasic.STATUS getStatus() {
        return this.status;
    }

    @Override
    public int getCurrentNumberOfThreads() {
        return 1;
    }

    @Override
    public void pleaseStop() {
        this.logger.info("Ask Stopping [" + this.getId() + "]");
        this.status = RunScenarioFlowBasic.STATUS.STOPPING;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class UserTaskRunnable
    implements Runnable {
        private final TaskScheduler scheduler;
        private final ScenarioStep scenarioStep;
        private final RunResult runResult;
        private final RunScenario runScenario;
        private final RunScenarioFlowUserTask flowUserTask;
        private final int nbOverloaded = 0;
        private final int totalCreation = 0;
        private final int totalCreationGoal = 0;
        private final int totalFailed = 0;

        public UserTaskRunnable(TaskScheduler scheduler, ScenarioStep scenarioStep, RunResult runResult, RunScenario runScenario, RunScenarioFlowUserTask flowUserTask) {
            this.scheduler = scheduler;
            this.scenarioStep = scenarioStep;
            this.runResult = runResult;
            this.runScenario = runScenario;
            this.flowUserTask = flowUserTask;
        }

        @Override
        public void run() {
            Long waitingTimeInMs = null;
            if (RunScenarioFlowUserTask.this.getScenarioStep().getWaitingTime() != null) {
                Duration duration = Duration.parse(RunScenarioFlowUserTask.this.getScenarioStep().getWaitingTime());
                waitingTimeInMs = duration.toMillis();
            }
            if (waitingTimeInMs == null) {
                waitingTimeInMs = 1L;
            }
            long beginTimeWait = System.currentTimeMillis();
            while (this.flowUserTask.status == RunScenarioFlowBasic.STATUS.RUNNING) {
                try {
                    List<String> listActivities;
                    do {
                        if (!(listActivities = RunScenarioFlowUserTask.this.getRunScenario().getBpmnEngine().searchUserTasks(RunScenarioFlowUserTask.this.getScenarioStep().getTaskId(), 10)).isEmpty()) continue;
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                    if (listActivities.isEmpty()) continue;
                    for (String taskInstanceId : listActivities) {
                        RunScenarioFlowUserTask.this.getRunScenario().getBpmnEngine().executeUserTask(taskInstanceId, RunScenarioFlowUserTask.this.getScenarioStep().getUserId(), RunZeebeOperation.getVariablesStep(RunScenarioFlowUserTask.this.getRunScenario(), RunScenarioFlowUserTask.this.getScenarioStep()));
                    }
                }
                catch (AutomatorException e) {
                    RunScenarioFlowUserTask.this.logger.error("Error task[" + RunScenarioFlowUserTask.this.getScenarioStep().getTaskId() + " : " + e.getMessage());
                    RunScenarioFlowUserTask.this.getRunResult().registerAddErrorStepExecution();
                }
            }
            this.flowUserTask.status = RunScenarioFlowBasic.STATUS.STOPPED;
        }
    }
}

