/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import io.camunda.operate.search.DateFilter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioWarmingUp;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunZeebeOperation;
import org.camunda.automator.engine.flow.RunScenarioFlowServiceTask;
import org.camunda.automator.engine.flow.RunScenarioFlowUserTask;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioWarmingUp {
    private final ServiceAccess serviceAccess;
    private final RunScenario runScenario;
    Logger logger = LoggerFactory.getLogger(RunScenarioWarmingUp.class);

    RunScenarioWarmingUp(ServiceAccess serviceAccess, RunScenario runScenario) {
        this.serviceAccess = serviceAccess;
        this.runScenario = runScenario;
    }

    public void warmingUp(RunResult runResult) {
        ScenarioWarmingUp warmingUp = this.runScenario.getScenario().getWarmingUp();
        if (warmingUp == null) {
            this.logger.info("WarmingUp not present in scenario");
            return;
        }
        if (!this.runScenario.getRunParameters().isWarmingUp()) {
            this.logger.info("WarmingUp present, but not allowed to start");
            return;
        }
        long beginTime = System.currentTimeMillis();
        long endWarmingUp = beginTime + (warmingUp.getDuration().toMillis() > 0L ? warmingUp.getDuration().toMillis() : 600000L);
        ArrayList<RunScenarioFlowServiceTask> listWarmingUpServiceTask = new ArrayList<RunScenarioFlowServiceTask>();
        ArrayList<RunScenarioFlowUserTask> listWarmingUpUserTask = new ArrayList<RunScenarioFlowUserTask>();
        ArrayList<StartEventWarmingUpRunnable> listWarmingUpStartEvent = new ArrayList<StartEventWarmingUpRunnable>();
        List<ScenarioStep> listOperationWarmingUp = warmingUp.getOperations();
        if (warmingUp.useServiceTasks) {
            listOperationWarmingUp.addAll(this.runScenario.getScenario().getFlows().stream().filter(t -> t.getType().equals((Object)ScenarioStep.Step.SERVICETASK)).toList());
        }
        if (warmingUp.useUserTasks) {
            listOperationWarmingUp.addAll(this.runScenario.getScenario().getFlows().stream().filter(t -> t.getType().equals((Object)ScenarioStep.Step.USERTASK)).toList());
        }
        this.logger.info("WarmingUp: Start ---- {} operations (useServiceTask {} useUserTask {}", new Object[]{listOperationWarmingUp.size(), warmingUp.useServiceTasks, warmingUp.useUserTasks});
        block7: for (ScenarioStep scenarioStep : listOperationWarmingUp) {
            switch (scenarioStep.getType()) {
                case STARTEVENT: {
                    this.logger.info("WarmingUp: StartEvent Generate [{}] Frequency [{}] EndWarmingUp [{}]", new Object[]{scenarioStep.getNumberOfExecutions(), scenarioStep.getFrequency(), scenarioStep.getEndWarmingUp()});
                    StartEventWarmingUpRunnable startEventWarmingUpRunnable = new StartEventWarmingUpRunnable(this.serviceAccess.getTaskScheduler("warmingUp"), scenarioStep, this.runScenario, runResult);
                    listWarmingUpStartEvent.add(startEventWarmingUpRunnable);
                    startEventWarmingUpRunnable.run();
                    continue block7;
                }
                case SERVICETASK: {
                    this.logger.info("WarmingUp: Start Service Task topic[{}]", (Object)scenarioStep.getTopic());
                    RunScenarioFlowServiceTask task = new RunScenarioFlowServiceTask(this.serviceAccess.getTaskScheduler("serviceTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
                    task.execute();
                    listWarmingUpServiceTask.add(task);
                    continue block7;
                }
                case USERTASK: {
                    this.logger.info("WarmingUp: Start User Task taskId[{}]", (Object)scenarioStep.getTaskId());
                    RunScenarioFlowUserTask userTask = new RunScenarioFlowUserTask(this.serviceAccess.getTaskScheduler("userTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
                    userTask.execute();
                    listWarmingUpUserTask.add(userTask);
                    continue block7;
                }
            }
            this.logger.info("WarmingUp: Unknown [{}]", (Object)scenarioStep.getType());
        }
        boolean warmingUpIsFinish = false;
        while (!warmingUpIsFinish) {
            long currentTime = System.currentTimeMillis();
            String analysis = "Limit warmupDuration in " + (endWarmingUp - currentTime) / 1000L + " s, ";
            if (currentTime >= endWarmingUp) {
                analysis = analysis + "OVER_MAXIMUM";
                warmingUpIsFinish = true;
            }
            boolean allIsFinished = true;
            for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
                analysis = analysis + "/ warmingUp[" + startRunnable.scenarioStep.getTaskId() + "] instanceCreated[" + startRunnable.nbInstancesCreated + "]";
                if (startRunnable.warmingUpFinished) {
                    analysis = analysis + " FINISH " + startRunnable.warmingUpFinishedAnalysis;
                    continue;
                }
                analysis = analysis + " NOT_FINISH " + startRunnable.warmingUpNotFinishedAnalysis;
                allIsFinished = false;
            }
            if (allIsFinished) {
                warmingUpIsFinish = true;
            }
            this.logger.info("WarmingUpFinished? {} analysis:[{}]", (Object)warmingUpIsFinish, (Object)analysis);
            if (warmingUpIsFinish) continue;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
            startRunnable.pleaseStop(true);
        }
        for (RunScenarioFlowServiceTask task : listWarmingUpServiceTask) {
            task.pleaseStop();
        }
        for (RunScenarioFlowUserTask userTask : listWarmingUpUserTask) {
            userTask.pleaseStop();
        }
        this.logger.info("WarmingUp: Complete ----");
    }

    class StartEventWarmingUpRunnable
    implements Runnable {
        private final TaskScheduler scheduler;
        private final ScenarioStep scenarioStep;
        private final RunScenario runScenario;
        private final RunResult runResult;
        public boolean stop = false;
        public boolean warmingUpFinished = false;
        public String warmingUpFinishedAnalysis = "";
        public String warmingUpNotFinishedAnalysis = "Not verified yet";
        public int nbInstancesCreated = 0;
        private int nbOverloaded = 0;

        public StartEventWarmingUpRunnable(TaskScheduler scheduler, ScenarioStep scenarioStep, RunScenario runScenario, RunResult runResult) {
            this.scheduler = scheduler;
            this.scenarioStep = scenarioStep;
            this.runScenario = runScenario;
            this.runResult = runResult;
        }

        public void pleaseStop(boolean stop) {
            this.stop = stop;
        }

        @Override
        public void run() {
            if (this.stop) {
                return;
            }
            CheckFunctionResult checkFunctionResult = null;
            if (this.scenarioStep.getEndWarmingUp() != null) {
                checkFunctionResult = this.endCheckFunction(this.scenarioStep.getEndWarmingUp(), this.runResult);
                if (checkFunctionResult.goalReach) {
                    this.warmingUpFinishedAnalysis = this.warmingUpFinishedAnalysis + "GoalReach[" + checkFunctionResult.analysis + "]";
                    this.warmingUpNotFinishedAnalysis = "";
                    this.warmingUpFinished = true;
                    return;
                }
                this.warmingUpNotFinishedAnalysis = checkFunctionResult.analysis();
            }
            long begin = System.currentTimeMillis();
            ArrayList<String> listProcessInstance = new ArrayList<String>();
            try {
                for (int i = 0; i < this.scenarioStep.getNumberOfExecutions(); ++i) {
                    String processInstance = this.runScenario.getBpmnEngine().createProcessInstance(this.scenarioStep.getProcessId(), this.scenarioStep.getTaskId(), RunZeebeOperation.getVariablesStep(this.runScenario, this.scenarioStep));
                    ++this.nbInstancesCreated;
                    if (listProcessInstance.size() >= 21) continue;
                    listProcessInstance.add(processInstance);
                }
            }
            catch (AutomatorException e) {
                RunScenarioWarmingUp.this.logger.error("Error at creation: [{}]", (Object)e.getMessage());
            }
            long end = System.currentTimeMillis();
            if (this.scenarioStep.getFrequency() == null || this.scenarioStep.getFrequency().isEmpty()) {
                if (this.runScenario.getRunParameters().isLevelMonitoring()) {
                    RunScenarioWarmingUp.this.logger.info("WarmingUp:StartEvent Create[{}] in {}  ms (oneShoot) listPI(max20): ", new Object[]{this.scenarioStep.getNumberOfExecutions(), end - begin, listProcessInstance.stream().collect(Collectors.joining(","))});
                }
                this.warmingUpFinishedAnalysis = this.warmingUpFinishedAnalysis + "GoalOneShoot";
                this.warmingUpFinished = true;
                return;
            }
            Duration duration = Duration.parse(this.scenarioStep.getFrequency());
            if ((duration = duration.minusMillis(end - begin)).isNegative()) {
                duration = Duration.ZERO;
                ++this.nbOverloaded;
            }
            if (this.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioWarmingUp.this.logger.info("Warmingup Create[" + this.scenarioStep.getNumberOfExecutions() + "] in " + (end - begin) + " ms Sleep [" + duration.getSeconds() + " s]" + (String)(checkFunctionResult == null ? "" : "EndWarmingUp:" + checkFunctionResult.analysis));
            }
            this.scheduler.schedule((Runnable)this, Instant.now().plusMillis(duration.toMillis()));
        }

        private CheckFunctionResult endCheckFunction(String function, RunResult runResult) {
            try {
                int posParenthesis = function.indexOf("(");
                String functionName = function.substring(0, posParenthesis);
                String parameters = function.substring(posParenthesis + 1);
                parameters = parameters.substring(0, parameters.length() - 1);
                StringTokenizer st = new StringTokenizer(parameters, ",");
                if ("UserTaskThreshold".equalsIgnoreCase(functionName)) {
                    String taskId = st.hasMoreTokens() ? st.nextToken() : "";
                    Integer threshold = st.hasMoreTokens() ? Integer.valueOf(st.nextToken()) : 0;
                    long value = this.runScenario.getBpmnEngine().countNumberOfTasks(this.runScenario.getScenario().getProcessId(), taskId);
                    return new CheckFunctionResult(value >= (long)threshold.intValue(), "Task[" + taskId + "] value [" + value + "] / threshold[" + threshold + "]");
                }
                if ("EndEventThreshold".equalsIgnoreCase(functionName)) {
                    String endId = st.hasMoreTokens() ? st.nextToken() : "";
                    Integer threshold = st.hasMoreTokens() ? Integer.valueOf(st.nextToken()) : 0;
                    long value = this.runScenario.getBpmnEngine().countNumberOfProcessInstancesEnded(this.runScenario.getScenario().getProcessId(), new DateFilter(runResult.getStartDate()), new DateFilter(new Date()));
                    return new CheckFunctionResult(value >= (long)threshold.intValue(), "End[" + endId + "] value [" + value + "] / threshold[" + threshold + "]");
                }
                RunScenarioWarmingUp.this.logger.error("Unknown function [{}]", (Object)functionName);
                return new CheckFunctionResult(false, "Unknown function");
            }
            catch (AutomatorException e) {
                RunScenarioWarmingUp.this.logger.error("Error during warmingup {}", (Object)e.getMessage());
                return new CheckFunctionResult(false, "Exception " + e.getMessage());
            }
        }

        public record CheckFunctionResult(boolean goalReach, String analysis) {
        }
    }
}

