/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.unit;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.unit.RunScenarioUnitServiceTask;
import org.camunda.automator.engine.unit.RunScenarioUnitStartEvent;
import org.camunda.automator.engine.unit.RunScenarioUnitUserTask;
import org.camunda.automator.engine.unit.RunScenarioVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioUnit {
    private final Logger logger = LoggerFactory.getLogger(RunScenarioUnit.class);
    private final RunScenario runScenario;
    private final ScenarioExecution scnExecution;
    private String agentName = "";

    public RunScenarioUnit(RunScenario runScenario, ScenarioExecution scnExecution) {
        this.runScenario = runScenario;
        this.scnExecution = scnExecution;
    }

    public void setAgentName(String name) {
        this.agentName = name;
    }

    public RunResult runExecution() {
        RunResult resultExecution = new RunResult(this.runScenario);
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": Start Execution [" + this.scnExecution.getName() + "] ");
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.scnExecution.getNumberOfThreads());
        ArrayList listFutures = new ArrayList();
        for (int i = 0; i < this.scnExecution.getNumberProcessInstances(); ++i) {
            ScnThreadExecutionCallable scnThreadExecutionCallable = new ScnThreadExecutionCallable("AutomatorThread-" + i, this, this.runScenario.getRunParameters());
            listFutures.add(executor.submit(scnThreadExecutionCallable));
        }
        try {
            for (Future future : listFutures) {
                Object scnRunResult = future.get();
                resultExecution.add((RunResult)scnRunResult);
            }
        }
        catch (Exception e) {
            resultExecution.addError(null, "Error during executing in parallel " + e.getMessage());
        }
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": End Execution [" + this.scnExecution.getName() + "] success? " + resultExecution.isSuccess());
        }
        return resultExecution;
    }

    private class ScnThreadExecutionCallable
    implements Callable {
        private final String agentName;
        private final RunScenarioUnit scnRunExecution;
        private final RunParameters runParameters;
        private RunResult scnRunResult;

        ScnThreadExecutionCallable(String agentName, RunScenarioUnit scnRunExecution, RunParameters runParameters) {
            this.agentName = agentName;
            this.scnRunExecution = scnRunExecution;
            this.runParameters = runParameters;
        }

        public Object call() throws Exception {
            this.scnRunResult = new RunResult(this.scnRunExecution.runScenario);
            if (this.runParameters.isExecution()) {
                this.runExecution();
            }
            if (this.runParameters.isVerification() && RunScenarioUnit.this.scnExecution.getVerifications() != null) {
                if (this.runParameters.isExecution()) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.runVerifications();
                } else if (RunScenarioUnit.this.scnExecution.getVerifications().getSearchProcessInstanceByVariable().isEmpty()) {
                    this.scnRunResult.addVerification(null, false, "No Search Instance by Variable is defined");
                } else {
                    List<BpmnEngine.ProcessDescription> listProcessInstances = RunScenarioUnit.this.runScenario.getBpmnEngine().searchProcessInstanceByVariable(RunScenarioUnit.this.scnExecution.getScnHead().getProcessId(), RunScenarioUnit.this.scnExecution.getVerifications().getSearchProcessInstanceByVariable(), 100);
                    for (BpmnEngine.ProcessDescription processInstance : listProcessInstances) {
                        this.scnRunResult.addProcessInstanceId(RunScenarioUnit.this.scnExecution.getScnHead().getProcessId(), processInstance.processInstanceId);
                    }
                    this.runVerifications();
                }
            }
            if (this.scnRunResult.getFirstProcessInstanceId() != null && this.runParameters.isClearAllAfter()) {
                RunScenarioUnit.this.runScenario.getBpmnEngine().endProcessInstance(this.scnRunResult.getFirstProcessInstanceId(), this.runParameters.isClearAllAfter());
            }
            return this.scnRunResult;
        }

        public void runExecution() {
            RunScenarioUnitServiceTask serviceTask = new RunScenarioUnitServiceTask(RunScenarioUnit.this.runScenario);
            RunScenarioUnitUserTask userTask = new RunScenarioUnitUserTask(RunScenarioUnit.this.runScenario);
            RunScenarioUnitStartEvent startEvent = new RunScenarioUnitStartEvent(RunScenarioUnit.this.runScenario);
            if (this.scnRunExecution.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioUnit.this.logger.info("ScnRunExecution.StartExecution [" + this.scnRunExecution.runScenario.getScenario().getName() + "] agent[" + this.agentName + "]");
            }
            for (ScenarioStep step : RunScenarioUnit.this.scnExecution.getSteps()) {
                if (this.scnRunExecution.runScenario.getRunParameters().isLevelDebug()) {
                    RunScenarioUnit.this.logger.info("ScnRunExecution.StartExecution.Execute [" + this.scnRunExecution.runScenario.getScenario().getName() + "." + step.getTaskId() + " agent[" + this.agentName + "]");
                }
                try {
                    step.checkConsistence();
                }
                catch (AutomatorException e) {
                    this.scnRunResult.addError(step, e.getMessage());
                    continue;
                }
                long timeBegin = System.currentTimeMillis();
                if (step.getType() == null) {
                    this.scnRunResult.addError(step, "Unknown type");
                    continue;
                }
                switch (step.getType()) {
                    case STARTEVENT: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().isCreation()) break;
                        this.scnRunResult = startEvent.startEvent(this.scnRunResult, step);
                        break;
                    }
                    case USERTASK: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().isUserTask()) break;
                        this.scnRunResult = userTask.executeUserTask(this.scnRunResult, step);
                        break;
                    }
                    case SERVICETASK: {
                        if (!this.scnRunExecution.runScenario.getRunParameters().isServiceTask()) break;
                        this.scnRunResult = serviceTask.executeServiceTask(this.scnRunResult, step);
                        break;
                    }
                    case ENDEVENT: {
                        break;
                    }
                }
                long timeEnd = System.currentTimeMillis();
                this.scnRunResult.addStepExecution(step, timeEnd - timeBegin);
                if (this.scnRunResult.isSuccess() || !ScenarioExecution.Policy.STOPATFIRSTERROR.equals((Object)RunScenarioUnit.this.scnExecution.getPolicy())) continue;
                return;
            }
            if (this.scnRunExecution.runScenario.getRunParameters().isLevelMonitoring()) {
                RunScenarioUnit.this.logger.info("ScnRunExecution.EndExecution [" + RunScenarioUnit.this.scnExecution.getName() + "] agent[" + this.agentName + "]");
            }
        }

        public void runVerifications() {
            RunScenarioVerification verifications = new RunScenarioVerification(RunScenarioUnit.this.scnExecution);
            for (String processInstanceId : this.scnRunResult.getProcessInstanceId()) {
                this.scnRunResult.add(verifications.runVerifications(this.scnRunExecution.runScenario, processInstanceId));
            }
        }

        public RunResult getScnRunResult() {
            return this.scnRunResult;
        }
    }
}

