/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.unit;

import java.time.Duration;
import java.util.List;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunZeebeOperation;

public class RunScenarioUnitUserTask {
    private final RunScenario runScenario;

    protected RunScenarioUnitUserTask(RunScenario runScenario) {
        this.runScenario = runScenario;
    }

    public RunResult executeUserTask(RunResult result, ScenarioStep step) {
        if (step.getDelay() != null) {
            Duration duration = Duration.parse(step.getDelay());
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long waitingTimeInMs = null;
        if (step.getWaitingTime() != null) {
            Duration duration = Duration.parse(step.getWaitingTime());
            waitingTimeInMs = duration.toMillis();
        }
        if (waitingTimeInMs == null) {
            waitingTimeInMs = 300000L;
        }
        for (int index = 0; index < step.getNumberOfExecutions(); ++index) {
            long beginTimeWait = System.currentTimeMillis();
            try {
                List<String> listActivities;
                do {
                    if (!(listActivities = this.runScenario.getBpmnEngine().searchUserTasksByProcessInstance(result.getFirstProcessInstanceId(), step.getTaskId(), 1)).isEmpty()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                if (listActivities.isEmpty()) {
                    result.addError(step, "No user task show up task[" + step.getTaskId() + "] processInstance[" + result.getFirstProcessInstanceId() + "]");
                    return result;
                }
                this.runScenario.getBpmnEngine().executeUserTask(listActivities.get(0), step.getUserId(), RunZeebeOperation.getVariablesStep(this.runScenario, step));
                continue;
            }
            catch (AutomatorException e) {
                result.addError(step, e.getMessage());
                return result;
            }
        }
        return result;
    }
}

