/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services;

import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.camunda.automator.AutomatorAPI;
import org.camunda.automator.AutomatorCLI;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.configuration.ConfigurationStartup;
import org.camunda.automator.definition.Scenario;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunParameters;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AutomatorStartup {
    static Logger logger = LoggerFactory.getLogger(AutomatorStartup.class);
    @Autowired
    ConfigurationStartup configurationStartup;
    @Autowired
    AutomatorAPI automatorAPI;
    @Autowired
    AutomatorCLI automatorCLI;
    @Autowired
    ConfigurationBpmEngine engineConfiguration;
    @Autowired
    ServiceAccess serviceAccess;

    @PostConstruct
    public void init() {
        if (AutomatorCLI.isRunningCLI) {
            return;
        }
        AutomatorSetupRunnable automatorSetupRunnable = new AutomatorSetupRunnable(this.configurationStartup, this.automatorAPI, this.automatorCLI, this.engineConfiguration);
        this.serviceAccess.getTaskScheduler("AutomatorSetup").schedule((Runnable)automatorSetupRunnable, Instant.now());
    }

    private void runFixedWarmup() {
        if (this.configurationStartup.getWarmingUpServer().getSeconds() > 30L) {
            logger.info("WarmupFixedTime: wait.... {} s", (Object)this.configurationStartup.getWarmingUpServer().getSeconds());
            try {
                Thread.sleep(this.configurationStartup.getWarmingUpServer().toMillis());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("WarmupFixedTime: end");
        }
    }

    private List<Object> registerScenario() {
        ArrayList<Object> scenarioList = new ArrayList<Object>();
        if (this.configurationStartup.getScenarioFileAtStartup().isEmpty()) {
            logger.info("No scenario [File] from variable {} given", (Object)this.configurationStartup.getScenarioFileAtStartupName());
        } else {
            logger.info("Detect {} scenario [File] from variable {}", (Object)this.configurationStartup.getScenarioFileAtStartup().size(), (Object)this.configurationStartup.getScenarioFileAtStartupName());
            for (String scenarioFileName : this.configurationStartup.getScenarioFileAtStartup()) {
                logger.info("Register scenario [File] [{}]", (Object)scenarioFileName);
                File scenarioFile = new File(this.configurationStartup.scenarioPath + "/" + scenarioFileName);
                if (!scenarioFile.exists()) {
                    logger.error("ScenarioFile: Can't find [{}/{}]", (Object)this.configurationStartup.scenarioPath, (Object)scenarioFileName);
                    continue;
                }
                scenarioList.add(scenarioFile);
            }
        }
        if (this.configurationStartup.getScenarioResourceAtStartup().isEmpty()) {
            logger.info("No scenario [Resource] from variable {} given", (Object)this.configurationStartup.getScenarioResourceAtStartupName());
        } else {
            logger.info("Detect {} scenario [Resource] from variable {}", (Object)this.configurationStartup.getScenarioResourceAtStartup().size(), (Object)this.configurationStartup.getScenarioResourceAtStartupName());
            for (Resource resource : this.configurationStartup.getScenarioResourceAtStartup()) {
                logger.info("Load scenario [Resource] from [{}]", (Object)resource.getDescription());
                scenarioList.add(resource);
            }
        }
        return scenarioList;
    }

    class AutomatorSetupRunnable
    implements Runnable {
        ConfigurationStartup configurationStartup;
        AutomatorAPI automatorAPI;
        AutomatorCLI automatorCLI;
        ConfigurationBpmEngine engineConfiguration;

        public AutomatorSetupRunnable(ConfigurationStartup configurationStartup, AutomatorAPI automatorAPI, AutomatorCLI automatorCLI, ConfigurationBpmEngine engineConfiguration) {
            this.configurationStartup = configurationStartup;
            this.automatorAPI = automatorAPI;
            this.automatorCLI = automatorCLI;
            this.engineConfiguration = engineConfiguration;
        }

        @Override
        public void run() {
            RunParameters runParameters = new RunParameters();
            runParameters.setExecution(true).setLogLevel(this.configurationStartup.getLogLevelEnum()).setCreation(this.configurationStartup.isPolicyExecutionCreation()).setServiceTask(this.configurationStartup.isPolicyExecutionServiceTask()).setUserTask(this.configurationStartup.isPolicyExecutionUserTask()).setWarmingUp(this.configurationStartup.isPolicyExecutionWarmingUp()).setDeploymentProcess(this.configurationStartup.isPolicyDeployProcess()).setDeepTracking(this.configurationStartup.deepTracking());
            List<String> filterService = this.configurationStartup.getFilterService();
            if (filterService != null) {
                runParameters.setFilterExecutionServiceTask(filterService);
            }
            logger.info("AutomatorStartup parameters warmingUp[{}] creation:[{}] serviceTask:[{}] userTask:[{}] ScenarioPath[{}] logLevel[{}] waitWarmingUpServer[{} s]", new Object[]{runParameters.isWarmingUp(), runParameters.isCreation(), runParameters.isServiceTask(), runParameters.isUserTask(), this.configurationStartup.scenarioPath, this.configurationStartup.logLevel, this.configurationStartup.getWarmingUpServer().toMillis() / 1000L});
            try {
                String currentPath = new File(".").getCanonicalPath();
                logger.info("Local Path[{}]", (Object)currentPath);
            }
            catch (Exception e) {
                logger.error("Can't access Local Path : {} ", (Object)e.getMessage());
            }
            AutomatorStartup.this.runFixedWarmup();
            List<Object> scenarioList = AutomatorStartup.this.registerScenario();
            for (Object scenarioObject : scenarioList) {
                boolean pleaseTryAgain;
                Scenario scenario = null;
                if (scenarioObject instanceof File) {
                    File scenarioFile = (File)scenarioObject;
                    try {
                        scenario = this.automatorAPI.loadFromFile(scenarioFile);
                    }
                    catch (Exception e) {
                        logger.error("Error during accessing InputStream from File [{}]: {}", (Object)scenarioFile.getAbsolutePath(), (Object)e.getMessage());
                    }
                } else if (scenarioObject instanceof Resource) {
                    Resource scenarioResource = (Resource)scenarioObject;
                    try {
                        scenario = this.automatorAPI.loadFromInputStream(scenarioResource.getInputStream(), scenarioResource.getDescription());
                    }
                    catch (Exception e) {
                        logger.error("Error during accessing InputStream from resource [{}]: {}", (Object)scenarioResource.getDescription(), (Object)e.getMessage());
                    }
                }
                if (scenario == null) continue;
                logger.info("Start scenario [{}]", (Object)scenario.getName());
                int countEngineIsNotReady = 0;
                BpmnEngine bpmnEngine = null;
                do {
                    pleaseTryAgain = false;
                    ++countEngineIsNotReady;
                    String message = "";
                    try {
                        if (runParameters.isLevelDashboard()) {
                            logger.info("Connect to Bpmn Engine Type [{}] for scenario [{}]", (Object)scenario.getServerType(), (Object)scenario.getName());
                        }
                        if (!(bpmnEngine = this.automatorAPI.getBpmnEngineFromScenario(scenario, this.engineConfiguration)).isReady()) {
                            bpmnEngine.connection();
                        }
                    }
                    catch (AutomatorException e) {
                        pleaseTryAgain = true;
                        message = e.getMessage();
                    }
                    if (!pleaseTryAgain || countEngineIsNotReady >= 10) continue;
                    logger.info("Scenario [{}] file[{}] No BPM ENGINE running [{}] tentative:{}/10. Sleep 30s. Scenario reference serverName[{}] serverType[{}]", new Object[]{message, countEngineIsNotReady, scenario.getName(), scenario.getName(), scenario.getServerName(), scenario.getServerType()});
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (pleaseTryAgain && countEngineIsNotReady < 10);
                if (bpmnEngine == null) {
                    logger.error("Scenario [{}] file[{}] No BPM ENGINE running. Scenario reference serverName[{}] serverType[{}]", new Object[]{scenario.getName(), scenario.getName(), scenario.getServerName(), scenario.getServerType()});
                    continue;
                }
                bpmnEngine.turnHighFlowMode(true);
                logger.info("Scenario [{}] file[{}] use BpmnEngine {}", new Object[]{scenario.getName(), scenario.getName(), bpmnEngine.getSignature()});
                RunResult scenarioExecutionResult = this.automatorAPI.executeScenario(bpmnEngine, runParameters, scenario);
                logger.info("AutomatorStartup: end scenario [{}] in {} ms", (Object)scenario.getName(), (Object)scenarioExecutionResult.getTimeExecution());
                bpmnEngine.turnHighFlowMode(false);
            }
        }
    }
}

