/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services;

import java.util.List;
import java.util.stream.Collectors;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.services.dataoperation.DataOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDataOperation {
    @Autowired
    private List<DataOperation> listDataOperation;

    private ServiceDataOperation() {
    }

    public Object execute(String value, RunScenario runScenario, String context) throws AutomatorException {
        for (DataOperation dataOperation : this.listDataOperation) {
            if (!dataOperation.match(value)) continue;
            return dataOperation.execute(value, runScenario);
        }
        String helpOperations = this.listDataOperation.stream().map(DataOperation::getHelp).collect(Collectors.joining(", "));
        throw new AutomatorException(context + "No operation for [" + value + "] - operationExpected " + helpOperations);
    }
}

