/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.configuration.ConfigurationServersEngine;
import org.camunda.automator.engine.AutomatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@PropertySource(value={"classpath:application.yaml"})
public class ConfigurationBpmEngine {
    static Logger logger = LoggerFactory.getLogger(ConfigurationBpmEngine.class);
    @Value(value="${automator.logDebug:false}")
    public boolean logDebug = false;
    @Value(value="#{'${automator.serversconnection}'.split(';')}")
    public List<String> serversConnection;
    @Autowired
    ConfigurationServersEngine configurationServersEngine;
    private List<BpmnServerDefinition> allServers = new ArrayList();

    public void addExplicitServer(BpmnServerDefinition bpmnEngineConfiguration) {
        this.allServers.add(bpmnEngineConfiguration);
    }

    @PostConstruct
    public void init() {
        this.allServers = new ArrayList();
        this.allServers.addAll(this.getFromServerConfiguration());
        try {
            List listFromConnection = this.decodeListServersConnection();
            this.allServers.addAll(listFromConnection);
            logger.info("ConfigurationBpmEngine: servers detected : {} ", (Object)this.allServers.size());
            for (BpmnServerDefinition server : this.allServers) {
                CamundaEngine camundaEngine = server.serverType;
                String serverDetails = "Server Type[" + camundaEngine + "] " + (String)(switch (1.$SwitchMap$org$camunda$automator$configuration$ConfigurationBpmEngine$CamundaEngine[server.serverType.ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> "ZeebeadressGateway [" + server.zeebeGatewayAddress + "]";
                    case 2 -> "ZeebeClientId [" + server.zeebeCloudClientId + "] ClusterId[" + server.zeebeCloudClusterId + "] RegionId[" + server.zeebeCloudRegion + "]";
                    case 3 -> "Camunda7URL [" + server.camunda7ServerUrl + "]";
                    case 4 -> "Dummy";
                });
                logger.info(serverDetails);
            }
        }
        catch (Exception e) {
            logger.error("Error during initialization");
        }
    }

    public List<BpmnServerDefinition> getListServers() {
        return this.allServers;
    }

    public BpmnServerDefinition getByServerName(String serverName) throws AutomatorException {
        Optional<BpmnServerDefinition> first = this.allServers.stream().filter(t -> t.name.equals(serverName)).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    public BpmnServerDefinition getByServerType(CamundaEngine serverType) throws AutomatorException {
        Optional<BpmnServerDefinition> first = this.allServers.stream().filter(t -> this.sameType(t.serverType, serverType)).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    private boolean sameType(CamundaEngine type1, CamundaEngine type2) {
        if (type1.equals((Object)CamundaEngine.CAMUNDA_8_SAAS)) {
            type1 = CamundaEngine.CAMUNDA_8;
        }
        if (type2.equals((Object)CamundaEngine.CAMUNDA_8_SAAS)) {
            type2 = CamundaEngine.CAMUNDA_8;
        }
        return type1.equals((Object)type2);
    }

    private List<BpmnServerDefinition> decodeListServersConnection() throws AutomatorException {
        ArrayList<BpmnServerDefinition> list = new ArrayList<BpmnServerDefinition>();
        for (String s : this.serversConnection) {
            if (s.isEmpty()) continue;
            BpmnServerDefinition bpmnServerDefinition = this.decodeServerConnection(s);
            if (bpmnServerDefinition.serverType == null) {
                logger.error("Server Type can't be detected in string [{}]", (Object)s);
                continue;
            }
            list.add(bpmnServerDefinition);
        }
        return list;
    }

    private BpmnServerDefinition decodeServerConnection(String connectionString) throws AutomatorException {
        StringTokenizer st = new StringTokenizer(connectionString, ",");
        BpmnServerDefinition bpmnServerDefinition = new BpmnServerDefinition();
        bpmnServerDefinition.name = st.hasMoreTokens() ? st.nextToken() : null;
        try {
            CamundaEngine camundaEngine = bpmnServerDefinition.serverType = st.hasMoreTokens() ? CamundaEngine.valueOf((String)st.nextToken()) : null;
            if (CamundaEngine.CAMUNDA_7.equals((Object)bpmnServerDefinition.serverType)) {
                bpmnServerDefinition.camunda7ServerUrl = st.hasMoreTokens() ? st.nextToken() : null;
            } else if (CamundaEngine.CAMUNDA_8.equals((Object)bpmnServerDefinition.serverType)) {
                bpmnServerDefinition.zeebeGatewayAddress = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUrl = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUserName = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUserPassword = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.taskListUrl = st.hasMoreTokens() ? st.nextToken() : null;
            } else if (CamundaEngine.CAMUNDA_8_SAAS.equals((Object)bpmnServerDefinition.serverType)) {
                bpmnServerDefinition.zeebeCloudRegister = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.zeebeCloudRegion = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.zeebeCloudClusterId = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.zeebeCloudClientId = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.clientSecret = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUrl = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUserName = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.operateUserPassword = st.hasMoreTokens() ? st.nextToken() : null;
                bpmnServerDefinition.taskListUrl = st.hasMoreTokens() ? st.nextToken() : null;
            }
            return bpmnServerDefinition;
        }
        catch (Exception e) {
            throw new AutomatorException("Can't decode string [" + connectionString + "] " + e.getMessage());
        }
    }

    private List<BpmnServerDefinition> getFromServerConfiguration() {
        BpmnServerDefinition camunda8;
        ArrayList<BpmnServerDefinition> list = new ArrayList<BpmnServerDefinition>();
        if (this.hasValue(this.configurationServersEngine.camunda7Url)) {
            BpmnServerDefinition camunda7 = new BpmnServerDefinition();
            camunda7.serverType = CamundaEngine.CAMUNDA_7;
            camunda7.name = this.configurationServersEngine.camunda7Name;
            camunda7.camunda7ServerUrl = this.configurationServersEngine.camunda7Url;
            camunda7.camunda7UserName = this.configurationServersEngine.camunda7UserName;
            camunda7.camunda7Password = this.configurationServersEngine.camunda7Password;
            camunda7.workerMaxJobsActive = this.parseInt("Camunda7.workerMaxJobsActive", this.configurationServersEngine.C7workerMaxJobsActive, -1);
            list.add(camunda7);
            logger.info("Configuration: Camunda7 Name[{}] url[{}] MaxJobsActive[{}]", new Object[]{camunda7.name, camunda7.camunda7ServerUrl, camunda7.workerMaxJobsActive});
        }
        if (this.hasValue(this.configurationServersEngine.zeebeGatewayAddress)) {
            camunda8 = new BpmnServerDefinition();
            camunda8.serverType = CamundaEngine.CAMUNDA_8;
            camunda8.name = this.configurationServersEngine.zeebeName;
            camunda8.zeebeGatewayAddress = this.configurationServersEngine.zeebeGatewayAddress;
            camunda8.workerExecutionThreads = this.parseInt("Camunda8.workerExecutionThreads", this.configurationServersEngine.workerExecutionThreads, 101);
            camunda8.workerMaxJobsActive = this.parseInt("Camunda8.workerMaxJobsActive", this.configurationServersEngine.C8workerMaxJobsActive, -1);
            camunda8.operateUrl = this.configurationServersEngine.operateUrl;
            camunda8.operateUserName = this.configurationServersEngine.operateUserName;
            camunda8.operateUserPassword = this.configurationServersEngine.operateUserPassword;
            camunda8.taskListUrl = this.configurationServersEngine.taskListUrl;
            list.add(camunda8);
            logger.info("Configuration: Camunda8 Name[{}] zeebeGateway[{}] MaxJobsActive[{}] WorkerThreads[{}] OperateURL[{}]", new Object[]{camunda8.name, camunda8.camunda7ServerUrl, camunda8.workerMaxJobsActive, camunda8.workerExecutionThreads, camunda8.operateUrl});
        }
        if (this.hasValue(this.configurationServersEngine.zeebeCloudRegister)) {
            camunda8 = new BpmnServerDefinition();
            camunda8.zeebeCloudRegister = this.configurationServersEngine.zeebeCloudRegister;
            camunda8.zeebeCloudRegion = this.configurationServersEngine.zeebeCloudRegion;
            camunda8.zeebeCloudClusterId = this.configurationServersEngine.zeebeCloudClusterId;
            camunda8.zeebeCloudClientId = this.configurationServersEngine.zeebeCloudClientId;
            camunda8.clientSecret = this.configurationServersEngine.clientSecret;
            camunda8.operateUrl = this.configurationServersEngine.operateUrl;
            camunda8.operateUserName = this.configurationServersEngine.operateUserName;
            camunda8.operateUserPassword = this.configurationServersEngine.operateUserPassword;
            camunda8.taskListUrl = this.configurationServersEngine.taskListUrl;
            list.add(camunda8);
        }
        return list;
    }

    private int parseInt(String label, String value, int defaultValue) {
        try {
            if (value.equals("''")) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.error("Can't parse value [{}] at [{}]", (Object)value, (Object)label);
            return defaultValue;
        }
    }

    private boolean hasValue(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals("''")) {
            return false;
        }
        return !value.trim().isEmpty();
    }
}

