/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.configuration;

import java.time.Duration;
import java.util.List;
import org.camunda.automator.engine.RunParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:application.yaml"})
@Configuration
public class ConfigurationStartup {
    static Logger logger = LoggerFactory.getLogger(ConfigurationStartup.class);
    @Value(value="#{'${automator.startup.scenarioAtStartup:''}'.split(';')}")
    public List<String> scenarioAtStartup;
    @Value(value="#{'${automator.startup.filterService:''}'.split(';')}")
    public List<String> filterService;
    @Value(value="${automator.startup.scenarioPath}")
    public String scenarioPath;
    @Value(value="${automator.startup.logLevel:MONITORING}")
    public String logLevel;
    @Value(value="${automator.startup.deeptracking:false}")
    public boolean deepTracking;
    @Value(value="${automator.startup.policyExecution:DEPLOYPROCESS|WARMINGUP|CREATION|SERVICETASK|USERTASK}")
    public String policyExecution;
    @Value(value="${automator.startup.waitWarmUpServer:PT0S}")
    public String waitWarmupServer;

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public RunParameters.LOGLEVEL getLogLevelEnum() {
        try {
            return RunParameters.LOGLEVEL.valueOf((String)this.logLevel);
        }
        catch (Exception e) {
            logger.error("Unknow LogLevel (automator.startup.loglevel) : [{}} ", (Object)this.logLevel);
            return RunParameters.LOGLEVEL.MONITORING;
        }
    }

    public boolean deepTracking() {
        return this.deepTracking;
    }

    public boolean isPolicyExecutionCreation() {
        String policyExtended = "|" + this.policyExecution + "|";
        return policyExtended.contains("|CREATION|");
    }

    public boolean isPolicyExecutionServiceTask() {
        String policyExtended = "|" + this.policyExecution + "|";
        return policyExtended.contains("|SERVICETASK|");
    }

    public boolean isPolicyExecutionUserTask() {
        String policyExtended = "|" + this.policyExecution + "|";
        return policyExtended.contains("|USERTASK|");
    }

    public boolean isPolicyExecutionWarmingUp() {
        String policyExtended = "|" + this.policyExecution + "|";
        return policyExtended.contains("|WARMINGUP|");
    }

    public boolean isPolicyDeployProcess() {
        String policyExtended = "|" + this.policyExecution + "|";
        return policyExtended.contains("|DEPLOYPROCESS|");
    }

    public List<String> getFilterService() {
        return this.filterService;
    }

    public Duration getWarmingUpServer() {
        try {
            return Duration.parse(this.waitWarmupServer);
        }
        catch (Exception e) {
            logger.error("Can't parse warmup [{}]", (Object)this.waitWarmupServer);
            return Duration.ZERO;
        }
    }
}

