/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioVerificationBasic;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunResult {
    private final RunScenario runScenario;
    private final List<ErrorDescription> listErrors = new ArrayList();
    private final List<StepExecution> listDetailsSteps = new ArrayList();
    private final List<VerificationStatus> listVerifications = new ArrayList();
    private final List<String> listProcessInstancesId = new ArrayList();
    private final List<String> listProcessIdDeployed = new ArrayList();
    Logger logger = LoggerFactory.getLogger(RunResult.class);
    private Map<String, RecordCreationPI> recordCreationPIMap = new HashMap();
    private int numberOfSteps = 0;
    private int numberOfErrorSteps = 0;
    private long timeExecution;

    public RunResult(RunScenario runScenario) {
        this.runScenario = runScenario;
    }

    public void addProcessInstanceId(String processId, String processInstanceId) {
        this.listProcessInstancesId.add(processInstanceId);
        RecordCreationPI create = this.recordCreationPIMap.getOrDefault(processId, new RecordCreationPI(processId));
        ++create.nbCreated;
        this.recordCreationPIMap.put(processId, create);
    }

    public void registerAddProcessInstance(String processId, boolean withSuccess) {
        RecordCreationPI create = this.recordCreationPIMap.getOrDefault(processId, new RecordCreationPI(processId));
        if (withSuccess) {
            ++create.nbCreated;
        } else {
            ++create.nbFailed;
        }
        this.recordCreationPIMap.put(processId, create);
    }

    public void addTimeExecution(long timeToAdd) {
        this.timeExecution += timeToAdd;
    }

    public void addStepExecution(ScenarioStep step, long timeExecution) {
        this.addTimeExecution(timeExecution);
        ++this.numberOfSteps;
        if (this.runScenario.getRunParameters().isLevelInfo()) {
            StepExecution scenarioExecution = new StepExecution(this);
            scenarioExecution.step = step;
            this.listDetailsSteps.add(scenarioExecution);
        }
    }

    public void registerAddStepExecution() {
        ++this.numberOfSteps;
    }

    public void registerAddErrorStepExecution() {
        ++this.numberOfErrorSteps;
    }

    public List<ErrorDescription> getListErrors() {
        return this.listErrors;
    }

    public void addError(ScenarioStep step, String explanation) {
        this.listErrors.add(new ErrorDescription(step, explanation));
        this.logger.error((step == null ? "" : step.getType().toString()) + " " + explanation);
    }

    public void addError(ScenarioStep step, AutomatorException e) {
        this.listErrors.add(new ErrorDescription(step, e.getMessage()));
    }

    public void addVerification(ScenarioVerificationBasic verification, boolean isSuccess, String message) {
        VerificationStatus verificationStatus = new VerificationStatus(this);
        verificationStatus.verification = verification;
        verificationStatus.isSuccess = isSuccess;
        verificationStatus.message = message;
        this.listVerifications.add(verificationStatus);
    }

    public List<VerificationStatus> getListVerifications() {
        return this.listVerifications;
    }

    public void add(RunResult result) {
        this.addTimeExecution(result.getTimeExecution());
        this.listErrors.addAll(result.listErrors);
        this.listVerifications.addAll(result.listVerifications);
        for (Map.Entry entry : result.recordCreationPIMap.entrySet()) {
            RecordCreationPI currentReference = this.recordCreationPIMap.getOrDefault(entry.getKey(), new RecordCreationPI((String)entry.getKey()));
            currentReference.nbFailed += ((RecordCreationPI)entry.getValue()).nbFailed;
            currentReference.nbCreated += ((RecordCreationPI)entry.getValue()).nbCreated;
            this.recordCreationPIMap.put((String)entry.getKey(), currentReference);
        }
        this.numberOfSteps += result.numberOfSteps;
        this.numberOfErrorSteps += result.numberOfErrorSteps;
        if (this.runScenario.getRunParameters() != null && this.runScenario.getRunParameters().isLevelInfo()) {
            this.listDetailsSteps.addAll(result.listDetailsSteps);
            this.listProcessInstancesId.addAll(result.listProcessInstancesId);
        }
    }

    public boolean isSuccess() {
        long nbVerificationErrors = this.listVerifications.stream().filter(t -> !t.isSuccess).count();
        return this.listErrors.isEmpty() && nbVerificationErrors == 0L;
    }

    public String getFirstProcessInstanceId() {
        return this.listProcessInstancesId.isEmpty() ? null : (String)this.listProcessInstancesId.get(0);
    }

    public List<String> getProcessInstanceId() {
        return this.listProcessInstancesId;
    }

    public long getTimeExecution() {
        return this.timeExecution;
    }

    public void setTimeExecution(long timeExecution) {
        this.timeExecution = timeExecution;
    }

    public List<String> getProcessIdDeployed() {
        return this.listProcessIdDeployed;
    }

    public void addDeploymentProcessId(String processId) {
        this.listProcessIdDeployed.add(processId);
    }

    public Map<String, RecordCreationPI> getRecordCreationPI() {
        return this.recordCreationPIMap;
    }

    public long getRecordCreationPIAllProcesses() {
        long sum = 0L;
        for (RecordCreationPI value : this.recordCreationPIMap.values()) {
            sum += value.nbCreated;
        }
        return sum;
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public int getNumberOfErrorSteps() {
        return this.numberOfErrorSteps;
    }

    public String getSynthesis(boolean fullDetail) {
        StringBuilder synthesis = new StringBuilder();
        synthesis.append(this.isSuccess() ? "SUCCESS " : "FAIL    ");
        synthesis.append(this.runScenario.getScenario().getName());
        synthesis.append("(");
        synthesis.append(this.runScenario.getScenario().getProcessId());
        synthesis.append("): ");
        synthesis.append(this.timeExecution);
        synthesis.append(" timeExecution(ms), ");
        synthesis.append(((RecordCreationPI)this.recordCreationPIMap.get((Object)this.runScenario.getScenario().getProcessId())).nbCreated);
        synthesis.append(" PICreated, ");
        synthesis.append(((RecordCreationPI)this.recordCreationPIMap.get((Object)this.runScenario.getScenario().getProcessId())).nbFailed);
        synthesis.append(" PIFailed, ");
        synthesis.append(this.numberOfSteps);
        synthesis.append(" stepsExecuted, ");
        synthesis.append(this.numberOfErrorSteps);
        synthesis.append(" errorStepsExecuted, ");
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(this.listErrors.stream().map(t -> (t.step != null ? t.step.toString() : "") + t.explanation + "\n").collect(Collectors.joining(",")));
        if (fullDetail) {
            synthesis.append((CharSequence)errorMessage);
        }
        StringBuilder verificationMessage = new StringBuilder();
        verificationMessage.append(this.listVerifications.stream().map(t -> t.verification.getSynthesis() + "? " + (t.isSuccess ? "OK" : "FAIL") + " " + t.message + "\n").collect(Collectors.joining(",")));
        if (fullDetail) {
            synthesis.append((CharSequence)verificationMessage);
        }
        if (fullDetail) {
            synthesis.append(" ListOfPICreated: ");
            synthesis.append(this.listProcessInstancesId.stream().collect(Collectors.joining(",")));
        }
        return synthesis.toString();
    }
}

