/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.camunda.automator.definition.ScenarioExecution;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.RunScenarioExecution;
import org.camunda.automator.engine.RunZeebeOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioExecution {
    private final Logger logger = LoggerFactory.getLogger(RunScenarioExecution.class);
    private final RunScenario runScenario;
    private final ScenarioExecution scnExecution;
    private String agentName = "";

    public RunScenarioExecution(RunScenario runScenario, ScenarioExecution scnExecution) {
        this.runScenario = runScenario;
        this.scnExecution = scnExecution;
    }

    public void setAgentName(String name) {
        this.agentName = name;
    }

    public RunResult runExecution() {
        RunResult resultExecution = new RunResult(this.runScenario);
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": Start Execution [" + this.scnExecution.getName() + "] ");
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.scnExecution.getNumberOfThreads());
        ArrayList listFutures = new ArrayList();
        for (int i = 0; i < this.scnExecution.getNumberProcessInstances(); ++i) {
            ScnThreadExecutionCallable scnThreadExecutionCallable = new ScnThreadExecutionCallable(this, "AutomatorThread-" + i, this, this.runScenario.getRunParameters());
            listFutures.add(executor.submit(scnThreadExecutionCallable));
        }
        try {
            for (Future future : listFutures) {
                Object scnRunResult = future.get();
                resultExecution.add((RunResult)scnRunResult);
            }
        }
        catch (Exception e) {
            resultExecution.addError(null, "Error during executing in parallel " + e.getMessage());
        }
        if (this.runScenario.getRunParameters().isLevelMonitoring()) {
            this.logger.info("ScnRunExecution." + this.agentName + ": End Execution [" + this.scnExecution.getName() + "] success? " + resultExecution.isSuccess());
        }
        return resultExecution;
    }

    public RunResult startEvent(RunResult result, ScenarioStep step) {
        try {
            result.addProcessInstanceId(step.getScnExecution().getScnHead().getProcessId(), this.runScenario.getBpmnEngine().createProcessInstance(step.getScnExecution().getScnHead().getProcessId(), step.getTaskId(), RunZeebeOperation.getVariablesStep((RunScenario)this.runScenario, (ScenarioStep)step)));
        }
        catch (AutomatorException e) {
            result.addError(step, "Error at creation " + e.getMessage());
        }
        return result;
    }

    public RunResult executeUserTask(RunResult result, ScenarioStep step) {
        if (step.getDelay() != null) {
            Duration duration = Duration.parse(step.getDelay());
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long waitingTimeInMs = null;
        if (step.getWaitingTime() != null) {
            Duration duration = Duration.parse(step.getWaitingTime());
            waitingTimeInMs = duration.toMillis();
        }
        if (waitingTimeInMs == null) {
            waitingTimeInMs = 300000L;
        }
        for (int index = 0; index < step.getNumberOfExecutions(); ++index) {
            long beginTimeWait = System.currentTimeMillis();
            try {
                List listActivities;
                do {
                    if (!(listActivities = this.runScenario.getBpmnEngine().searchUserTasks(result.getFirstProcessInstanceId(), step.getTaskId(), 1)).isEmpty()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                if (listActivities.isEmpty()) {
                    result.addError(step, "No user task show up task[" + step.getTaskId() + "] processInstance[" + result.getFirstProcessInstanceId() + "]");
                    return result;
                }
                this.runScenario.getBpmnEngine().executeUserTask((String)listActivities.get(0), step.getUserId(), RunZeebeOperation.getVariablesStep((RunScenario)this.runScenario, (ScenarioStep)step));
                continue;
            }
            catch (AutomatorException e) {
                result.addError(step, e.getMessage());
                return result;
            }
        }
        return result;
    }

    public RunResult executeServiceTask(RunResult result, ScenarioStep step) {
        if (step.getDelay() != null) {
            Duration duration = Duration.parse(step.getDelay());
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long waitingTimeInMs = null;
        if (step.getWaitingTime() != null) {
            Duration duration = Duration.parse(step.getWaitingTime());
            waitingTimeInMs = duration.toMillis();
        }
        if (waitingTimeInMs == null) {
            waitingTimeInMs = 300000L;
        }
        for (int index = 0; index < step.getNumberOfExecutions(); ++index) {
            long beginTimeWait = System.currentTimeMillis();
            try {
                List listActivities;
                do {
                    if (!(listActivities = this.runScenario.getBpmnEngine().searchServiceTasks(result.getFirstProcessInstanceId(), step.getTaskId(), step.getTopic(), 1)).isEmpty()) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (listActivities.isEmpty() && System.currentTimeMillis() - beginTimeWait < waitingTimeInMs);
                if (listActivities.isEmpty()) {
                    result.addError(step, "No service task show up task[" + step.getTaskId() + "] processInstance[" + result.getFirstProcessInstanceId() + "]");
                    return result;
                }
                this.runScenario.getBpmnEngine().executeServiceTask((String)listActivities.get(0), step.getUserId(), RunZeebeOperation.getVariablesStep((RunScenario)this.runScenario, (ScenarioStep)step));
                continue;
            }
            catch (AutomatorException e) {
                result.addError(step, e.getMessage());
                return result;
            }
        }
        return result;
    }
}

