/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.time.Duration;
import java.util.concurrent.Semaphore;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.bpmnengine.camunda8.BenchmarkCompleteJobExceptionHandlingStrategy;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.FixedBackoffSupplier;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.camunda.automator.engine.flow.RunScenarioFlowServiceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioFlowServiceTask
extends RunScenarioFlowBasic {
    private final TaskScheduler scheduler;
    private static final TrackActiveWorker trackActiveWorkers = new TrackActiveWorker();
    private static final TrackActiveWorker trackAsynchronousWorkers = new TrackActiveWorker();
    Logger logger = LoggerFactory.getLogger(RunScenarioFlowServiceTask.class);
    private BpmnEngine.RegisteredTask registeredTask;
    private boolean stopping;
    @Autowired
    private BenchmarkCompleteJobExceptionHandlingStrategy exceptionHandlingStrategy;
    private Semaphore semaphore;

    public RunScenarioFlowServiceTask(TaskScheduler scheduler, ScenarioStep scenarioStep, int index, RunScenario runScenario, RunResult runResult) {
        super(scenarioStep, index, runScenario, runResult);
        this.scheduler = scheduler;
        this.semaphore = new Semaphore(runScenario.getBpmnEngine().getWorkerExecutionThreads());
    }

    public void execute() {
        this.registerWorker();
    }

    public void pleaseStop() {
        this.logger.info("Ask Stopping [" + this.getId() + "]");
        this.stopping = true;
        if (this.registeredTask == null || this.registeredTask.isNull()) {
            return;
        }
        if (this.registeredTask.isClosed()) {
            return;
        }
        this.registeredTask.close();
        Duration durationSleep = this.getScenarioStep().getWaitingTimeDuration(Duration.ZERO);
        long expectedEndTime = System.currentTimeMillis() + durationSleep.toMillis();
        while (!this.registeredTask.isClosed() && System.currentTimeMillis() < expectedEndTime) {
            this.registeredTask.close();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.logger.info("[" + this.getId() + "] " + (this.registeredTask.isClosed() ? "stopped" : "Fail to stop"));
        this.registeredTask = null;
    }

    public RunScenarioFlowBasic.STATUS getStatus() {
        if (this.registeredTask == null) {
            return RunScenarioFlowBasic.STATUS.STOPPED;
        }
        if (this.stopping) {
            return RunScenarioFlowBasic.STATUS.STOPPING;
        }
        return RunScenarioFlowBasic.STATUS.RUNNING;
    }

    public int getCurrentNumberOfThreads() {
        return trackActiveWorkers.getCounter() + trackAsynchronousWorkers.getCounter();
    }

    private void registerWorker() {
        BpmnEngine bpmnEngine = this.getRunScenario().getBpmnEngine();
        Duration durationSleep = this.getScenarioStep().getWaitingTimeDuration(Duration.ZERO);
        durationSleep = durationSleep.plusSeconds(10L);
        this.registeredTask = bpmnEngine.registerServiceTask(this.getId(), this.getScenarioStep().getTopic(), durationSleep, (Object)new SimpleDelayHandler(this, this), new FixedBackoffSupplier(this.getScenarioStep().getFixedBackOffDelay()));
    }
}

