/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.time.Duration;
import java.time.Instant;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.camunda.automator.engine.flow.RunScenarioFlowStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class RunScenarioFlowStartEvent
extends RunScenarioFlowBasic {
    private final TaskScheduler scheduler;
    Logger logger = LoggerFactory.getLogger(RunScenarioFlowStartEvent.class);
    private boolean stopping;
    private boolean isRunning;
    private int stepNumber = 0;

    public RunScenarioFlowStartEvent(TaskScheduler scheduler, ScenarioStep scenarioStep, int index, RunScenario runScenario, RunResult runResult) {
        super(scenarioStep, index, runScenario, runResult);
        this.scheduler = scheduler;
    }

    public void execute() {
        this.stopping = false;
        this.isRunning = true;
        Duration duration = Duration.parse(this.getScenarioStep().getFrequency());
        StartEventRunnable startEventRunnable = new StartEventRunnable(this, this.scheduler, this.getScenarioStep(), this.runResult, this.getRunScenario(), this);
        this.scheduler.schedule((Runnable)startEventRunnable, Instant.now());
    }

    public void pleaseStop() {
        this.stopping = true;
    }

    public RunScenarioFlowBasic.STATUS getStatus() {
        if (!this.isRunning) {
            return RunScenarioFlowBasic.STATUS.STOPPED;
        }
        if (this.stopping) {
            return RunScenarioFlowBasic.STATUS.STOPPING;
        }
        return RunScenarioFlowBasic.STATUS.RUNNING;
    }

    public int getCurrentNumberOfThreads() {
        return 0;
    }

    public RunResult getRunResult() {
        return this.runResult;
    }
}

