/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.automator.bpmnengine.BpmnEngine;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.RunObjectives;
import org.camunda.automator.engine.flow.RunScenarioFlowBasic;
import org.camunda.automator.engine.flow.RunScenarioFlowServiceTask;
import org.camunda.automator.engine.flow.RunScenarioFlowStartEvent;
import org.camunda.automator.engine.flow.RunScenarioFlows;
import org.camunda.automator.engine.flow.RunScenarioWarmingUp;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioFlows {
    private final ServiceAccess serviceAccess;
    private final RunScenario runScenario;
    Logger logger = LoggerFactory.getLogger(RunScenarioFlows.class);
    private final Map<String, Long> previousValueMap = new HashMap();

    public RunScenarioFlows(ServiceAccess serviceAccess, RunScenario runScenario) {
        this.serviceAccess = serviceAccess;
        this.runScenario = runScenario;
    }

    public void execute(RunResult runResult) {
        RunScenarioWarmingUp runScenarioWarmingUp = new RunScenarioWarmingUp(this.serviceAccess, this.runScenario);
        HashMap recordCreationPIMap = new HashMap();
        RunObjectives runObjectives = new RunObjectives(this.runScenario.getScenario().getFlowControl().getObjectives(), this.runScenario.getBpmnEngine(), recordCreationPIMap);
        this.logger.info("ScenarioFlow: ------ WarmingUp");
        runScenarioWarmingUp.warmingUp();
        Date startTestDate = new Date();
        runObjectives.setStartDate(startTestDate);
        this.logger.info("ScenarioFlow: ------ Start");
        List listFlows = this.startExecution();
        this.waitEndExecution(runObjectives, startTestDate, listFlows);
        Date endTestDate = new Date();
        runObjectives.setEndDate(endTestDate);
        this.logger.info("ScenarioFlow: ------ Stop");
        this.stopExecution(listFlows);
        this.logger.info("ScenarioFlow: ------ CollectData");
        this.collectInformation(listFlows, runResult, recordCreationPIMap);
        this.logger.info("ScenarioFlow: ------ CheckObjectives");
        if (this.runScenario.getScenario().getFlowControl() != null && this.runScenario.getScenario().getFlowControl().getObjectives() != null) {
            this.checkObjectives(runObjectives, startTestDate, endTestDate, runResult);
        }
        this.logger.info("ScenarioFlow: ------ TheEnd");
    }

    private List<RunScenarioFlowBasic> startExecution() {
        ArrayList<RunScenarioFlowBasic> listFlows = new ArrayList<RunScenarioFlowBasic>();
        for (ScenarioStep scenarioStep : this.runScenario.getScenario().getFlows()) {
            if (ScenarioStep.Step.STARTEVENT.equals((Object)scenarioStep.getType())) {
                if (!this.runScenario.getRunParameters().creation) {
                    this.logger.info("According configuration, STARTEVENT[" + scenarioStep.getProcessId() + "] is fully disabled");
                } else {
                    for (int i = 0; i < scenarioStep.getNbWorkers(); ++i) {
                        RunScenarioFlowStartEvent runStartEvent = new RunScenarioFlowStartEvent(this.serviceAccess.getTaskScheduler(scenarioStep.getProcessId() + "-" + i), scenarioStep, i, this.runScenario, new RunResult(this.runScenario));
                        runStartEvent.execute();
                        listFlows.add((RunScenarioFlowBasic)runStartEvent);
                    }
                }
            }
            if (!ScenarioStep.Step.SERVICETASK.equals((Object)scenarioStep.getType())) continue;
            if (!this.runScenario.getRunParameters().servicetask) {
                this.logger.info("According configuration, SERVICETASK[{}] is fully disabled", (Object)scenarioStep.getTopic());
                continue;
            }
            if (this.runScenario.getRunParameters().blockExecutionServiceTask(scenarioStep.getTopic())) {
                this.logger.info("According configuration, SERVICETASK[{}] is disabled (only acceptable {})", (Object)scenarioStep.getTopic(), (Object)this.runScenario.getRunParameters().filterServiceTask);
                continue;
            }
            RunScenarioFlowServiceTask runStartEvent = new RunScenarioFlowServiceTask(this.serviceAccess.getTaskScheduler("serviceTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
            runStartEvent.execute();
            listFlows.add((RunScenarioFlowBasic)runStartEvent);
        }
        return listFlows;
    }

    private void waitEndExecution(RunObjectives runObjectives, Date startTestDate, List<RunScenarioFlowBasic> listFlows) {
        Duration durationExecution = this.runScenario.getScenario().getFlowControl().getDuration();
        Duration durationWarmingUp = Duration.ZERO;
        if (!this.runScenario.getRunParameters().warmingUp && this.runScenario.getScenario().getWarmingUp() != null) {
            durationWarmingUp = this.runScenario.getScenario().getWarmingUp().getDuration();
        }
        long endTimeExpected = startTestDate.getTime() + durationExecution.getSeconds() * 1000L + durationWarmingUp.getSeconds() * 1000L;
        this.logger.info("Start: FixedWarmingUp {} s ExecutionDuration {} s (total {} s)", new Object[]{durationWarmingUp.getSeconds(), durationExecution.getSeconds(), durationWarmingUp.getSeconds() + durationExecution.getSeconds()});
        while (System.currentTimeMillis() < endTimeExpected) {
            long currentTime = System.currentTimeMillis();
            long sleepTime = Math.min(30000L, endTimeExpected - currentTime);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int advancement = (int)(100.0 * (double)(currentTime - startTestDate.getTime()) / (double)(endTimeExpected - startTestDate.getTime()));
            runObjectives.heartBeat();
            this.logRealTime(listFlows, endTimeExpected - System.currentTimeMillis(), advancement);
        }
    }

    private void stopExecution(List<RunScenarioFlowBasic> listFlows) {
        this.logger.info("End - wait end FlowBasic");
        for (RunScenarioFlowBasic flowBasic : listFlows) {
            flowBasic.pleaseStop();
        }
        long numberOfActives = listFlows.size();
        int count = 0;
        while (numberOfActives > 0L && count < 100) {
            ++count;
            numberOfActives = listFlows.stream().filter(t -> !t.getStatus().equals((Object)RunScenarioFlowBasic.STATUS.STOPPED)).count();
            if (numberOfActives <= 0L) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                numberOfActives = 0L;
            }
        }
    }

    private void collectInformation(List<RunScenarioFlowBasic> listFlows, RunResult runResult, Map<String, RunResult.RecordCreationPI> recordCreationPIMap) {
        this.logger.info("CollectData : listFlows[{}]", (Object)listFlows.size());
        for (RunScenarioFlowBasic flowBasic : listFlows) {
            RunResult runResultFlow = flowBasic.getRunResult();
            runResult.add(runResultFlow);
            if (!(flowBasic instanceof RunScenarioFlowStartEvent)) continue;
            String processId = flowBasic.getScenarioStep().getProcessId();
            RunResult.RecordCreationPI recordFlow = (RunResult.RecordCreationPI)runResultFlow.getRecordCreationPI().get(processId);
            RunResult.RecordCreationPI recordCreationPI = recordCreationPIMap.getOrDefault(processId, new RunResult.RecordCreationPI(processId));
            recordCreationPI.add(recordFlow);
            recordCreationPIMap.put(processId, recordCreationPI);
            this.logger.info("CollectData : StartEvent, processId[{}] PICreated[{}] PIFailed[{}]", new Object[]{processId, recordFlow.nbCreated, recordFlow.nbFailed});
        }
    }

    private void checkObjectives(RunObjectives runObjectives, Date startTestDate, Date endTestDate, RunResult runResult) {
        this.logger.info("CollectingData...");
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List listCheckResult = runObjectives.check();
        for (RunObjectives.ObjectiveResult checkResult : listCheckResult) {
            if (checkResult.success) {
                this.logger.info("Objective: SUCCESS type {} label [{}} processId[{}] reach {} (objective is {} ) analysis [{}}", new Object[]{checkResult.objective.type, checkResult.objective.label, checkResult.objective.processId, checkResult.recordedSuccessValue, checkResult.objective.value, checkResult.analysis});
                continue;
            }
            runResult.addError(null, "Objective: FAIL " + checkResult.objective.label + " type " + checkResult.objective.type + " processId [" + checkResult.objective.processId + "] " + checkResult.analysis);
        }
    }

    private void logRealTime(List<RunScenarioFlowBasic> listFlows, long timeToFinishInMs, int percentAdvancement) {
        this.logger.info("------------ Log advancement at {} ----- {} %, end in {} s", new Object[]{new Date(), percentAdvancement, timeToFinishInMs / 1000L});
        for (RunScenarioFlowBasic flowBasic : listFlows) {
            RunResult runResultFlow = flowBasic.getRunResult();
            int currentNumberOfThreads = flowBasic.getCurrentNumberOfThreads();
            if (runResultFlow.getRecordCreationPIAllProcesses() + (long)runResultFlow.getNumberOfSteps() + (long)runResultFlow.getNumberOfErrorSteps() == 0L && currentNumberOfThreads == 0) continue;
            long previousValue = this.previousValueMap.getOrDefault(flowBasic.getId(), 0L);
            ScenarioStep scenarioStep = flowBasic.getScenarioStep();
            String key = "[" + flowBasic.getId() + "] " + flowBasic.getStatus().toString() + "  currentNbThreads[" + currentNumberOfThreads + "] ";
            key = key + (String)(switch (1.$SwitchMap$org$camunda$automator$definition$ScenarioStep$Step[scenarioStep.getType().ordinal()]) {
                case 1 -> "PI[" + runResultFlow.getRecordCreationPI() + "] delta[" + (((RunResult.RecordCreationPI)runResultFlow.getRecordCreationPI().get((Object)flowBasic.getScenarioStep().getProcessId())).nbCreated - previousValue) + "]";
                case 2 -> "StepsExecuted[" + runResultFlow.getNumberOfSteps() + "] delta [" + ((long)runResultFlow.getNumberOfSteps() - previousValue) + "] StepsErrors[" + runResultFlow.getNumberOfErrorSteps() + "]";
                default -> "]";
            });
            this.logger.info(key);
            switch (1.$SwitchMap$org$camunda$automator$definition$ScenarioStep$Step[scenarioStep.getType().ordinal()]) {
                case 1: {
                    this.previousValueMap.put(flowBasic.getId(), ((RunResult.RecordCreationPI)runResultFlow.getRecordCreationPI().get((Object)flowBasic.getScenarioStep().getProcessId())).nbCreated);
                    break;
                }
                case 2: {
                    this.previousValueMap.put(flowBasic.getId(), Long.valueOf(runResultFlow.getNumberOfSteps()));
                    break;
                }
            }
        }
        int nbThreadsServiceTask = 0;
        int nbThreadsAutomator = 0;
        int nbThreadsTimeWaiting = 0;
        int nbThreadsWaiting = 0;
        int nbThreadsTimeRunnable = 0;
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            boolean isZeebe = false;
            boolean isServiceTask = false;
            boolean isAutomator = false;
            for (StackTraceElement ste : entry.getValue()) {
                if (ste.getClassName().contains("io.camunda")) {
                    isZeebe = true;
                    continue;
                }
                if (ste.getClassName().contains(RunScenarioFlowServiceTask.SimpleDelayHandler.class.getName())) {
                    isServiceTask = true;
                    continue;
                }
                if (!ste.getClassName().contains(".automator.")) continue;
                isAutomator = true;
            }
            if (!isZeebe && !isServiceTask && !isAutomator) continue;
            if (isServiceTask) {
                ++nbThreadsServiceTask;
                continue;
            }
            if (isAutomator) {
                ++nbThreadsAutomator;
                continue;
            }
            if (entry.getKey().getState().equals((Object)Thread.State.TIMED_WAITING)) {
                ++nbThreadsTimeWaiting;
                continue;
            }
            if (entry.getKey().getState().equals((Object)Thread.State.WAITING)) {
                ++nbThreadsTimeWaiting;
                continue;
            }
            if (entry.getKey().getState().equals((Object)Thread.State.RUNNABLE)) {
                ++nbThreadsTimeRunnable;
                continue;
            }
            this.logger.info(" {} {}", (Object)entry.getKey(), (Object)entry.getKey().getState());
            for (StackTraceElement ste : entry.getValue()) {
                this.logger.info("\tat {}", (Object)ste);
            }
        }
        BpmnEngine bpmnEngine = this.runScenario.getBpmnEngine();
        int workerExecutionThreads = bpmnEngine.getWorkerExecutionThreads();
        if (nbThreadsServiceTask + nbThreadsTimeWaiting + nbThreadsWaiting + nbThreadsTimeRunnable + nbThreadsAutomator > 0) {
            this.logger.info("Threads: ServiceTaskExecution (ThreadService/maxJobActive) [{}/{}] {} % Automator[{}] TIME_WAITING[{}] WAITING[{}] RUNNABLE[{}] ", new Object[]{nbThreadsServiceTask, workerExecutionThreads, workerExecutionThreads == 0 ? 0 : (int)(100.0 * (double)nbThreadsServiceTask / (double)workerExecutionThreads), nbThreadsAutomator, nbThreadsTimeWaiting, nbThreadsWaiting, nbThreadsTimeRunnable});
        }
    }
}

