/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.engine.flow;

import java.util.ArrayList;
import org.camunda.automator.definition.ScenarioStep;
import org.camunda.automator.definition.ScenarioWarmingUp;
import org.camunda.automator.engine.RunResult;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.engine.flow.RunScenarioFlowServiceTask;
import org.camunda.automator.engine.flow.RunScenarioWarmingUp;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunScenarioWarmingUp {
    private final ServiceAccess serviceAccess;
    private final RunScenario runScenario;
    Logger logger = LoggerFactory.getLogger(RunScenarioWarmingUp.class);

    RunScenarioWarmingUp(ServiceAccess serviceAccess, RunScenario runScenario) {
        this.serviceAccess = serviceAccess;
        this.runScenario = runScenario;
    }

    public void warmingUp() {
        ScenarioWarmingUp warmingUp = this.runScenario.getScenario().getWarmingUp();
        if (warmingUp == null) {
            this.logger.info("WarmingUp not present in scenario");
            return;
        }
        if (!this.runScenario.getRunParameters().warmingUp) {
            this.logger.info("WarmingUp present, but not allowed to start");
            return;
        }
        long beginTime = System.currentTimeMillis();
        long endWarmingUp = beginTime + (warmingUp.getDuration().toMillis() > 0L ? warmingUp.getDuration().toMillis() : 600000L);
        this.logger.info("WarmingUp: Start ---- {} operations ", (Object)warmingUp.getOperations().size());
        ArrayList<RunScenarioFlowServiceTask> listWarmingUpServiceTask = new ArrayList<RunScenarioFlowServiceTask>();
        ArrayList<StartEventWarmingUpRunnable> listWarmingUpStartEvent = new ArrayList<StartEventWarmingUpRunnable>();
        block6: for (ScenarioStep scenarioStep : warmingUp.getOperations()) {
            switch (1.$SwitchMap$org$camunda$automator$definition$ScenarioStep$Step[scenarioStep.getType().ordinal()]) {
                case 1: {
                    this.logger.info("WarmingUp: StartEvent Generate {} Frequency [{}] EndWarmingUp [{}]", new Object[]{scenarioStep.getNumberOfExecutions(), scenarioStep.getFrequency(), scenarioStep.getEndWarmingUp()});
                    StartEventWarmingUpRunnable startEventWarmingUpRunnable = new StartEventWarmingUpRunnable(this, this.serviceAccess.getTaskScheduler("warmingUp"), scenarioStep, this.runScenario);
                    listWarmingUpStartEvent.add(startEventWarmingUpRunnable);
                    startEventWarmingUpRunnable.run();
                    continue block6;
                }
                case 2: {
                    this.logger.info("WarmingUp: Start Service Task topic[{}]", (Object)scenarioStep.getTopic());
                    RunScenarioFlowServiceTask task = new RunScenarioFlowServiceTask(this.serviceAccess.getTaskScheduler("serviceTask"), scenarioStep, 0, this.runScenario, new RunResult(this.runScenario));
                    task.execute();
                    listWarmingUpServiceTask.add(task);
                    continue block6;
                }
            }
            this.logger.info("WarmingUp: Unknown [{}]", (Object)scenarioStep.getType());
        }
        boolean warmingUpIsFinish = false;
        while (!warmingUpIsFinish) {
            long currentTime = System.currentTimeMillis();
            String analysis = " max in " + (endWarmingUp - currentTime) / 1000L + " s, ";
            if (currentTime >= endWarmingUp) {
                analysis = analysis + "Over maximum duration,";
                warmingUpIsFinish = true;
            }
            boolean allIsFinished = true;
            for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
                analysis = analysis + "warmingUp[" + startRunnable.scenarioStep.getTaskId() + "] instanceCreated[" + startRunnable.nbInstancesCreated + "]";
                if (startRunnable.warmingUpFinished) {
                    analysis = analysis + " FINISH!:" + startRunnable.warmingUpFinishedAnalysis;
                    continue;
                }
                allIsFinished = false;
            }
            if (allIsFinished) {
                warmingUpIsFinish = true;
            }
            this.logger.info("WarmingUpFinished? {} analysis: {}", (Object)warmingUpIsFinish, (Object)analysis);
            if (warmingUpIsFinish) continue;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (StartEventWarmingUpRunnable startRunnable : listWarmingUpStartEvent) {
            startRunnable.pleaseStop(true);
        }
        for (RunScenarioFlowServiceTask task : listWarmingUpServiceTask) {
            task.pleaseStop();
        }
        this.logger.info("WarmingUp: Complete ----");
    }
}

