/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services;

import java.time.Instant;
import javax.annotation.PostConstruct;
import org.camunda.automator.AutomatorAPI;
import org.camunda.automator.AutomatorCLI;
import org.camunda.automator.configuration.ConfigurationBpmEngine;
import org.camunda.automator.configuration.ConfigurationStartup;
import org.camunda.automator.services.AutomatorStartup;
import org.camunda.automator.services.ServiceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomatorStartup {
    static Logger logger = LoggerFactory.getLogger(AutomatorStartup.class);
    @Autowired
    ConfigurationStartup configurationStartup;
    @Autowired
    AutomatorAPI automatorAPI;
    @Autowired
    AutomatorCLI automatorCLI;
    @Autowired
    ConfigurationBpmEngine engineConfiguration;
    @Autowired
    ServiceAccess serviceAccess;

    @PostConstruct
    public void init() {
        if (AutomatorCLI.isRunningCLI) {
            return;
        }
        AutomatorSetupRunnable automatorSetupRunnable = new AutomatorSetupRunnable(this, this.configurationStartup, this.automatorAPI, this.automatorCLI, this.engineConfiguration);
        this.serviceAccess.getTaskScheduler("AutomatorSetup").schedule((Runnable)automatorSetupRunnable, Instant.now());
    }
}

