/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.automator.services.dataoperation;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.camunda.automator.engine.AutomatorException;
import org.camunda.automator.engine.RunScenario;
import org.camunda.automator.services.dataoperation.DataOperation;
import org.springframework.stereotype.Component;

@Component
public class DataOperationStringToDate
extends DataOperation {
    public static final String FCT_LOCALDATETIME = "LOCALDATETIME";
    public static final String FCT_DATETIME = "DATETIME";
    public static final String FCT_DATE = "DATE";
    public static final String FCT_ZONEDATETIME = "ZONEDATETIME";
    public static final String FCT_LOCALDATE = "LOCALDATE";
    public static String ISO_8601_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static String ISO_8601_DATE_FORMAT = "yyyy-MM-dd";

    public boolean match(String value) {
        return this.matchFunction(value, "stringtodate");
    }

    public Object execute(String value, RunScenario runScenario) throws AutomatorException {
        List args = this.extractArgument(value, true);
        if (args.size() != 2) {
            throw new AutomatorException("Bad argument: stringtodate(LOCALDATETIME|DATETIME|DATE|ZONEDATETIME|LOCALDATE, dateSt");
        }
        String formatArgs = ((String)args.get(0)).toUpperCase(Locale.ROOT);
        String valueArgs = (String)args.get(1);
        try {
            if (FCT_LOCALDATETIME.equals(formatArgs)) {
                return LocalDateTime.parse(valueArgs);
            }
            if (FCT_DATETIME.equals(formatArgs)) {
                SimpleDateFormat isoFormat = new SimpleDateFormat(ISO_8601_DATETIME_FORMAT);
                return isoFormat.parse(valueArgs);
            }
            if (FCT_DATE.equals(formatArgs)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_8601_DATE_FORMAT);
                dateFormat.setLenient(false);
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return dateFormat.parse(valueArgs, new ParsePosition(0));
            }
            if (FCT_ZONEDATETIME.equals(formatArgs)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(ISO_8601_DATETIME_FORMAT);
                return ZonedDateTime.parse(valueArgs, formatter);
            }
            if (FCT_LOCALDATE.equals(formatArgs)) {
                return LocalDate.parse(valueArgs, DateTimeFormatter.ofPattern(ISO_8601_DATE_FORMAT));
            }
            throw new AutomatorException("Unknown date formatter [" + formatArgs + "]");
        }
        catch (Exception e) {
            throw new AutomatorException("parsing error function[" + formatArgs + "] value[" + valueArgs + "] : " + e.getMessage());
        }
    }
}

